<?php
ct_add_custom_widget(
    array(
        'name' => 'ct_banner',
        'title' => esc_html__('Case Banner', 'bixol'),
        'icon' => 'eicon-posts-ticker',
        'categories' => array(Case_Theme_Core::CT_CATEGORY_NAME),
        'scripts' => array(
            'jquery-numerator',
            'ct-counter-widget-js',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'bixol'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Layout', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                '1' => 'Layout 1',
                                '2' => 'Layout 2',
                                '3' => 'Layout 3',
                            ],
                            'default' => '1',
                        ),
                        array(
                            'name' => 'style',
                            'label' => esc_html__('Style', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'style1' => 'Style 1',
                                'style2' => 'Style 2',
                                'style3' => 'Style 3',
                                'style4' => 'Style 4',
                                'style5' => 'Style 5',
                            ],
                            'default' => 'style1',
                            'condition' => [
                                'layout' => '1',
                            ],
                        ),
                        array(
                            'name' => 'banner_image',
                            'label' => esc_html__('Banner Image', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                        ),
                        array(
                            'name' => 'img_size',
                            'label' => esc_html__('Image Size', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'description' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height).',
                            'condition' => [
                                'layout' => ['2'],
                            ],
                        ),
                        array(
                            'name' => 'banner_image_two',
                            'label' => esc_html__('Banner Image Two', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                            'condition' => [
                                'style' => 'style3',
                                'layout' => '1',
                            ],
                        ),
                        array(
                            'name' => 'selected_icon',
                            'label' => esc_html__('Icon', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::ICONS,
                            'fa4compatibility' => 'icon',
                            'condition' => [
                                'style' => 'style2',
                                'layout' => '1',
                            ],
                        ),
                        array(
                            'name' => 'pxl_icon',
                            'label' => esc_html__('Icon', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::ICONS,
                            'fa4compatibility' => 'icon',
                            'condition' => [
                                'layout' => '3',
                            ],
                        ),
                        array(
                            'name' => 'banner_title',
                            'label' => esc_html__('Banner Title', 'bixol'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                        ),
                        array(
                            'name' => 'banner_phone',
                            'label' => esc_html__('Banner Phone Number', 'bixol'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'layout' => '3',
                            ],
                        ),
                        array(
                            'name' => 'banner_phone_link',
                            'label' => esc_html__('Banner Phone Link', 'bixol'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'layout' => '3',
                            ],
                        ),
                        array(
                            'name' => 'banner_desc',
                            'label' => esc_html__('Description', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::TEXTAREA,
                            'rows' => 10,
                            'show_label' => false,
                            'condition' => [
                                'layout' => '2',
                            ],
                        ),
                        array(
                            'name' => 'btn_text',
                            'label' => esc_html__('Button Text', 'bixol'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'layout' => '2',
                            ],
                        ),
                        array(
                            'name' => 'btn_link',
                            'label' => esc_html__('Button Link', 'bixol'),
                            'type' => \Elementor\Controls_Manager::URL,
                            'condition' => [
                                'layout' => '2',
                            ],
                        ),
                        array(
                            'name' => 'banner_number',
                            'label' => esc_html__('Banner Number', 'bixol'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'layout' => '1',
                            ],
                        ),
                        array(
                            'name' => 'banner_number_suffix',
                            'label' => esc_html__('Banner Suffix', 'bixol'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'style' => 'style4',
                                'layout' => '1',
                            ],
                        ),
                        array(
                            'name' => 'box_align',
                            'label' => esc_html__('Box Align', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'ps-right' => 'Right',
                                'ps-left' => 'Left',
                            ],
                            'default' => 'ps-right',
                            'condition' => [
                                'style' => 'style1',
                                'layout' => '1',
                            ],
                        ),
                        array(
                            'name' => 'box_color',
                            'label' => esc_html__('Box Color', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .ct-banner1.style2 .ct-banner-holder' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'style' => ['style2'],
                                'layout' => '1',
                            ],
                        ),
                        array(
                            'name' => 'theme_custom_font',
                            'label' => esc_html__( 'Theme Custom Font Family', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                '' => esc_html__( 'Inherit', 'bixol' ),
                                'ft-outfit-b' => esc_html__( 'Outfit Bold', 'bixol' ),
                                'ft-outfit-sb' => esc_html__( 'Outfit Semibold', 'bixol' ),
                                'ft-outfit-m' => esc_html__( 'Outfit Medium', 'bixol' ),
                                'ft-outfit-r' => esc_html__( 'Outfit Regular', 'bixol' ),
                            ],
                            'condition' => [
                                'style' => ['style5'],
                                'layout' => '1',
                            ],
                        ),
                        array(
                            'name' => 'ct_animate',
                            'label' => esc_html__('Case Animate', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => bixol_animate(),
                            'default' => '',
                        ),
                    ),
                ),
            ),
        ),
    ),
    get_template_directory() . '/elementor/core/widgets/'
);