<?php
$default_settings = [
    'title' => '',
    'position' => '',
    'social' => '',
    'bg' => '',
    'image' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);
?>
<div class="ct-wg-author">
    <div class="wg-author-dot1"></div>
    <div class="wg-author-dot2">
        <span></span>
        <span></span>
        <span></span>
    </div>
    <div class="ct-wg-author-inner bg-image" <?php if(!empty($bg['url'])) : ?>style="background-image: url('<?php echo esc_url($bg['url'])?>');"<?php endif; ?>>
    	<?php if(!empty($image['id'])) : 
    		$img  = ct_get_image_by_size( array(
                'attach_id'  => $image['id'],
                'thumb_size' => '300x300',
            ) );
            $thumbnail    = $img['thumbnail'];
    		?>
	        <div class="wg-author-avatar">
	            <?php echo wp_kses_post($thumbnail); ?>
	        </div>
	    <?php endif; ?>

        <?php if (!empty($title)) : ?>
            <h3 class="wg-author-name"><?php echo esc_html($title); ?></h3>
        <?php endif; ?>

        <?php if (!empty($position)): ?>
            <div class="wg-author-position">
                <?php echo wp_kses_post($position); ?>
            </div>
        <?php endif; ?>
        
        <?php if(!empty($social)):
            $team_social = json_decode($social, true); ?>
            <div class="wg-author-social">
                <?php foreach ($team_social as $value): ?>
                    <a href="<?php echo esc_url($value['url']); ?>"><i class="<?php echo esc_attr($value['icon']); ?>"></i></a>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>