<?php
$default_settings = [
    'date' => '2030/10/10',
];
$settings = array_merge($default_settings, $settings);
extract($settings); 
$month = esc_html__('Month', 'bixol');
$months = esc_html__('Months', 'bixol');
$day = esc_html__('Day', 'bixol');
$days = esc_html__('Days', 'bixol');
$hour = esc_html__('Hour', 'bixol');
$hours = esc_html__('Hours', 'bixol');
$minute = esc_html__('Minute', 'bixol');
$minutes = esc_html__('Minutes', 'bixol');
$second = esc_html__('Second', 'bixol');
$seconds = esc_html__('Seconds', 'bixol');
wp_enqueue_script('ct-countdown-config', get_template_directory_uri() . '/elementor/js/ct-countdown.js', array( 'jquery' ), 'all', true);
?>
<div class="ct-countdown-wrap">
	<div class="ct-countdown" 
		data-month="<?php echo esc_attr($month) ?>"
		data-months="<?php echo esc_attr($months) ?>"
		data-day="<?php echo esc_attr($day) ?>"
		data-days="<?php echo esc_attr($days) ?>"
		data-hour="<?php echo esc_attr($hour) ?>"
		data-hours="<?php echo esc_attr($hours) ?>"
		data-minute="<?php echo esc_attr($minute) ?>"
		data-minutes="<?php echo esc_attr($minutes) ?>"
		data-second="<?php echo esc_attr($second) ?>"
		data-seconds="<?php echo esc_attr($seconds) ?>">
		<div class="ct-countdown-inner" data-count-down="<?php echo esc_attr($date);?>"></div>
	</div>
</div>