<?php
$widget->add_render_attribute( 'selected_icon', 'class' );
$has_icon = ! empty( $settings['selected_icon'] );
if ( $has_icon ) {
    $widget->add_render_attribute( 'i', 'class', $settings['selected_icon'] );
    $widget->add_render_attribute( 'i', 'aria-hidden', 'true' );
}

$widget->add_render_attribute( 'description_text', 'class', 'item--description' );

$widget->add_inline_editing_attributes( 'title_text', 'none' );
$widget->add_inline_editing_attributes( 'description_text' );

$is_new = \Elementor\Icons_Manager::is_migration_allowed();

if ( ! empty( $settings['btn_link']['url'] ) ) {
    $widget->add_render_attribute( 'button', 'href', $settings['btn_link']['url'] );

    if ( $settings['btn_link']['is_external'] ) {
        $widget->add_render_attribute( 'button', 'target', '_blank' );
    }

    if ( $settings['btn_link']['nofollow'] ) {
        $widget->add_render_attribute( 'button', 'rel', 'nofollow' );
    }
}
?>
<div class="ct-fancy-box ct-fancy-box-layout6 <?php echo esc_attr($settings['ct_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['ct_animate_delay']); ?>ms">
    <div class="ct-fancy-main">
        <?php if ( $settings['icon_type'] == 'icon' && $has_icon ) : ?>
            <div class="item--icon">
                <?php if($is_new):
                    \Elementor\Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] );
                    else: ?>
                    <i <?php ct_print_html($widget->get_render_attribute_string( 'i' )); ?>></i>
                <?php endif; ?>
            </div>
        <?php endif; ?>
        <?php if ( $settings['icon_type'] == 'image' && !empty($settings['icon_image']['id']) ) : ?>
            <div class="item--icon">
                <?php $img_icon  = ct_get_image_by_size( array(
                        'attach_id'  => $settings['icon_image']['id'],
                        'thumb_size' => 'full',
                    ) );
                    $thumbnail_icon    = $img_icon['thumbnail'];
                echo ct_print_html($thumbnail_icon); ?>
            </div>
        <?php endif; ?>
        <div class="item--holder">
            <h3 class="item--title">
                <?php echo ct_print_html($settings['title_text']); ?>
            </h3>
            <div <?php ct_print_html($widget->get_render_attribute_string( 'description_text' )); ?>>
                <?php echo wp_trim_words( $settings['description_text'], 7, $more = null ); ?>
            </div>
        </div>
        <?php if(!empty($settings['order_item'])) : ?>
            <div class="item--order">
                <?php echo esc_attr($settings['order_item']); ?>
            </div>
        <?php endif; ?>
    </div>
    <div class="ct-fancy-hover">
        <?php if(!empty($settings['box_image']['url'])): ?>
            <div class="bg-image" style="background-image: url(<?php echo esc_url($settings['box_image']['url']); ?>);"></div>
        <?php endif;?>
        <h3 class="item--title">
            <?php echo ct_print_html($settings['title_text']); ?>
        </h3>
        <div <?php ct_print_html($widget->get_render_attribute_string( 'description_text' )); ?>>
            <?php echo wp_trim_words( $settings['description_text'], 100, $more = null ); ?>
        </div>
        <div class="item--meta">
            <?php if ( ! empty( $settings['btn_text'] ) ) { ?>
                <div class="item--link">
                    <a <?php ct_print_html($widget->get_render_attribute_string( 'button' )); ?>><?php echo esc_attr($settings['btn_text']); ?><i class="flaticon flaticon-arrow"></i></a>
                </div>
            <?php } ?>
            <?php if(!empty($settings['order_item'])) : ?>
                <div class="item--order">
                    <?php echo esc_attr($settings['order_item']); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>