<?php
$html_id = ct_get_element_id($settings);
$source = $widget->get_setting('source', '');
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
$post_ids = $widget->get_setting('post_ids', '');
extract(ct_get_posts_of_grid('post', [
    'source' => $source,
    'orderby' => $orderby,
    'order' => $order,
    'limit' => $limit,
    'post_ids' => $post_ids,
]));

$show_date = $widget->get_setting('show_date');
$show_comment = $widget->get_setting('show_comment');
$img_size = '150x131';
if($settings['style'] == 'style2') {
    $img_size = '150x107';
}
?>
<?php if (is_array($posts)): ?>
    <div id="<?php echo esc_attr($html_id) ?>" class="ct-latest-news1 <?php echo esc_attr($settings['style']); ?> <?php echo esc_attr($settings['ct_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['ct_animate_delay']); ?>ms">
        <?php
            foreach ($posts as $post):
            $img_id       = get_post_thumbnail_id( $post->ID );
            $img          = ct_get_image_by_size( array(
                'attach_id'  => $img_id,
                'thumb_size' => $img_size,
                'class' => 'no-lazyload'
            ) );
            $thumbnail    = $img['thumbnail']; 
            $comment_count = get_comments_number($post->ID); ?>
            <div class="grid--item">
                <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): 
                    $thumbnail_url = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false);
                    ?>
                    <div class="item--featured">
                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                            <?php echo wp_kses_post($thumbnail); ?>
                        </a>
                    </div>
                <?php endif; ?>
                <div class="item--holder">
                    <h5 class="item--title"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a></h5>
                    <?php if($show_date == 'true' || $show_comment == 'true' ) : ?>
                        <ul class="item--meta">
                            <?php if($show_date == 'true'): ?>
                                <li class="item-date">
                                    <i class="fac fac-calendar-alt"></i><?php $date_formart = get_option('date_format'); echo get_the_date($date_formart, $post->ID); ?>
                                </li>
                            <?php endif; ?>
                            <?php if($show_comment == 'true') : ?>
                                <li class="item--comment">
                                    <i class="far fac-comment"></i><?php echo get_comments_number($post->ID); ?> <?php echo esc_html__('Comments', 'bixol'); ?>
                                </li>
                            <?php endif; ?>
                        </ul>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>