<?php
$html_id = ct_get_element_id($settings);
$active_tab = $widget->get_setting('active_tab', 1);
$tabs = $widget->get_setting('tabs', '');
$is_new = \Elementor\Icons_Manager::is_migration_allowed();

if(isset($settings['tabs']) && !empty($settings['tabs']) && count($settings['tabs'])): ?>
    <div class="ct-tabs ct-tab-banner1">
        <div class="ct-tabs-title">
            <?php foreach ($settings['tabs'] as $key => $value): 
                $tab_title = isset($value['tab_title']) ? $value['tab_title'] : '';
                ?>
                <div class="ct-tab-title <?php if($active_tab == $key + 1) { echo 'active'; } ?>" data-target="#<?php echo esc_attr($html_id.$key); ?>">
                    <span><?php echo esc_attr($tab_title); ?></span>
                </div>
            <?php endforeach; ?>
        </div>
        <div class="ct-tabs-content">
            <?php foreach ($settings['tabs'] as $key => $value): 
                $box_banner = isset($value['box_banner']) ? $value['box_banner'] : '';
                $box_title = isset($value['box_title']) ? $value['box_title'] : '';
                $box_content = isset($value['box_content']) ? $value['box_content'] : '';
                $btn_text = isset($value['btn_text']) ? $value['btn_text'] : '';
                $btn_link = isset($value['btn_link']) ? $value['btn_link'] : '';
                $link_key = $widget->get_repeater_setting_key( 'title', 'value', $key );
                if ( ! empty( $btn_link['url'] ) ) {
                    $widget->add_render_attribute( $link_key, 'href', $btn_link['url'] );

                    if ( $btn_link['is_external'] ) {
                        $widget->add_render_attribute( $link_key, 'target', '_blank' );
                    }

                    if ( $btn_link['nofollow'] ) {
                        $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                    }
                }
                $link_attributes = $widget->get_render_attribute_string( $link_key );
                ?>
                <div id="<?php echo esc_attr($html_id.$key); ?>" class="ct-tab-content" <?php if($active_tab == $key + 1) { ?>style="display: block;"<?php } ?>>
                    
                    <div class="ct-tab-box">
                        <div class="ct-tab-box-holder bg-image">  
                            <h5 class="ct-tab-box-title"><?php echo esc_attr($box_title); ?></h5>
                            <div class="ct-tab-box-content"><?php echo esc_attr($box_content); ?></div>
                            <?php if(!empty($btn_text)) : ?>
                                <div class="ct-box-button">
                                    <a class="btn btn-secondary" <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php echo esc_attr($btn_text); ?></a>
                                </div>
                            <?php endif; ?>
                        </div>
                        <?php if(!empty($box_banner['url'])) : ?>
                            <div class="ct-tab-image bg-image" style="background-image: url(<?php echo esc_url($box_banner['url']); ?>);"></div>
                        <?php endif; ?>
                    </div>
                    
                </div>
            <?php endforeach; ?>
        </div>
    </div>
<?php endif; ?>