<?php
$widget->add_render_attribute( 'inner', [
    'class' => 'ct-carousel-inner',
] );

$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$arrows = $widget->get_setting('arrows');
$dots = $widget->get_setting('dots');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay', '');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');
if (is_rtl()) {
    $carousel_dir = 'true';
} else {
    $carousel_dir = 'false';
}
$widget->add_render_attribute( 'carousel', [
    'class' => 'ct-slick-carousel slick-arrow-style2',
    'data-arrows' => $arrows,
    'data-dots' => $dots,
    'data-pauseOnHover' => $pause_on_hover,
    'data-autoplay' => $autoplay,
    'data-autoplaySpeed' => $autoplay_speed,
    'data-infinite' => $infinite,
    'data-speed' => $speed,
    'data-colxs' => $col_xs,
    'data-colsm' => $col_sm,
    'data-colmd' => $col_md,
    'data-collg' => $col_lg,
    'data-colxl' => $col_xl,
    'data-dir' => $carousel_dir,
    'data-slidesToScroll' => $slides_to_scroll,
] );
?>
<?php if(isset($settings['testimonial']) && !empty($settings['testimonial']) && count($settings['testimonial'])): ?>
    <div class="ct-testimonial ct-testimonial-carousel1 <?php if($settings['style'] == 'style2') { echo 'ct-dots-style3 '; } echo esc_attr($settings['style']); ?> ct-slick-slider">
        <div <?php ct_print_html($widget->get_render_attribute_string( 'inner' )); ?>>
            <div <?php ct_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <?php foreach ($settings['testimonial'] as $value): 
                    $title = isset($value['title']) ? $value['title'] : '';
                    $position = isset($value['position']) ? $value['position'] : '';
                    $description = isset($value['description']) ? $value['description'] : '';
                    $image = isset($value['image']) ? $value['image'] : '';
                    $img = ct_get_image_by_size( array(
                        'attach_id'  => $image['id'],
                        'thumb_size' => '90x90',
                    ));
                    $thumbnail = $img['thumbnail']; ?>
                        <div class="slick-slide">
                            <div class="item--inner <?php echo esc_attr($settings['ct_animate']); ?>">
                                <div class="item--content">
                                    <div class="ct-hexagon"><span></span></div>
                                    <div class="item-icon"><i>“</i></div>
                                    <div class="item--description"><?php echo esc_html($description); ?></div>
                                    <div class="item-rating">
                                        <i class="fac fac-star"></i>
                                        <i class="fac fac-star"></i>
                                        <i class="fac fac-star"></i>
                                        <i class="fac fac-star"></i>
                                        <i class="fac fac-star"></i>
                                    </div>
                                </div>
                                <div class="item--holder">
                                    <?php if(!empty($image)) { ?>
                                        <div class="item--image">
                                            <div class="item--svg">
                                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 93 120">
                                                  <g>
                                                    <path class="ct-path1" d="M2.148,67.79c-6.5-3.873,3.333-51.582,35.7-64.084,7.869-3.039,20.244-5.27,32.042,0,9.869,4.409,22.9,15.479,20.141,25.634C88.282,35.8,80.316,41.292,73.556,40.326c-5.818-.832-7.942-6.419-11.9-8.24C42.754,23.4,9.5,72.173,2.148,67.79Z"/>
                                                    <path class="ct-path2" d="M90.259,52.506c6.5,3.874-3.333,51.582-35.7,64.084-7.869,3.039-20.244,5.269-32.042,0-9.869-4.409-22.9-15.479-20.141-25.634C4.124,84.5,12.091,79,18.851,79.97c5.818,0.832,7.942,6.419,11.9,8.239C49.652,96.9,82.9,48.123,90.259,52.506Z"/>
                                                  </g>
                                                </svg>
                                            </div>              
                                            <div class="item--image-inner">
                                                <?php echo wp_kses_post($thumbnail); ?>
                                            </div>
                                        </div>
                                    <?php } ?>
                                    <div class="item--meta">
                                        <h3 class="item--title">    
                                            <?php echo esc_attr($title); ?>
                                        </h3>
                                        <div class="item--position"><?php echo esc_attr($position); ?></div>
                                    </div>
                                </div>
                                
                           </div>
                        </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
<?php endif; ?>