<?php
$widget->add_render_attribute( 'inner', [
    'class' => 'ct-carousel-inner',
] );

$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$arrows = $widget->get_setting('arrows');
$dots = $widget->get_setting('dots');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay', '');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');
if (is_rtl()) {
    $carousel_dir = 'true';
} else {
    $carousel_dir = 'false';
}
$widget->add_render_attribute( 'carousel', [
    'class' => 'ct-slick-carousel slick-arrow-style2',
    'data-arrows' => $arrows,
    'data-dots' => $dots,
    'data-pauseOnHover' => $pause_on_hover,
    'data-autoplay' => $autoplay,
    'data-autoplaySpeed' => $autoplay_speed,
    'data-infinite' => $infinite,
    'data-speed' => $speed,
    'data-colxs' => $col_xs,
    'data-colsm' => $col_sm,
    'data-colmd' => $col_md,
    'data-collg' => $col_lg,
    'data-colxl' => $col_xl,
    'data-dir' => $carousel_dir,
    'data-slidesToScroll' => $slides_to_scroll,
] );
?>
<?php if(isset($settings['testimonial']) && !empty($settings['testimonial']) && count($settings['testimonial'])): ?>
    <div class="ct-testimonial ct-testimonial-carousel7 ct-slick-slider">
        <div <?php ct_print_html($widget->get_render_attribute_string( 'inner' )); ?>>
            <div <?php ct_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <?php foreach ($settings['testimonial'] as $value): 
                    $title = isset($value['title']) ? $value['title'] : '';
                    $position = isset($value['position']) ? $value['position'] : '';
                    $description = isset($value['description']) ? $value['description'] : '';
                    $image = isset($value['image']) ? $value['image'] : '';
                    $image_lg = isset($value['image_lg']) ? $value['image_lg'] : ''; ?>
                        <div class="slick-slide">
                            <div class="item--inner <?php echo esc_attr($settings['ct_animate']); ?>">
                                
                                <?php if(!empty($image_lg['id'])) {
                                    $img_lg = ct_get_image_by_size( array(
                                        'attach_id'  => $image_lg['id'],
                                        'thumb_size' => 'full',
                                    ));
                                    $thumbnail_lg = $img_lg['thumbnail']; ?>
                                    <div class="item--boxleft">
                                        <?php echo wp_kses_post($thumbnail_lg); ?>
                                    </div>
                                <?php } ?>

                                <div class="item--boxright">
                                    <svg width="90" height="90" viewBox="0 0 90 90" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M65.625 78.75C53.6467 78.75 45 68.8611 45.0003 54.2189C45.077 32.9446 61.07 17.9031 84.1421 15.0145C86.2826 14.7465 87.108 17.7118 85.1368 18.5883C76.2839 22.5248 71.8127 27.5201 71.2351 32.4644C70.8037 36.1584 72.8118 39.3942 75.3333 40.0001C81.8702 41.5709 86.25 49.7115 86.25 58.125C86.25 69.5159 77.0159 78.75 65.625 78.75Z" />
                                        <path d="M20.625 78.75C8.64673 78.75 1.80307e-05 68.8611 0.000305413 54.2189C0.0770208 32.9446 16.07 17.9031 39.1421 15.0145C41.2826 14.7465 42.108 17.7118 40.1368 18.5883C31.2839 22.5248 26.8127 27.5201 26.2351 32.4644C25.8037 36.1584 27.8118 39.3942 30.3333 40.0001C36.8702 41.5709 41.25 49.7115 41.25 58.125C41.25 69.5159 32.0159 78.75 20.625 78.75Z" />
                                    </svg>
                                    <div class="item--description"><?php echo esc_html($description); ?></div>
                                    <div class="item--footer">
                                        <div class="item--holder">
                                            <?php if(!empty($image['id'])) {
                                                $img = ct_get_image_by_size( array(
                                                    'attach_id'  => $image['id'],
                                                    'thumb_size' => '82x82',
                                                ));
                                                $thumbnail = $img['thumbnail']; ?>
                                                <div class="item--image">
                                                    <?php echo wp_kses_post($thumbnail); ?>
                                                </div>
                                            <?php } ?>
                                            <div class="item--meta">
                                                <h3 class="item--title">    
                                                    <?php echo esc_attr($title); ?>
                                                </h3>
                                                <div class="item--position"><?php echo esc_attr($position); ?></div>
                                            </div>
                                        </div>
                                        <div class="item-rating">
                                            <i class="fac fac-star"></i>
                                            <i class="fac fac-star"></i>
                                            <i class="fac fac-star"></i>
                                            <i class="fac fac-star"></i>
                                            <i class="fac fac-star"></i>
                                        </div>
                                    </div>
                                </div>
                           </div>
                        </div>
                <?php endforeach; ?>
            </div>
            <?php if($arrows == 'true') : ?>
                <div class="pxl-slick-arrow-wrap">
                    <div class="pxl-slick-arrow pxl-slick-prev">
                        <svg width="61" height="61" viewBox="0 0 61 61" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M57.5172 20.209C58.3374 19.8966 58.7529 18.9762 58.3981 18.1734C55.7426 12.1629 51.2091 7.15616 45.4579 3.91971C39.2439 0.422852 32.0012 -0.786379 24.9883 0.502145C17.9754 1.79067 11.6356 5.4955 7.07052 10.9728C2.50546 16.4502 0.00371073 23.3538 4.12106e-06 30.4841C-0.00370249 37.6144 2.49087 44.5207 7.05023 50.0028C11.6096 55.4849 17.9456 59.1963 24.9571 60.4921C31.9687 61.7879 39.2127 60.5862 45.4302 57.0958C51.1848 53.8654 55.7235 48.8633 58.3853 42.8556C58.7409 42.0531 58.3264 41.1324 57.5065 40.8191C56.6866 40.5058 55.7722 40.9189 55.4118 41.7192C53.0185 47.0336 48.9808 51.4575 43.8743 54.3242C38.3047 57.4509 31.8156 58.5273 25.5348 57.3666C19.2539 56.2058 13.5782 52.8811 9.49399 47.9703C5.40977 43.0596 3.17516 36.873 3.17848 30.4858C3.1818 24.0986 5.42284 17.9144 9.51216 13.0078C13.6015 8.10128 19.2806 4.78254 25.5627 3.62829C31.8448 2.47405 38.3327 3.55726 43.8991 6.6897C49.0026 9.56168 53.0357 13.9898 55.4234 19.3067C55.783 20.1074 56.6969 20.5214 57.5172 20.209Z" />
                            <path d="M37.3186 29.165L22.68 29.165L25.4225 26.4224C26.2102 25.6347 25.0286 24.4531 24.2408 25.2408L21.7431 27.7424L20.0758 29.4124C19.7527 29.7374 19.7527 30.2625 20.0758 30.5875L24.2408 34.7574C24.3993 34.9203 24.6174 35.0116 24.8447 35.0097C25.5949 35.0096 25.963 34.0959 25.4225 33.5757L22.6735 30.8332L37.3618 30.8332C38.5171 30.7759 38.4308 29.1075 37.3186 29.165Z" />
                        </svg>
                        <span><?php echo esc_html__('Prev', 'bixol'); ?></span>
                    </div> 
                    <div class="pxl-slick-arrow pxl-slick-next">
                        <span><?php echo esc_html__('Next', 'bixol'); ?></span>
                        <svg width="61" height="61" viewBox="0 0 61 61" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M57.5172 20.209C58.3374 19.8966 58.7529 18.9762 58.3981 18.1734C55.7426 12.1629 51.2091 7.15616 45.4579 3.91971C39.2439 0.422852 32.0012 -0.786379 24.9883 0.502145C17.9754 1.79067 11.6356 5.4955 7.07052 10.9728C2.50546 16.4502 0.00371073 23.3538 4.12106e-06 30.4841C-0.00370249 37.6144 2.49087 44.5207 7.05023 50.0028C11.6096 55.4849 17.9456 59.1963 24.9571 60.4921C31.9687 61.7879 39.2127 60.5862 45.4302 57.0958C51.1848 53.8654 55.7235 48.8633 58.3853 42.8556C58.7409 42.0531 58.3264 41.1324 57.5065 40.8191C56.6866 40.5058 55.7722 40.9189 55.4118 41.7192C53.0185 47.0336 48.9808 51.4575 43.8743 54.3242C38.3047 57.4509 31.8156 58.5273 25.5348 57.3666C19.2539 56.2058 13.5782 52.8811 9.49399 47.9703C5.40977 43.0596 3.17516 36.873 3.17848 30.4858C3.1818 24.0986 5.42284 17.9144 9.51216 13.0078C13.6015 8.10128 19.2806 4.78254 25.5627 3.62829C31.8448 2.47405 38.3327 3.55726 43.8991 6.6897C49.0026 9.56168 53.0357 13.9898 55.4234 19.3067C55.783 20.1074 56.6969 20.5214 57.5172 20.209Z" />
                            <path d="M37.3186 29.165L22.68 29.165L25.4225 26.4224C26.2102 25.6347 25.0286 24.4531 24.2408 25.2408L21.7431 27.7424L20.0758 29.4124C19.7527 29.7374 19.7527 30.2625 20.0758 30.5875L24.2408 34.7574C24.3993 34.9203 24.6174 35.0116 24.8447 35.0097C25.5949 35.0096 25.963 34.0959 25.4225 33.5757L22.6735 30.8332L37.3618 30.8332C38.5171 30.7759 38.4308 29.1075 37.3186 29.165Z" />
                        </svg>
                    </div>      
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php endif; ?>