<?php
/**
 * Register metabox for posts based on Redux Framework. Supported methods:
 *     isset_args( $post_type )
 *     set_args( $post_type, $redux_args, $metabox_args )
 *     add_section( $post_type, $sections )
 * Each post type can contains only one metabox. Pease note that each field id
 * leads by an underscore sign ( _ ) in order to not show that into Custom Field
 * Metabox from WordPress core feature.
 *
 * @param  CT_Post_Metabox $metabox
 */

/**
 * Get list menu.
 * @return array
 */
function bixol_get_nav_menu(){

    $menus = array(
        '' => esc_html__('Default', 'bixol')
    );

    $obj_menus = wp_get_nav_menus();

    foreach ($obj_menus as $obj_menu){
        $menus[$obj_menu->term_id] = $obj_menu->name;
    }

    return $menus;
}

add_action( 'ct_post_metabox_register', 'bixol_page_options_register' );

function bixol_page_options_register( $metabox ) {

	if ( ! $metabox->isset_args( 'post' ) ) {
		$metabox->set_args( 'post', array(
			'opt_name'            => 'post_option',
			'display_name'        => esc_html__( 'Post Settings', 'bixol' ),
			'show_options_object' => false,
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'product' ) ) {
		$metabox->set_args( 'product', array(
			'opt_name'            => 'product_option',
			'display_name'        => esc_html__( 'Product Settings', 'bixol' ),
			'show_options_object' => false,
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'page' ) ) {
		$metabox->set_args( 'page', array(
			'opt_name'            => bixol_get_page_opt_name(),
			'display_name'        => esc_html__( 'Page Settings', 'bixol' ),
			'show_options_object' => false,
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'ct_pf_audio' ) ) {
		$metabox->set_args( 'ct_pf_audio', array(
			'opt_name'     => 'post_format_audio',
			'display_name' => esc_html__( 'Audio', 'bixol' ),
			'class'        => 'fully-expanded',
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'ct_pf_link' ) ) {
		$metabox->set_args( 'ct_pf_link', array(
			'opt_name'     => 'post_format_link',
			'display_name' => esc_html__( 'Link', 'bixol' )
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'ct_pf_quote' ) ) {
		$metabox->set_args( 'ct_pf_quote', array(
			'opt_name'     => 'post_format_quote',
			'display_name' => esc_html__( 'Quote', 'bixol' )
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'ct_pf_video' ) ) {
		$metabox->set_args( 'ct_pf_video', array(
			'opt_name'     => 'post_format_video',
			'display_name' => esc_html__( 'Video', 'bixol' ),
			'class'        => 'fully-expanded',
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'ct_pf_gallery' ) ) {
		$metabox->set_args( 'ct_pf_gallery', array(
			'opt_name'     => 'post_format_gallery',
			'display_name' => esc_html__( 'Gallery', 'bixol' ),
			'class'        => 'fully-expanded',
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	/* Extra Post Type */

	if ( ! $metabox->isset_args( 'service' ) ) {
		$metabox->set_args( 'service', array(
			'opt_name'            => 'service_option',
			'display_name'        => esc_html__( 'Service Settings', 'bixol' ),
			'show_options_object' => false,
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'portfolio' ) ) {
		$metabox->set_args( 'portfolio', array(
			'opt_name'            => 'portfolio_option',
			'display_name'        => esc_html__( 'Portfolio Settings', 'bixol' ),
			'show_options_object' => false,
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'case-study' ) ) {
		$metabox->set_args( 'case-study', array(
			'opt_name'            => 'case_study_option',
			'display_name'        => esc_html__( 'Case Study Settings', 'bixol' ),
			'show_options_object' => false,
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	/**
	 * Config post meta options
	 *
	 */
	$metabox->add_section( 'post', array(
		'title'  => esc_html__( 'Post Settings', 'bixol' ),
		'icon'   => 'el el-refresh',
		'fields' => array(
			array(
				'id'             => 'post_content_padding',
				'type'           => 'spacing',
				'output'         => array( '.single-post #content' ),
				'right'          => false,
				'left'           => false,
				'mode'           => 'padding',
				'units'          => array( 'px' ),
				'units_extended' => 'false',
				'title'          => esc_html__( 'Content Padding', 'bixol' ),
				'subtitle'     => esc_html__( 'Content site paddings.', 'bixol' ),
				'desc'           => esc_html__( 'Default: Theme Option.', 'bixol' ),
				'default'        => array(
					'padding-top'    => '',
					'padding-bottom' => '',
					'units'          => 'px',
				)
			),
			array(
				'id'      => 'show_sidebar_post',
				'type'    => 'switch',
				'title'   => esc_html__( 'Custom Sidebar', 'bixol' ),
				'default' => false,
				'indent'  => true
			),
			array(
				'id'           => 'sidebar_post_pos',
				'type'         => 'button_set',
				'title'        => esc_html__( 'Sidebar Position', 'bixol' ),
				'options'      => array(
					'left'  => esc_html__('Left', 'bixol'),
	                'right' => esc_html__('Right', 'bixol'),
	                'none'  => esc_html__('Disabled', 'bixol')
				),
				'default'      => 'right',
				'required'     => array( 0 => 'show_sidebar_post', 1 => '=', 2 => '1' ),
				'force_output' => true
			),
			array(
				'id'           => 'video_url',
				'type'         => 'text',
				'title'        => esc_html__( 'Video Url', 'bixol' ),
			),
		)
	) );

	/**
	 * Config page meta options
	 *
	 */
	$metabox->add_section( 'page', array(
		'title'  => esc_html__( 'Header', 'bixol' ),
		'desc'   => esc_html__( 'Header settings for the page.', 'bixol' ),
		'icon'   => 'el-icon-website',
		'fields' => array(
			array(
	            'id'       => 'header_type',
	            'type'     => 'button_set',
	            'title'    => esc_html__('Header Type', 'bixol'),
	            'options'  => array(
	                'themeoption'  => esc_html__('Inherit', 'bixol'),
	                'layout'  => esc_html__('Default Layout', 'bixol'),
	                'custom'  => esc_html__('Custom Layout Builder', 'bixol')
	            ),
	            'default'  => 'themeoption',
	        ),
	        /* Header Elementor */
            array(
	            'id'          => 'e_header_layout',
	            'type'        => 'select',
	            'title'       => esc_html__('Main Header Layout', 'bixol'),
	            'desc'        => sprintf(esc_html__('To use this Option please %sClick Here%s to add your header layout first.','bixol'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=header' ) ) . '">','</a>'),
	            'options'     => bixol_list_post('header'),
	            'default'     => '',
	            'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'custom' ),
	        ),
	        array(
	            'id'          => 'e_header_layout_sticky',
	            'type'        => 'select',
	            'title'       => esc_html__('Sticky Header Layout', 'bixol'),
	            'desc'        => sprintf(esc_html__('To use this Option please %sClick Here%s to add your header layout first.','bixol'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=header' ) ) . '">','</a>'),
	            'options'     => bixol_list_post('header'),
	            'default'     => '',
	            'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'custom' ),
	        ),

	        array(
	            'id'       => 'p_logo_m',
	            'type'     => 'media',
	            'title'    => esc_html__('Logo Mobile', 'bixol'),
	            'subtitle' => esc_html__('Screenshot < 1200px', 'bixol'),
	            'default' => '',
	            'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'custom' ),
	        ),

	        /* End Header Elementor */

			array(
				'id'      => 'custom_header',
				'type'    => 'switch',
				'title'   => esc_html__( 'Custom Layout', 'bixol' ),
				'default' => false,
				'indent'  => true,
				'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'layout' ),
			),
			array(
				'id'           => 'header_layout',
				'type'         => 'image_select',
				'title'        => esc_html__( 'Layout', 'bixol' ),
				'subtitle'     => esc_html__( 'Select a layout for header.', 'bixol' ),
				'options'      => array(
					'0' => get_template_directory_uri() . '/assets/images/header-layout/h0.jpg',
					'1' => get_template_directory_uri() . '/assets/images/header-layout/h1.jpg',
					'2' => get_template_directory_uri() . '/assets/images/header-layout/h2.jpg',
					'3' => get_template_directory_uri() . '/assets/images/header-layout/h3.jpg',
					'4' => get_template_directory_uri() . '/assets/images/header-layout/h4.jpg',
					'5' => get_template_directory_uri() . '/assets/images/header-layout/h5.jpg',
					'6' => get_template_directory_uri() . '/assets/images/header-layout/h6.jpg',
					'7' => get_template_directory_uri() . '/assets/images/header-layout/h7.jpg',
					'landing' => get_template_directory_uri() . '/assets/images/header-layout/h-landing.jpg',
				),
				'default'      => bixol_get_option_of_theme_options( 'header_layout' ),
				'required'     => array( 0 => 'custom_header', 1 => 'equals', 2 => '1' ),
				'force_output' => true
			),
			array(
	            'id'       => 'p_logo_dark',
	            'type'     => 'media',
	            'title'    => esc_html__('Custom Logo Dark', 'bixol'),
	            'default' => '',
	            'required'     => array( 0 => 'custom_header', 1 => 'equals', 2 => '1' ),
				'force_output' => true
	        ),
	        array(
                'id'       => 'h_custom_menu',
                'type'     => 'select',
                'title'    => esc_html__( 'Custom Menu', 'bixol' ),
                'subtitle' => esc_html__( 'Custom menu for current page.', 'bixol' ),
                'options'  => bixol_get_nav_menu(),
                'default' => '',
            ),
            array(
                'id'       => 'h_custom_menu_left',
                'type'     => 'select',
                'title'    => esc_html__( 'Custom Menu Left', 'bixol' ),
                'subtitle' => esc_html__( 'Custom menu for current page.', 'bixol' ),
                'options'  => bixol_get_nav_menu(),
                'default' => '',
                'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'layout' ),
            ),
            array(
                'id'       => 'h_custom_menu_right',
                'type'     => 'select',
                'title'    => esc_html__( 'Custom Menu Right', 'bixol' ),
                'subtitle' => esc_html__( 'Custom menu for current page.', 'bixol' ),
                'options'  => bixol_get_nav_menu(),
                'default' => '',
                'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'layout' ),
            ),
		)
	) );

	$metabox->add_section( 'page', array(
		'title'  => esc_html__( 'Page Title', 'bixol' ),
		'icon'   => 'el el-indent-left',
		'fields' => array(
			array(
				'id'           => 'custom_pagetitle',
				'type'         => 'button_set',
				'title'        => esc_html__( 'Page Title', 'bixol' ),
				'options'      => array(
					'themeoption'  => esc_html__( 'Theme Option', 'bixol' ),
					'show'  => esc_html__( 'Custom', 'bixol' ),
					'hide'  => esc_html__( 'Hide', 'bixol' ),
				),
				'default'      => 'themeoption',
			),
			array(
				'id'           => 'custom_title',
				'type'         => 'textarea',
				'title'        => esc_html__( 'Title', 'bixol' ),
				'subtitle'     => esc_html__( 'Use custom title for this page. The default title will be used on document title.', 'bixol' ),
				'required'     => array( 0 => 'custom_pagetitle', 1 => '=', 2 => 'show' ),
				'force_output' => true
			),
			array(
	            'id'       => 'ptitle_bg',
	            'type'     => 'background',
	            'background-color'     => true,
	            'background-repeat'     => false,
	            'background-size'     => false,
	            'background-attachment'     => false,
	            'background-position'     => false,
	            'transparent'     => false,
	            'title'    => esc_html__('Background', 'bixol'),
	            'subtitle' => esc_html__('Page title background image.', 'bixol'),
	            'required'     => array( 0 => 'custom_pagetitle', 1 => '=', 2 => 'show' ),
				'force_output' => true
	        ),
	        array(
				'id'       => 'ptitle_bg_overlay',
				'type'     => 'color_rgba',
				'title'    => esc_html__( 'Background Color Overlay', 'bixol' ),
				'subtitle' => esc_html__( 'Page title background color overlay.', 'bixol' ),
				'output'   => array( 'background-color' => 'body #pagetitle:before' ),
				'required'     => array( 0 => 'custom_pagetitle', 1 => '=', 2 => 'show' ),
				'force_output' => true
			),
	        array(
	            'id'             => 'ptitle_padding',
	            'type'           => 'spacing',
	            'output'         => array('.site #pagetitle.page-title'),
	            'right'   => false,
	            'left'    => false,
	            'mode'           => 'padding',
	            'units'          => array('px'),
	            'units_extended' => 'false',
	            'title'          => esc_html__('Page Title Padding', 'bixol'),
	            'default'            => array(
	                'padding-top'   => '',
	                'padding-bottom'   => '',
	                'units'          => 'px',
	            ),
	            'required'     => array( 0 => 'custom_pagetitle', 1 => '=', 2 => 'show' ),
				'force_output' => true
	        ),
		)
	) );

	$metabox->add_section( 'page', array(
		'title'  => esc_html__( 'Content', 'bixol' ),
		'desc'   => esc_html__( 'Settings for content area.', 'bixol' ),
		'icon'   => 'el-icon-pencil',
		'fields' => array(
	        array(
				'id'           => 'loading_page',
				'type'         => 'button_set',
				'title'        => esc_html__( 'Loading', 'bixol' ),
				'options'      => array(
					'themeoption'  => esc_html__( 'Theme Option', 'bixol' ),
					'custom' => esc_html__( 'Cuttom', 'bixol' ),
				),
				'default'      => 'themeoption',
			),
			array(
	            'id'       => 'loading_type',
	            'type'     => 'select',
	            'title'    => esc_html__('Loading Type', 'bixol'),
	            'options'  => array(
	                'style1'  => esc_html__('Style 1', 'bixol'),
	                'style2'  => esc_html__('Style 2', 'bixol'),
	                'style3'  => esc_html__('Style 3', 'bixol'),
	                'style4'  => esc_html__('Style 4', 'bixol'),
	                'style5'  => esc_html__('Style 5', 'bixol'),
	                'style6'  => esc_html__('Style 6', 'bixol'),
	                'style7'  => esc_html__('Style 7', 'bixol'),
	                'style8'  => esc_html__('Style 8', 'bixol'),
	                'style9'  => esc_html__('Style 9', 'bixol'),
	                'style10'  => esc_html__('Style 10', 'bixol'),
	                'style11'  => esc_html__('Style 11', 'bixol'),
	                'style12'  => esc_html__('Style 12', 'bixol'),
	            ),
	            'default'  => 'style1',
	            'required'     => array( 0 => 'loading_page', 1 => '=', 2 => 'custom' ),
				'force_output' => true
	        ),
			array(
				'id'       => 'content_bg_color',
				'type'     => 'color_rgba',
				'title'    => esc_html__( 'Background Color', 'bixol' ),
				'subtitle' => esc_html__( 'Content background color.', 'bixol' ),
				'output'   => array( 'background-color' => 'body .site-content' )
			),
			array(
				'id'      => 'hide_bg_image',
				'type'    => 'switch',
				'title'   => esc_html__( 'Hide Background Image', 'bixol' ),
				'default' => false,
				'indent'  => true
			),
			array(
				'id'             => 'content_padding',
				'type'           => 'spacing',
				'output'         => array( '#content' ),
				'right'          => false,
				'left'           => false,
				'mode'           => 'padding',
				'units'          => array( 'px' ),
				'units_extended' => 'false',
				'title'          => esc_html__( 'Content Padding', 'bixol' ),
				'desc'           => esc_html__( 'Default: Theme Option.', 'bixol' ),
				'default'        => array(
					'padding-top'    => '',
					'padding-bottom' => '',
					'units'          => 'px',
				)
			),
			array(
				'id'      => 'show_sidebar_page',
				'type'    => 'switch',
				'title'   => esc_html__( 'Show Sidebar', 'bixol' ),
				'default' => false,
				'indent'  => true
			),
			array(
				'id'           => 'sidebar_page_pos',
				'type'         => 'button_set',
				'title'        => esc_html__( 'Sidebar Position', 'bixol' ),
				'options'      => array(
					'left'  => esc_html__( 'Left', 'bixol' ),
					'right' => esc_html__( 'Right', 'bixol' ),
				),
				'default'      => 'right',
				'required'     => array( 0 => 'show_sidebar_page', 1 => '=', 2 => '1' ),
				'force_output' => true
			),
		)
	) );

	$metabox->add_section( 'page', array(
		'title'  => esc_html__( 'Footer', 'bixol' ),
		'desc'   => esc_html__( 'Settings for footer area.', 'bixol' ),
		'icon'   => 'el el-website',
		'fields' => array(
			array(
				'id'      => 'custom_footer',
				'type'    => 'switch',
				'title'   => esc_html__( 'Custom Layout', 'bixol' ),
				'default' => false,
				'indent'  => true
			),
	        array(
	            'id'          => 'footer_layout_custom',
	            'type'        => 'select',
	            'title'       => esc_html__('Layout', 'bixol'),
	            'desc'        => sprintf(esc_html__('To use this Option please %sClick Here%s to add your custom footer layout first.','bixol'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=footer' ) ) . '">','</a>'),
	            'options'     =>bixol_list_post('footer'),
	            'default'     => '',
	            'required' => array( 0 => 'custom_footer', 1 => 'equals', 2 => '1' ),
	            'force_output' => true
	        ),
	    )
	) );	

	$metabox->add_section( 'page', array(
		'title'  => esc_html__( 'Colors', 'bixol' ),
		'icon'   => 'el-icon-file-edit',
		'fields' => array(
			array(
	            'id'          => 'p_primary_color',
	            'type'        => 'color',
	            'title'       => esc_html__('Primary Color', 'bixol'),
	            'transparent' => false,
	            'default'     => ''
	        ),
	        array(
	            'id'          => 'p_secondary_color',
	            'type'        => 'color',
	            'title'       => esc_html__('Secondary Color', 'bixol'),
	            'transparent' => false,
	            'default'     => ''
	        ),
		)
	) );

	/**
	 * Config post format meta options
	 *
	 */

	$metabox->add_section( 'ct_pf_video', array(
		'title'  => esc_html__( 'Video', 'bixol' ),
		'fields' => array(
			array(
				'id'    => 'post-video-url',
				'type'  => 'text',
				'title' => esc_html__( 'Video URL', 'bixol' ),
				'desc'  => esc_html__( 'YouTube or Vimeo video URL', 'bixol' )
			),

			array(
				'id'    => 'post-video-file',
				'type'  => 'editor',
				'title' => esc_html__( 'Video Upload', 'bixol' ),
				'desc'  => esc_html__( 'Upload video file', 'bixol' )
			),

			array(
				'id'    => 'post-video-html',
				'type'  => 'textarea',
				'title' => esc_html__( 'Embadded video', 'bixol' ),
				'desc'  => esc_html__( 'Use this option when the video does not come from YouTube or Vimeo', 'bixol' )
			)
		)
	) );

	$metabox->add_section( 'ct_pf_gallery', array(
		'title'  => esc_html__( 'Gallery', 'bixol' ),
		'fields' => array(
			array(
				'id'       => 'post-gallery-lightbox',
				'type'     => 'switch',
				'title'    => esc_html__( 'Lightbox?', 'bixol' ),
				'subtitle' => esc_html__( 'Enable lightbox for gallery images.', 'bixol' ),
				'default'  => true
			),
			array(
				'id'       => 'post-gallery-images',
				'type'     => 'gallery',
				'title'    => esc_html__( 'Gallery Images ', 'bixol' ),
				'subtitle' => esc_html__( 'Upload images or add from media library.', 'bixol' )
			)
		)
	) );

	$metabox->add_section( 'ct_pf_audio', array(
		'title'  => esc_html__( 'Audio', 'bixol' ),
		'fields' => array(
			array(
				'id'          => 'post-audio-url',
				'type'        => 'text',
				'title'       => esc_html__( 'Audio URL', 'bixol' ),
				'description' => esc_html__( 'Audio file URL in format: mp3, ogg, wav.', 'bixol' ),
				'validate'    => 'url',
				'msg'         => 'Url error!'
			)
		)
	) );

	$metabox->add_section( 'ct_pf_link', array(
		'title'  => esc_html__( 'Link', 'bixol' ),
		'fields' => array(
			array(
				'id'       => 'post-link-url',
				'type'     => 'text',
				'title'    => esc_html__( 'URL', 'bixol' ),
				'validate' => 'url',
				'msg'      => 'Url error!'
			)
		)
	) );

	$metabox->add_section( 'ct_pf_quote', array(
		'title'  => esc_html__( 'Quote', 'bixol' ),
		'fields' => array(
			array(
				'id'    => 'post-quote-cite',
				'type'  => 'text',
				'title' => esc_html__( 'Cite', 'bixol' )
			)
		)
	) );

	/**
	 * Config service meta options
	 *
	 */
	$metabox->add_section( 'service', array(
		'title'  => esc_html__( 'General', 'bixol' ),
		'icon'   => 'el-icon-website',
		'fields' => array(
			array(
				'id'       => 'service_custom_link',
				'type'     => 'text',
				'title'    => esc_html__( 'Custom Link', 'bixol' ),
				'validate' => 'url',
				'msg'      => 'Url error!'
			),
			array(
	            'id'       => 'icon_type',
	            'type'     => 'button_set',
	            'title'    => esc_html__('Icon Type', 'bixol'),
	            'options'  => array(
	                'icon'  => esc_html__('Icon', 'bixol'),
	                'image'  => esc_html__('Image', 'bixol'),
	            ),
	            'default'  => 'icon'
	        ),
			array(
	            'id'       => 'service_icon',
	            'type'     => 'ct_iconpicker',
	            'title'    => esc_html__('Icon', 'bixol'),
	            'required' => array( 0 => 'icon_type', 1 => 'equals', 2 => 'icon' ),
            	'force_output' => true
	        ),
	        array(
	            'id'       => 'service_icon_img',
	            'type'     => 'media',
	            'title'    => esc_html__('Icon Image', 'bixol'),
	            'default' => '',
	            'required' => array( 0 => 'icon_type', 1 => 'equals', 2 => 'image' ),
            	'force_output' => true
	        ),
			array(
				'id'       => 'service_except',
				'type'     => 'textarea',
				'title'    => esc_html__( 'Excerpt', 'bixol' ),
				'validate' => 'no_html'
			),
			array(
				'id'             => 'service_content_padding',
				'type'           => 'spacing',
				'output'         => array( '.single-service #content' ),
				'right'          => false,
				'left'           => false,
				'mode'           => 'padding',
				'units'          => array( 'px' ),
				'units_extended' => 'false',
				'title'          => esc_html__( 'Content Padding', 'bixol' ),
				'subtitle'     => esc_html__( 'Content site paddings.', 'bixol' ),
				'desc'           => esc_html__( 'Default: Theme Option.', 'bixol' ),
				'default'        => array(
					'padding-top'    => '',
					'padding-bottom' => '',
					'units'          => 'px',
				)
			),
			array(
				'id'      => 'custom_footer',
				'type'    => 'switch',
				'title'   => esc_html__( 'Custom Layout Footer', 'bixol' ),
				'default' => false,
				'indent'  => true
			),
	        array(
	            'id'          => 'footer_layout_custom',
	            'type'        => 'select',
	            'title'       => esc_html__('Layout Footer', 'bixol'),
	            'desc'        => sprintf(esc_html__('To use this Option please %sClick Here%s to add your custom footer layout first.','bixol'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=footer' ) ) . '">','</a>'),
	            'options'     =>bixol_list_post('footer'),
	            'default'     => '',
	            'required' => array( 0 => 'custom_footer', 1 => 'equals', 2 => '1' ),
	            'force_output' => true
	        ),
		)
	) );

	$metabox->add_section( 'service', array(
		'title'  => esc_html__( 'Page Title', 'bixol' ),
		'icon'   => 'el el-indent-left',
		'fields' => array(
			array(
				'id'           => 'custom_pagetitle',
				'type'         => 'button_set',
				'title'        => esc_html__( 'Page Title', 'bixol' ),
				'options'      => array(
					'themeoption'  => esc_html__( 'Theme Option', 'bixol' ),
					'show'  => esc_html__( 'Custom', 'bixol' ),
					'hide'  => esc_html__( 'Hide', 'bixol' ),
				),
				'default'      => 'themeoption',
			),
			array(
				'id'           => 'custom_title',
				'type'         => 'textarea',
				'title'        => esc_html__( 'Title', 'bixol' ),
				'subtitle'     => esc_html__( 'Use custom title for this page. The default title will be used on document title.', 'bixol' ),
				'required'     => array( 0 => 'custom_pagetitle', 1 => '=', 2 => 'show' ),
				'force_output' => true
			),
			array(
	            'id'       => 'ptitle_bg',
	            'type'     => 'background',
	            'background-color'     => true,
	            'background-repeat'     => false,
	            'background-size'     => false,
	            'background-attachment'     => false,
	            'background-position'     => false,
	            'transparent'     => false,
	            'title'    => esc_html__('Background', 'bixol'),
	            'subtitle' => esc_html__('Page title background image.', 'bixol'),
	            'required'     => array( 0 => 'custom_pagetitle', 1 => '=', 2 => 'show' ),
				'force_output' => true
	        ),
	        array(
				'id'       => 'ptitle_bg_overlay',
				'type'     => 'color_rgba',
				'title'    => esc_html__( 'Background Color Overlay', 'bixol' ),
				'subtitle' => esc_html__( 'Page title background color overlay.', 'bixol' ),
				'output'   => array( 'background-color' => 'body #pagetitle:before' ),
				'required'     => array( 0 => 'custom_pagetitle', 1 => '=', 2 => 'show' ),
				'force_output' => true
			),
	        array(
	            'id'             => 'ptitle_padding',
	            'type'           => 'spacing',
	            'output'         => array('.site #pagetitle.page-title'),
	            'right'   => false,
	            'left'    => false,
	            'mode'           => 'padding',
	            'units'          => array('px'),
	            'units_extended' => 'false',
	            'title'          => esc_html__('Page Title Padding', 'bixol'),
	            'default'            => array(
	                'padding-top'   => '',
	                'padding-bottom'   => '',
	                'units'          => 'px',
	            ),
	            'required'     => array( 0 => 'custom_pagetitle', 1 => '=', 2 => 'show' ),
				'force_output' => true
	        ),
		)
	) );

	/**
	 * Config portfolio meta options
	 *
	 */
	$metabox->add_section( 'portfolio', array(
		'title'  => esc_html__( 'General', 'bixol' ),
		'icon'   => 'el-icon-website',
		'fields' => array(
			array(
				'id'       => 'portfolio_sub_title',
				'type'     => 'text',
				'title'    => esc_html__( 'Sub Title', 'bixol' ),
				'validate' => 'no_html'
			),
			array(
	            'id'       => 'icon_type',
	            'type'     => 'button_set',
	            'title'    => esc_html__('Icon Type', 'bixol'),
	            'options'  => array(
	                'icon'  => esc_html__('Icon', 'bixol'),
	                'image'  => esc_html__('Image', 'bixol'),
	            ),
	            'default'  => 'icon'
	        ),
			array(
	            'id'       => 'portfolio_icon',
	            'type'     => 'ct_iconpicker',
	            'title'    => esc_html__('Icon', 'bixol'),
	            'required' => array( 0 => 'icon_type', 1 => 'equals', 2 => 'icon' ),
            	'force_output' => true
	        ),
	        array(
	            'id'       => 'portfolio_icon_img',
	            'type'     => 'media',
	            'title'    => esc_html__('Icon Image', 'bixol'),
	            'default' => '',
	            'required' => array( 0 => 'icon_type', 1 => 'equals', 2 => 'image' ),
            	'force_output' => true
	        ),
			array(
				'id'       => 'portfolio_except',
				'type'     => 'textarea',
				'title'    => esc_html__( 'Excerpt', 'bixol' ),
				'validate' => 'no_html'
			),
			array(
				'id'             => 'portfolio_content_padding',
				'type'           => 'spacing',
				'output'         => array( '.single-portfolio #content' ),
				'right'          => false,
				'left'           => false,
				'mode'           => 'padding',
				'units'          => array( 'px' ),
				'units_extended' => 'false',
				'title'          => esc_html__( 'Content Padding', 'bixol' ),
				'subtitle'     => esc_html__( 'Content site paddings.', 'bixol' ),
				'desc'           => esc_html__( 'Default: Theme Option.', 'bixol' ),
				'default'        => array(
					'padding-top'    => '',
					'padding-bottom' => '',
					'units'          => 'px',
				)
			),
		)
	) );

	$metabox->add_section( 'portfolio', array(
		'title'  => esc_html__( 'Page Title', 'bixol' ),
		'icon'   => 'el el-indent-left',
		'fields' => array(
			array(
				'id'           => 'custom_pagetitle',
				'type'         => 'button_set',
				'title'        => esc_html__( 'Page Title', 'bixol' ),
				'options'      => array(
					'themeoption'  => esc_html__( 'Theme Option', 'bixol' ),
					'show'  => esc_html__( 'Custom', 'bixol' ),
					'hide'  => esc_html__( 'Hide', 'bixol' ),
				),
				'default'      => 'themeoption',
			),
			array(
				'id'           => 'custom_title',
				'type'         => 'textarea',
				'title'        => esc_html__( 'Title', 'bixol' ),
				'subtitle'     => esc_html__( 'Use custom title for this page. The default title will be used on document title.', 'bixol' ),
				'required'     => array( 0 => 'custom_pagetitle', 1 => '=', 2 => 'show' ),
				'force_output' => true
			),
			array(
	            'id'       => 'ptitle_bg',
	            'type'     => 'background',
	            'background-color'     => true,
	            'background-repeat'     => false,
	            'background-size'     => false,
	            'background-attachment'     => false,
	            'background-position'     => false,
	            'transparent'     => false,
	            'title'    => esc_html__('Background', 'bixol'),
	            'subtitle' => esc_html__('Page title background image.', 'bixol'),
	            'required'     => array( 0 => 'custom_pagetitle', 1 => '=', 2 => 'show' ),
				'force_output' => true
	        ),
	        array(
				'id'       => 'ptitle_bg_overlay',
				'type'     => 'color_rgba',
				'title'    => esc_html__( 'Background Color Overlay', 'bixol' ),
				'subtitle' => esc_html__( 'Page title background color overlay.', 'bixol' ),
				'output'   => array( 'background-color' => 'body #pagetitle:before' ),
				'required'     => array( 0 => 'custom_pagetitle', 1 => '=', 2 => 'show' ),
				'force_output' => true
			),
	        array(
	            'id'             => 'ptitle_padding',
	            'type'           => 'spacing',
	            'output'         => array('.site #pagetitle.page-title'),
	            'right'   => false,
	            'left'    => false,
	            'mode'           => 'padding',
	            'units'          => array('px'),
	            'units_extended' => 'false',
	            'title'          => esc_html__('Page Title Padding', 'bixol'),
	            'default'            => array(
	                'padding-top'   => '',
	                'padding-bottom'   => '',
	                'units'          => 'px',
	            ),
	            'required'     => array( 0 => 'custom_pagetitle', 1 => '=', 2 => 'show' ),
				'force_output' => true
	        ),
		)
	) );

	/**
	 * Config case study meta options
	 *
	 */
	$metabox->add_section( 'case-study', array(
		'title'  => esc_html__( 'General', 'bixol' ),
		'icon'   => 'el-icon-website',
		'fields' => array(
			array(
				'id'             => 'case_study_content_padding',
				'type'           => 'spacing',
				'output'         => array( '.single-case-study #content' ),
				'right'          => false,
				'left'           => false,
				'mode'           => 'padding',
				'units'          => array( 'px' ),
				'units_extended' => 'false',
				'title'          => esc_html__( 'Content Padding', 'bixol' ),
				'subtitle'     => esc_html__( 'Content site paddings.', 'bixol' ),
				'desc'           => esc_html__( 'Default: Theme Option.', 'bixol' ),
				'default'        => array(
					'padding-top'    => '',
					'padding-bottom' => '',
					'units'          => 'px',
				)
			),
		)
	) );

	/**
     * Config product meta options
     *
     */
    $metabox->add_section('product', array(
        'title'  => esc_html__('Product Settings', 'bixol'),
        'icon'   => 'el el-briefcase',
        'fields' => array(
            array(
                'id'       => 'product_feature',
                'type'     => 'multi_text',
                'title'    => esc_html__('Feature', 'bixol'),
                'validate' => 'html',
            ),
        )
    ));

}

function bixol_get_option_of_theme_options( $key, $default = '' ) {
	if ( empty( $key ) ) {
		return '';
	}
	$options = get_option( bixol_get_opt_name(), array() );
	$value   = isset( $options[ $key ] ) ? $options[ $key ] : $default;

	return $value;
}