<?php
/**
 * Template part for displaying posts in loop
 *
 * @package Bixol
 */
$archive_date_on = bixol_get_opt( 'archive_date_on', true );
$archive_categories_on = bixol_get_opt( 'archive_categories_on', false );
$archive_social_share_on = bixol_get_opt( 'archive_social_share_on', false );
$archive_readmore_text = bixol_get_opt( 'archive_readmore_text' );
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('single-hentry archive'); ?>>
    
    <?php if (has_post_thumbnail()) {
        $featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'full'); 
        echo '<div class="entry-featured image-effect-white">'; ?>
            <a href="<?php echo esc_url( get_permalink()); ?>" style="background-image: url(<?php echo esc_url($featured_img_url); ?>);"><?php the_post_thumbnail('full'); ?></a>
            <?php if($archive_date_on) : ?>
                <div class="entry-date">
                    <?php echo get_the_date('d'); ?><br/>
                    <?php echo get_the_date('M'); ?>
                </div>
            <?php endif; ?>
        <?php echo '</div>';
    } ?>
    <div class="entry-body">
        <?php if($archive_categories_on) : ?>
            <div class="entry-category"><?php the_terms( get_the_ID(), 'category', '', ', ' ); ?></div>
        <?php endif; ?>
        <h2 class="entry-title">
            <a href="<?php echo esc_url( get_permalink()); ?>">
                <?php if(is_sticky()) { ?>
                    <i class="fa fa-thumb-tack"></i>
                <?php } ?>
                <?php the_title(); ?>
            </a>
        </h2>
        <div class="entry-excerpt">
            <?php
                bixol_entry_excerpt();
                wp_link_pages( array(
                    'before'      => '<div class="page-links">',
                    'after'       => '</div>',
                    'link_before' => '<span>',
                    'link_after'  => '</span>',
                ) );
            ?>
        </div>
        <div class="entry-holder">
            <div class="entry-readmore">
                <a class="btn btn-plus icon-right" href="<?php echo esc_url( get_permalink()); ?>" class="btn-text">
                    <?php if(!empty($archive_readmore_text)) { echo esc_attr($archive_readmore_text); } else { echo esc_html__('Read more', 'bixol'); } ?>
                    <span class="icon-abs"><i class="ct-icon-plus"></i></span>
                </a>
            </div>
            <?php if($archive_social_share_on) : ?>
                <div class="entry-social-share">
                    <span class="social-icon fac fac-share-alt"></span>
                    <?php bixol_socials_share_default(); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</article><!-- #post -->