<?php
/**
 * Template part for displaying site branding
 */

$logo_dark = bixol_get_opt( 'logo', array( 'url' => get_template_directory_uri().'/assets/images/logo-dark.png', 'id' => '' ) );
$logo_mobile = bixol_get_opt( 'logo_mobile', array( 'url' => get_template_directory_uri().'/assets/images/logo-dark.png', 'id' => '' ) );

$custom_header = bixol_get_page_opt('custom_header');
$p_logo_dark = bixol_get_page_opt('p_logo_dark');

if($custom_header && !empty($p_logo_dark['url'])) {
    $logo_dark['url'] = $p_logo_dark['url'];
}

if ($logo_dark['url']) {
    printf(
        '<a class="logo-dark" href="%1$s" title="%2$s" rel="home"><img src="%3$s" alt="%2$s"/></a>',
        esc_url( home_url( '/' ) ),
        esc_attr( get_bloginfo( 'name' ) ),
        esc_url( $logo_dark['url'] )
    );
}

$p_logo_m = bixol_get_page_opt( 'p_logo_m' );
$p_header_type = bixol_get_page_opt('header_type');
if($p_header_type == 'custom' && !empty($p_logo_m['url']) ) {
    $logo_mobile = $p_logo_m;
}


if ($logo_mobile['url']) {
    printf(
        '<a class="logo-mobile" href="%1$s" title="%2$s" rel="home"><img src="%3$s" alt="%2$s"/></a>',
        esc_url( home_url( '/' ) ),
        esc_attr( get_bloginfo( 'name' ) ),
        esc_url( $logo_mobile['url'] )
    );
}