<?php
/**
 * Template part for displaying default header layout
 */
$sticky_on = bixol_get_opt( 'sticky_on', false );
$h_btn_on = bixol_get_opt( 'h_btn_on', 'hide' );
$h_btn_text = bixol_get_opt( 'h_btn_text' );
$h_btn_link_type = bixol_get_opt( 'h_btn_link_type', 'page' );
$h_btn_link = bixol_get_opt( 'h_btn_link' );
$h_btn_link_custom = bixol_get_opt( 'h_btn_link_custom' );
$h_btn_target = bixol_get_opt( 'h_btn_target', '_self' );
if($h_btn_link_type == 'page') {
    $h_btn_url = get_permalink($h_btn_link);
} else {
    $h_btn_url = $h_btn_link_custom;
}
$logo_mobile = bixol_get_opt( 'logo_mobile', array( 'url' => get_template_directory_uri().'/assets/images/logo-dark.png', 'id' => '' ) );
?>
<header id="ct-masthead">
    <div id="ct-header-wrap" class="ct-header-layout6 fixed-height <?php if($sticky_on == 1) { echo 'is-sticky'; } ?>">

        <div id="ct-header" class="ct-header-main">
            <div class="container">
                <div class="row">
                    <div class="ct-header-branding">
                        <div class="ct-header-branding-inner">
                            <?php get_template_part( 'template-parts/header-branding' ); ?>
                        </div>
                    </div>
                    <div class="ct-header-navigation">
                        <nav class="ct-main-navigation">
                            <div class="ct-main-navigation-inner">
                                <?php if ($logo_mobile['url']) { ?>
                                    <div class="ct-logo-mobile">
                                        <a href="<?php esc_url( esc_url( home_url( '/' ) ) ); ?>" title="<?php esc_attr( get_bloginfo( 'name' ) ); ?>" rel="home"><img src="<?php echo esc_url( $logo_mobile['url'] ); ?>" alt="<?php esc_attr( get_bloginfo( 'name' ) ); ?>"/></a>
                                    </div>
                                <?php } ?>
                                <?php bixol_header_mobile_search(); ?>
                                <?php get_template_part( 'template-parts/header-menu' ); ?>
                            </div>
                        </nav>
                        <?php if($h_btn_on == 'show' && !empty($h_btn_text)) : ?>
                            <div class="ct-header-button">
                                <a class="btn btn-animate" href="<?php echo esc_url( $h_btn_url ); ?>" target="<?php echo esc_attr($h_btn_target); ?>"><?php echo esc_attr( $h_btn_text ); ?></a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div id="ct-menu-mobile">
                <span class="btn-nav-mobile open-menu">
                    <span></span>
                </span>
            </div>
        </div>

    </div>
</header>