<?php
/**
 * Template part for displaying default header layout
 */
$sticky_on = bixol_get_opt( 'sticky_on', false );
$h_search_form = bixol_get_opt( 'h_search_form', false );
$top_bar = bixol_get_opt( 'top_bar', 'hide' );

$h_phone_label = bixol_get_opt( 'h_phone_label' );
$h_phone = bixol_get_opt( 'h_phone' );
$h_phone_link = bixol_get_opt( 'h_phone_link' );

$h_email_label = bixol_get_opt( 'h_email_label' );
$h_email = bixol_get_opt( 'h_email' );
$h_email_link = bixol_get_opt( 'h_email_link' );

$logo_mobile = bixol_get_opt( 'logo_mobile', array( 'url' => get_template_directory_uri().'/assets/images/logo-dark.png', 'id' => '' ) );
?>
<header id="ct-masthead">
    <div id="ct-header-wrap" class="ct-header-layout1 fixed-height <?php if($sticky_on == 1) { echo 'is-sticky'; } ?>">

        <?php if($top_bar == 'show') : ?>
            <div id="ct-topbar" class="ct-topbar-layout1">
                <div class="container">
                    <div class="row">
                        <div class="ct-topbar-meta">
                            <?php if(!empty($h_phone_label) || !empty($h_phone)) : ?>
                                <div class="ct-topbar-item">
                                    <i class="flaticon-telephone"></i>
                                    <label><?php echo esc_attr($h_phone_label).':'; ?></label>
                                    <a href="tel:<?php echo esc_attr($h_phone_link); ?>"><?php echo esc_attr($h_phone); ?></a>
                                </div>
                            <?php endif; ?>
                            <?php if(!empty($h_email_label) || !empty($h_email)) : ?>
                                <div class="ct-topbar-item">
                                    <i class="flaticon-chat-box"></i>
                                    <label><?php echo esc_attr($h_email_label).':'; ?></label>
                                    <a href="mailto:<?php echo esc_attr($h_email_link); ?>"><?php echo esc_attr($h_email); ?></a>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="ct-topbar-social">
                            <?php bixol_social_header(); ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <div id="ct-header" class="ct-header-main">
            <div class="container">
                <div class="row">
                    <div class="ct-header-branding">
                        <div class="ct-header-branding-inner">
                            <?php get_template_part( 'template-parts/header-branding' ); ?>
                        </div>
                    </div>
                    <div class="ct-header-navigation">
                        <nav class="ct-main-navigation">
                            <div class="ct-main-navigation-inner">
                                <?php if ($logo_mobile['url']) { ?>
                                    <div class="ct-logo-mobile">
                                        <a href="<?php esc_url( esc_url( home_url( '/' ) ) ); ?>" title="<?php esc_attr( get_bloginfo( 'name' ) ); ?>" rel="home"><img src="<?php echo esc_url( $logo_mobile['url'] ); ?>" alt="<?php esc_attr( get_bloginfo( 'name' ) ); ?>"/></a>
                                    </div>
                                <?php } ?>
                                <?php bixol_header_mobile_search(); ?>
                                <?php get_template_part( 'template-parts/header-menu' ); ?>
                            </div>
                        </nav>
                        <?php if($h_search_form) : ?>
                            <div class="ct-header-search">
                                <form role="search" method="get" action="<?php echo esc_url(home_url( '/' )); ?>">
                                    <input type="text" placeholder="<?php esc_attr_e('Search', 'bixol'); ?>" name="s" class="search-field" />
                                    <button type="submit" class="search-submit"><i class="fac fac-search"></i></button>
                                </form>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div id="ct-menu-mobile">
                <span class="btn-nav-mobile open-menu">
                    <span></span>
                </span>
            </div>
        </div>

    </div>
</header>