<?php

class CT_Author_Info extends WP_Widget
{

    function __construct()
    {
        parent::__construct(
            'ct_wg_authorinfo',
            esc_html__('* Author Info', 'bixol'),
            array('description' => esc_html__('Author Info Widget', 'bixol'),)
        );
    }

    function widget($args, $instance)
    {

        extract($args);

        $author_name = isset($instance['author_name']) ? (!empty($instance['author_name']) ? $instance['author_name'] : '') : '';
        $author_position = isset($instance['author_position']) ? (!empty($instance['author_position']) ? $instance['author_position'] : '') : '';
        $background_img_id = isset($instance['background_img']) ? (!empty($instance['background_img']) ? $instance['background_img'] : '') : '';
        $background_img_url = wp_get_attachment_image_url($background_img_id, '');
        $author_avatar_id = isset($instance['author_avatar']) ? (!empty($instance['author_avatar']) ? $instance['author_avatar'] : '') : '';
        $author_avatar_url = wp_get_attachment_image_url($author_avatar_id);

        $social_facebook = isset($instance['social_facebook']) ? (!empty($instance['social_facebook']) ? $instance['social_facebook'] : '') : '';
        $social_twitter = isset($instance['social_twitter']) ? (!empty($instance['social_twitter']) ? $instance['social_twitter'] : '') : '';
        $social_linkedin = isset($instance['social_linkedin']) ? (!empty($instance['social_linkedin']) ? $instance['social_linkedin'] : '') : '';
        $social_instagram = isset($instance['social_instagram']) ? (!empty($instance['social_instagram']) ? $instance['social_instagram'] : '') : '';
        $social_pinterest = isset($instance['social_pinterest']) ? (!empty($instance['social_pinterest']) ? $instance['social_pinterest'] : '') : '';
        $social_vimeo = isset($instance['social_vimeo']) ? (!empty($instance['social_vimeo']) ? $instance['social_vimeo'] : '') : '';
        $social_youtube = isset($instance['social_youtube']) ? (!empty($instance['social_youtube']) ? $instance['social_youtube'] : '') : '';
        $social_tumblr = isset($instance['social_tumblr']) ? (!empty($instance['social_tumblr']) ? $instance['social_tumblr'] : '') : '';
        $social_dribbble = isset($instance['social_dribbble']) ? (!empty($instance['social_dribbble']) ? $instance['social_dribbble'] : '') : '';
        $social_behance = isset($instance['social_behance']) ? (!empty($instance['social_behance']) ? $instance['social_behance'] : '') : '';
        ?>
        <div class="ct-wg-author widget">
            <div class="wg-author-dot1"></div>
            <div class="wg-author-dot2">
                <span></span>
                <span></span>
                <span></span>
            </div>
            <div class="ct-wg-author-inner bg-image" style="background-image: url('<?php echo esc_url($background_img_url)?>');">
                <?php if (!empty($author_avatar_url)): ?>
                    <div class="wg-author-avatar">
                        <img src="<?php echo esc_url($author_avatar_url);?>" alt="<?php echo esc_attr( get_post_meta( $author_avatar_id, '_wp_attachment_image_alt', true ) ) ?>">
                    </div>
                <?php endif; ?>

                <?php if (!empty($author_name)) : ?>
                    <h3 class="wg-author-name"><?php echo esc_html($author_name); ?></h3>
                <?php endif; ?>

                <?php if (!empty($author_position)): ?>
                    <div class="wg-author-position">
                        <?php echo wp_kses_post($author_position); ?>
                    </div>
                <?php endif; ?>
                
                <div class="wg-author-social">
                    <?php if(!empty($social_facebook)) : ?>
                        <a href="<?php echo esc_url($social_facebook); ?>" target="_blank"><i class="fab fac-facebook-f"></i></a>
                    <?php endif; ?>
                    <?php if(!empty($social_twitter)) : ?>
                        <a href="<?php echo esc_url($social_twitter); ?>" target="_blank"><i class="fab fac-twitter"></i></a>
                    <?php endif; ?>
                    <?php if(!empty($social_linkedin)) : ?>
                        <a href="<?php echo esc_url($social_linkedin); ?>" target="_blank"><i class="fab fac-linkedin-in"></i></a>
                    <?php endif; ?>
                    <?php if(!empty($social_instagram)) : ?>
                        <a href="<?php echo esc_url($social_instagram); ?>" target="_blank"><i class="fab fac-instagram"></i></a>
                    <?php endif; ?>
                    <?php if(!empty($social_pinterest)) : ?>
                        <a href="<?php echo esc_url($social_pinterest); ?>" target="_blank"><i class="fab fac-pinterest"></i></a>
                    <?php endif; ?>
                    <?php if(!empty($social_vimeo)) : ?>
                        <a href="<?php echo esc_url($social_vimeo); ?>" target="_blank"><i class="fab fac-vimeo"></i></a>
                    <?php endif; ?>
                    <?php if(!empty($social_youtube)) : ?>
                        <a href="<?php echo esc_url($social_youtube); ?>" target="_blank"><i class="fab fac-youtube"></i></a>
                    <?php endif; ?>
                    <?php if(!empty($social_tumblr)) : ?>
                        <a href="<?php echo esc_url($social_tumblr); ?>" target="_blank"><i class="fab fac-tumblr"></i></a>
                    <?php endif; ?>
                    <?php if(!empty($social_dribbble)) : ?>
                        <a href="<?php echo esc_url($social_dribbble); ?>" target="_blank"><i class="fab fac-dribbble"></i></a>
                    <?php endif; ?>
                    <?php if(!empty($social_behance)) : ?>
                        <a href="<?php echo esc_url($social_behance); ?>" target="_blank"><i class="fab fac-behance"></i></a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php
    }

    function update($new_instance, $old_instance)
    {
        $instance = $old_instance;
        $instance['author_name'] = strip_tags($new_instance['author_name']);
        $instance['author_position'] = strip_tags($new_instance['author_position']);
        $instance['btn_text'] = strip_tags($new_instance['btn_text']);
        $instance['btn_link'] = strip_tags($new_instance['btn_link']);
        $instance['background_img'] = strip_tags($new_instance['background_img']);
        $instance['author_avatar'] = strip_tags($new_instance['author_avatar']);
        $instance['social_facebook'] = strip_tags($new_instance['social_facebook']);
        $instance['social_twitter'] = strip_tags($new_instance['social_twitter']);
        $instance['social_linkedin'] = strip_tags($new_instance['social_linkedin']);
        $instance['social_instagram'] = strip_tags($new_instance['social_instagram']);
        $instance['social_pinterest'] = strip_tags($new_instance['social_pinterest']);
        $instance['social_vimeo'] = strip_tags($new_instance['social_vimeo']);
        $instance['social_youtube'] = strip_tags($new_instance['social_youtube']);
        $instance['social_tumblr'] = strip_tags($new_instance['social_tumblr']);
        $instance['social_dribbble'] = strip_tags($new_instance['social_dribbble']);
        $instance['social_behance'] = strip_tags($new_instance['social_behance']);
        return $instance;
    }

    function form($instance)
    {
        $author_name = isset($instance['author_name']) ? esc_attr($instance['author_name']) : '';
        $author_position = isset($instance['author_position']) ? esc_attr($instance['author_position']) : '';
        $btn_text = isset($instance['btn_text']) ? esc_attr($instance['btn_text']) : '';
        $btn_link = isset($instance['btn_link']) ? esc_attr($instance['btn_link']) : '';
        $background_img = isset($instance['background_img']) ? esc_attr($instance['background_img']) : '';
        $author_avatar = isset($instance['author_avatar']) ? esc_attr($instance['author_avatar']) : '';
        $social_facebook = isset($instance['social_facebook']) ? esc_attr($instance['social_facebook']) : '';
        $social_twitter = isset($instance['social_twitter']) ? esc_attr($instance['social_twitter']) : '';
        $social_linkedin = isset($instance['social_linkedin']) ? esc_attr($instance['social_linkedin']) : '';
        $social_instagram = isset($instance['social_instagram']) ? esc_attr($instance['social_instagram']) : '';
        $social_pinterest = isset($instance['social_pinterest']) ? esc_attr($instance['social_pinterest']) : '';
        $social_vimeo = isset($instance['social_vimeo']) ? esc_attr($instance['social_vimeo']) : '';
        $social_youtube = isset($instance['social_youtube']) ? esc_attr($instance['social_youtube']) : '';
        $social_tumblr = isset($instance['social_tumblr']) ? esc_attr($instance['social_tumblr']) : '';
        $social_dribbble = isset($instance['social_dribbble']) ? esc_attr($instance['social_dribbble']) : '';
        $social_behance = isset($instance['social_behance']) ? esc_attr($instance['social_behance']) : '';
        ?>

        <div class="ct-wg-image-wrap" style="margin-top: 15px;">
            <label style="margin-top: 4px;" for="<?php echo esc_url($this->get_field_id('background_img')); ?>"><?php esc_html_e('Box Background Image', 'bixol'); ?></label>
            <input type="hidden" class="widefat hide-image-url"
                   id="<?php echo esc_attr($this->get_field_id('background_img')); ?>"
                   name="<?php echo esc_attr($this->get_field_name('background_img')); ?>"
                   value="<?php echo esc_attr($background_img) ?>"/>
            <div class="ct-wg-show-image">
                <?php
                if ($background_img != "") {
                    ?>
                    <img style="max-width: 110px;" src="<?php echo wp_get_attachment_image_url($background_img) ?>">
                    <?php
                }
                ?>
            </div>
            <?php
            if ($background_img != "") {
                ?>
                <a href="#" class="ct-wg-select-image button" style="display: none;"><?php esc_html_e('Select Image', 'bixol'); ?></a>
                <a href="#" class="ct-wg-remove-image button"><?php esc_html_e('Remove Image', 'bixol'); ?></a>
                <?php
            } else {
                ?>
                <a href="#" class="ct-wg-select-image button"><?php esc_html_e('Select Image', 'bixol'); ?></a>
                <a href="#" class="ct-wg-remove-image button" style="display: none;"><?php esc_html_e('Remove Image', 'bixol'); ?></a>
                <?php
            }
            ?>
        </div>

        <div class="ct-wg-image-wrap" style="margin-top: 15px;">
            <label style="margin-top: 4px;" for="<?php echo esc_url($this->get_field_id('author_avatar')); ?>"><?php esc_html_e('Author Avatar', 'bixol'); ?></label>
            <input type="hidden" class="widefat hide-image-url"
                   id="<?php echo esc_attr($this->get_field_id('author_avatar')); ?>"
                   name="<?php echo esc_attr($this->get_field_name('author_avatar')); ?>"
                   value="<?php echo esc_attr($author_avatar) ?>"/>
            <div class="ct-wg-show-image">
                <?php
                if ($author_avatar != "") {
                    ?>
                    <img style="max-width: 110px;" src="<?php echo wp_get_attachment_image_url($author_avatar) ?>">
                    <?php
                }
                ?>
            </div>
            <?php
            if ($author_avatar != "") {
                ?>
                <a href="#" class="ct-wg-select-image button" style="display: none;"><?php esc_html_e('Select Image', 'bixol'); ?></a>
                <a href="#" class="ct-wg-remove-image button"><?php esc_html_e('Remove Image', 'bixol'); ?></a>
                <?php
            } else {
                ?>
                <a href="#" class="ct-wg-select-image button"><?php esc_html_e('Select Image', 'bixol'); ?></a>
                <a href="#" class="ct-wg-remove-image button" style="display: none;"><?php esc_html_e('Remove Image', 'bixol'); ?></a>
                <?php
            }
            ?>
        </div>
        
        <p>
            <label for="<?php echo esc_url($this->get_field_id('author_name')); ?>"><?php esc_html_e('Author Name', 'bixol'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('author_name')); ?>"
                   name="<?php echo esc_attr($this->get_field_name('author_name')); ?>" type="text"
                   value="<?php echo esc_attr($author_name); ?>"/></p>

        <p>
            <label for="<?php echo esc_url($this->get_field_id('author_position')); ?>"><?php esc_html_e('Author Position', 'bixol'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('author_position')); ?>"
                   name="<?php echo esc_attr($this->get_field_name('author_position')); ?>" type="text"
                   value="<?php echo esc_attr($author_position); ?>"/></p>

        <p>
            <label for="<?php echo esc_url($this->get_field_id('social_facebook')); ?>"><?php esc_html_e('Social Facebook Link', 'bixol'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('social_facebook')); ?>"
                   name="<?php echo esc_attr($this->get_field_name('social_facebook')); ?>" type="text"
                   value="<?php echo esc_attr($social_facebook); ?>"/></p>

        <p>
            <label for="<?php echo esc_url($this->get_field_id('social_twitter')); ?>"><?php esc_html_e('Social Twitter Link', 'bixol'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('social_twitter')); ?>"
                   name="<?php echo esc_attr($this->get_field_name('social_twitter')); ?>" type="text"
                   value="<?php echo esc_attr($social_twitter); ?>"/></p>

        <p>
            <label for="<?php echo esc_url($this->get_field_id('social_linkedin')); ?>"><?php esc_html_e('Social Linkedin Link', 'bixol'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('social_linkedin')); ?>"
                   name="<?php echo esc_attr($this->get_field_name('social_linkedin')); ?>" type="text"
                   value="<?php echo esc_attr($social_linkedin); ?>"/></p>

        <p>
            <label for="<?php echo esc_url($this->get_field_id('social_instagram')); ?>"><?php esc_html_e('Social Instagram Link', 'bixol'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('social_instagram')); ?>"
                   name="<?php echo esc_attr($this->get_field_name('social_instagram')); ?>" type="text"
                   value="<?php echo esc_attr($social_instagram); ?>"/></p>

        <p>
            <label for="<?php echo esc_url($this->get_field_id('social_pinterest')); ?>"><?php esc_html_e('Social Pinterest Link', 'bixol'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('social_pinterest')); ?>"
                   name="<?php echo esc_attr($this->get_field_name('social_pinterest')); ?>" type="text"
                   value="<?php echo esc_attr($social_pinterest); ?>"/></p>

        <p>
            <label for="<?php echo esc_url($this->get_field_id('social_vimeo')); ?>"><?php esc_html_e('Social Vimeo Link', 'bixol'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('social_vimeo')); ?>"
                   name="<?php echo esc_attr($this->get_field_name('social_vimeo')); ?>" type="text"
                   value="<?php echo esc_attr($social_vimeo); ?>"/></p>

        <p>
            <label for="<?php echo esc_url($this->get_field_id('social_youtube')); ?>"><?php esc_html_e('Social Youtube Link', 'bixol'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('social_youtube')); ?>"
                   name="<?php echo esc_attr($this->get_field_name('social_youtube')); ?>" type="text"
                   value="<?php echo esc_attr($social_youtube); ?>"/></p>

        <p>
            <label for="<?php echo esc_url($this->get_field_id('social_tumblr')); ?>"><?php esc_html_e('Social Tumblr Link', 'bixol'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('social_tumblr')); ?>"
                   name="<?php echo esc_attr($this->get_field_name('social_tumblr')); ?>" type="text"
                   value="<?php echo esc_attr($social_tumblr); ?>"/></p>

        <p>
            <label for="<?php echo esc_url($this->get_field_id('social_dribbble')); ?>"><?php esc_html_e('Social Dribbble Link', 'bixol'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('social_dribbble')); ?>"
                   name="<?php echo esc_attr($this->get_field_name('social_dribbble')); ?>" type="text"
                   value="<?php echo esc_attr($social_dribbble); ?>"/></p>

        <p>
            <label for="<?php echo esc_url($this->get_field_id('social_behance')); ?>"><?php esc_html_e('Social Behance Link', 'bixol'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('social_behance')); ?>"
                   name="<?php echo esc_attr($this->get_field_name('social_behance')); ?>" type="text"
                   value="<?php echo esc_attr($social_behance); ?>"/></p>

        <?php
    }

}
function register_authorinfo_widget() {
    if(function_exists('ct_register_wp_widget')){
        ct_register_wp_widget( 'CT_Author_Info' );
    }
}
add_action('widgets_init', 'register_authorinfo_widget');

?>