;(function ($) {

    "use strict";

    /* ===================
     Page reload
     ===================== */
    var scroll_top;
    var window_height;
    var window_width;
    var scroll_status = '';
    var lastScrollTop = 0;
    $(window).on('load', function () {
        $(".ct-loader").fadeOut("slow");
        window_width = $(window).width();
        bixol_col_offset();
        bixol_header_sticky();
        bixol_scroll_to_top();
        bixol_quantity_icon();
        bixol_footer_fixed();
        bixol_topbar();
        $('.ct-image-animate').addClass('active');
    });
    $(window).on('resize', function () {
        window_width = $(window).width();
        bixol_col_offset();
        bixol_footer_fixed();
    });

    $(window).on('scroll', function () {
        scroll_top = $(window).scrollTop();
        window_height = $(window).height();
        window_width = $(window).width();
        if (scroll_top < lastScrollTop) {
            scroll_status = 'up';
        } else {
            scroll_status = 'down';
        }
        lastScrollTop = scroll_top;
        bixol_header_sticky();
        bixol_scroll_to_top();
    });

    $(document).on('click', '.h-btn-search', function () {
        $('.ct-modal-search').addClass('open');
        $('body').addClass('ov-hidden');
        setTimeout(function(){
            $('.ct-modal-search .search-field').focus();
        },1000);
    });

    $(document).ready(function () {

        /* =================
         Menu Dropdown
         =================== */

        // Active Mega Menu Hover
        $('li.megamenu').hover(function(){
                $(this).parents('.elementor-section').addClass('section-mega-active');
            },function(){
                $(this).parents('.elementor-section').removeClass('section-mega-active');
        });

        var $menu = $('.ct-main-navigation');
        $menu.find('.ct-main-menu li').each(function () {
            var $submenu = $(this).find('> ul.sub-menu');
            if ($submenu.length == 1) {
                $(this).hover(function () {
                    if ($submenu.offset().left + $submenu.width() > $(window).width()) {
                        $submenu.addClass('back');
                    } else if ($submenu.offset().left < 0) {
                        $submenu.addClass('back');
                    }
                }, function () {
                    $submenu.removeClass('back');
                });
            }
        });

        $('.ct-mega-menu-2columns').parents('.menu-item').addClass('ct-mega-menu-2columns');
        $('.ct-mega-full').parents('#ct-header-elementor').addClass('ct-mega-fw');

        /* Main Header */
        $('.ct-header-fixed-transparent').parents('.ct-header-elementor-main').addClass('ct-header-fixed-transparent-wrap');
        $('.ct-header-elementor-sticky').parents('body').addClass('header-sticky');

        /* =================
         Menu Mobile
         =================== */

        $('.ct-main-navigation li.menu-item-has-children').append('<span class="ct-menu-toggle far fac-angle-down"></span>');
        $('.ct-menu-toggle').on('click', function () {
            $(this).toggleClass('toggle-open');
            $(this).parent().find('> .sub-menu').toggleClass('submenu-open');
            $(this).parent().find('> .sub-menu').slideToggle();
        });

        $(".ct-main-menu li a.is-one-page").on('click', function () {
           $(this).parents('.ct-header-navigation').removeClass('navigation-open');
           $(this).parents('.ct-header-main').find('.btn-nav-mobile').removeClass('opened');
           $(this).parents('.ct-header-main').find('.ct-menu-overlay').removeClass('active');
        });
        
        $("#ct-menu-mobile .open-menu").on('click', function () {
            $(this).toggleClass('opened');
            $('.ct-header-navigation').toggleClass('navigation-open');
            $('.ct-menu-overlay').toggleClass('active');
        });

        $(".ct-menu-close").on('click', function () {
            $(this).parents('.header-navigation').removeClass('navigation-open');
            $('.ct-menu-overlay').removeClass('active');
            $('#ct-menu-mobile .open-menu').removeClass('opened');
            $('body').removeClass('ovhidden');
        });

        $(".ct-menu-overlay").on('click', function () {
            $(this).parents('#ct-header').find('.ct-header-navigation').removeClass('navigation-open');
            $(this).removeClass('active');
            $('#ct-menu-mobile .open-menu').removeClass('opened');
            $('.header-navigation').removeClass('navigation-open');
            $('body').removeClass('ovhidden');
        });

        window_width = $(window).width();
        if (window_width < 1199) {
            $('.ct-main-menu li.menu-item-has-children > a').on("click", function (e) {
                e.preventDefault();
                $(this).parent().find('> .sub-menu, > .children').toggleClass('submenu-open');
                $(this).parent().find('> .sub-menu, > .children').slideToggle();
                $(this).parent().find('> .ct-menu-toggle').toggleClass('toggle-open');
            });
            $('.mobile-menu-hide-click .ct-main-menu li a').on("click", function (e) {
                e.preventDefault();
                $(this).parents('.ct-header-navigation').removeClass('navigation-open');
                $(this).parents('.ct-header-main').find('.btn-nav-mobile').removeClass('open-menu');
                $(this).parents('.ct-header-main').find('.btn-nav-mobile').removeClass('opened');
            });
            $('.mobile-menu-hide-click .ct-header-button-mobile a').on("click", function (e) {
                e.preventDefault();
                $(this).parents('.ct-header-navigation').removeClass('navigation-open');
                $(this).parents('.ct-header-main').find('.btn-nav-mobile').removeClass('open-menu');
                $(this).parents('.ct-header-main').find('.btn-nav-mobile').removeClass('opened');
            });
        }

        /* ===================
         Search Toggle
         ===================== */
        $('.h-btn-form').click(function (e) {
            e.preventDefault();
            $('.ct-modal-contact-form').removeClass('remove').toggleClass('open');
        });
        $('.ct-close').click(function (e) {
            e.preventDefault();
            $(this).parents('.ct-widget-cart-wrap').removeClass('open');
            $(this).parents('.ct-modal').addClass('remove').removeClass('open');
            $(this).parents('#page').find('.site-overlay').removeClass('open');
            $(this).parents('body').removeClass('ov-hidden');
        });

        $('.ct-hidden-sidebar-overlay, .ct-widget-cart-overlay').click(function (e) {
            e.preventDefault();
            $(this).parent().toggleClass('open');
            $(this).parents('body').removeClass('ov-hidden');
        });

        /* Video 16:9 */
        $('.entry-video iframe').each(function () {
            var v_width = $(this).width();

            v_width = v_width / (16 / 9);
            $(this).attr('height', v_width + 35);
        });

        /* Video Light Box */
        $('.ct-video-button, .btn-video, .slider-video').magnificPopup({
            type: 'iframe',
            mainClass: 'mfp-fade',
            removalDelay: 160,
            preloader: false,
            fixedContentPos: false
        });
        
        /* ====================
         Scroll To Top
         ====================== */
        $('.scroll-top').click(function () {
            $('html, body').animate({scrollTop: 0}, 800);
            return false;
        });

        /* =================
        Add Class
        =================== */
        $('.wpcf7-select').parent().addClass('wpcf7-menu');
        

        /* =================
         The clicked item should be in center in owl carousel
         =================== */
        var $owl_item = $('.owl-active-click');
        $owl_item.children().each(function (index) {
            $(this).attr('data-position', index);
        });
        $(document).on('click', '.owl-active-click .owl-item > div', function () {
            $owl_item.trigger('to.owl.carousel', $(this).data('position'));
        });

        /* Select */
        $('select:not([id*="ui-id-"]):not(#billing_country):not(#shipping_country):not(#billing_state):not(.gt_selector):not(.wpforms-form):not(.variations_form)').each(function () {
            $(this).niceSelect();
        });

        /* Newsletter */
        $('.widget_newsletterwidget, form.newsletter').each(function () {
            var email_text = $(this).find('.tnp-field-email label').text();
            $(this).find('.tnp-field-email label').remove();
            $(this).find(".tnp-email").each(function (ev) {
                if (!$(this).val()) {
                    $(this).attr("placeholder", email_text);
                }
            });
            var firstname_text = $(this).find('.tnp-field-firstname label').text();
            $(this).find('.tnp-field-firstname label').remove();
            $(this).find(".tnp-firstname").each(function (ev) {
                if (!$(this).val()) {
                    $(this).attr("placeholder", firstname_text);
                }
            });
            var lastname_text = $(this).find('.tnp-field-lastname label').text();
            $(this).find('.tnp-field-lastname label').remove();
            $(this).find(".tnp-lastname").each(function (ev) {
                if (!$(this).val()) {
                    $(this).attr("placeholder", lastname_text);
                }
            });
        });

        /* Mailchimp */
        $('.ct-mailchimp').each(function () {
            var email_text = $(this).find('.mailchimp-email').data( "email-value" );
            var button_text = $(this).find('.mailchimp-button').data( "button-value" );
            if($('#mailchimp-email').hasClass('mailchimp-email')) {
                $(this).find('[type="email"]').attr("placeholder", email_text);
            }
            if($('#mailchimp-button').hasClass('mailchimp-button')) {
                $(this).find('[type="submit"]').attr("value", button_text);
            }
        });

        /* Search */
        $('.ct-modal-close').on('click', function () {
            $(this).parent().removeClass('open');
            $(this).parents('body').removeClass('ov-hidden');
        });
        $(document).on('click', function (e) {
            if (e.target.className == 'ct-modal ct-modal-search open')
                $('.ct-modal-search').removeClass('open');
            if (e.target.className == 'ct-hidden-sidebar open')
                $('.ct-hidden-sidebar').removeClass('open');
        });

        /* Hidden Sidebar */
        $(".h-btn-sidebar").on('click', function (e) {
            e.preventDefault();
            $('.ct-hidden-sidebar-wrap').toggleClass('open');
            $(this).parents('body').addClass('ov-hidden');
        });

        $(".ct-hidden-close").on('click', function (e) {
            e.preventDefault();
            $(this).parents('.ct-hidden-sidebar-wrap').removeClass('open');
            $(this).parents('body').removeClass('ov-hidden');
        });

        /* Cart Sidebar */
        $(".h-btn-cart, .btn-nav-cart").on('click', function (e) {
            e.preventDefault();
            $('.ct-widget-cart-wrap').toggleClass('open');
            $('.ct-header-navigation').removeClass('navigation-open');
            $('#ct-menu-mobile .open-menu').removeClass('opened');
            $(this).parents('body').addClass('ov-hidden');
        });

        /* Year Copyright */
        var _year_footer = $(".ct-footer-year"),
            _year_clone = _year_footer.parents(".site").find('.ct-year');
        _year_clone.after(_year_footer.clone());
        _year_footer.remove();
        _year_clone.remove();


        /* Comment Reply */
        $('.comment-reply a').append( '<i class="fac fa-angle-right"></i>' );

        /* Nav Slider */
        setTimeout(function () {
            $('.revslider-initialised').each(function () {
                $(this).find('.ct-slider-nav .slider-nav-right').on('click', function () {
                    $(this).parents('.revslider-initialised').find('.tp-rightarrow').trigger('click');
                });
                $(this).find('.ct-slider-nav .slider-nav-left').on('click', function () {
                    $(this).parents('.revslider-initialised').find('.tp-leftarrow').trigger('click');
                });
            });
            $('.ct-slider-nav').parents('.revslider-initialised').find('.tparrows').addClass('arrow-hidden');
        }, 300);

        /* Icon Form */
        setTimeout(function () {
            $('.input-filled').each(function () {
                var icon_input = $(this).find(".input-icon"),
                    control_wrap = $(this).find('.wpcf7-form-control');
                control_wrap.before(icon_input.clone());
                icon_input.remove();
            });
        }, 200);

        /* Same Height */
        $('.same-height').matchHeight();
        $('.ct-client-grid1 .grid-item').matchHeight();

        /* Demo Bar */
        $(".choose-demo").on('click', function () {
            $(this).parents('.ct-demo-bar').toggleClass('active');
        });

        /* Animate Time */
        $('.animate-time').each(function () {
            var eltime = 100;
            var elt_inner = $(this).children().length;
            var _elt = elt_inner - 1;
            $(this).find('> .grid-item > .wow').each(function (index, obj) {
                $(this).css('animation-delay', eltime + 'ms');
                if (_elt === index) {
                    eltime = 100;
                    _elt = _elt + elt_inner;
                } else {
                    eltime = eltime + 80;
                }
            });
        });

        /* Pricing */
        $('.ct-pricing-body').each(function () {
            $(this).find('.item--first').hover(function () {
                $(this).parent().addClass('item--first-active');
            }, function () {
                $(this).parent().removeClass('item--first-active');
            });
            $(this).find('.item--last').hover(function () {
                $(this).parent().addClass('item--last-active');
            }, function () {
                $(this).parent().removeClass('item--last-active');
            });
        });

        $(".item--nav").on('click', function () {
            $(this).parent().toggleClass('active');
            $(this).parents('.ct-pricing').find('.ct-pricing-monthly').toggleClass('pr-hide');
            $(this).parents('.ct-pricing').find('.ct-pricing-year').toggleClass('pr-active');
        });

        /* Cover Boxes */
        $('body:not(.elementor-editor-active) .ct-cover-boxes1 .ct-cover-item').each(function () {
            $(this).hover(function () {
                $(this).parents('.ct-cover-boxes1').find('.ct-cover-item').removeClass('active');
                $(this).addClass('active');
            });
        });

        /* Overlay particle */
        $('.ctf-author-box-link').removeAttr('target');

        setTimeout(function(){
            $('.elementor > .elementor-element').each(function () {
                var _el_image = $(this).find(".ct-image-animate"),
                    _row_image = _el_image.parents(".elementor-container");
                _row_image.before(_el_image.clone());
                _el_image.remove();

                var _el_text = $(this).find(".ct-text"),
                    _row_text = _el_text.parents(".elementor-container");
                _row_text.before(_el_text.clone());
                _el_text.remove();
            });
        }, 200);

        /* Blog */
        $( ".ct-blog-carousel-layout2 .grid-item-inner, .ct-blog-grid-layout2 .grid-item-inner, .ct-blog-carousel-layout3.style2 .grid-item-inner" ).hover(
          function() {
            $( this ).find('.item--readmore').slideToggle(200);
            $( this ).find('.item--meta').slideToggle(200);
          }, function() {
            $( this ).find('.item--readmore').slideToggle(200);
            $( this ).find('.item--meta').slideToggle(200);
          }
        );

        /* Range Slider */
        $('.wpcf7-form').each(function () {
            var range = $(this).find('.ct-range-slider');
            var range_value = $(this).find('.ct-range-slider').attr('data-value');
            var range_maxvalue = $(this).find('.ct-range-slider').attr('data-maxvalue');
            var range_currency = $(this).find('.ct-range-slider').attr('data-currency');
            $(this).find( ".ct-range-slider" ).slider({
                range: "min",
                value: range_value,
                min: 1,
                max: range_maxvalue,
                slide: function( event, ui ) {
                    $(this).parent().find( ".ct-range-result" ).val( range_currency + ui.value );
                }
            });
            $(this).find( ".ct-range-result" ).val( range_currency + $(this).find( ".ct-range-slider" ).slider( "value" ) );
        });

        /* Pricing */
        $(".ct-pricing-tab-active .ct-pricing-tab-item").on('click', function () {
            $(this).parent().find('.ct-pricing-tab-item').removeClass('active');
            $(this).addClass('active');
        });
        $(".ct-pricing-tab-active .title-tab-monthly").on('click', function () {
            $(this).parents('.ct-pricing').find('.ct-pricing-monthly').removeClass('ct-pricing-hide');
            $(this).parents('.ct-pricing').find('.ct-pricing-year').addClass('ct-pricing-hide');
        });
        $(".ct-pricing-tab-active .title-tab-year").on('click', function () {
            $(this).parents('.ct-pricing').find('.ct-pricing-year').removeClass('ct-pricing-hide');
            $(this).parents('.ct-pricing').find('.ct-pricing-monthly').addClass('ct-pricing-hide');
        });

        /* Team */
        $('.item--social-btn').on('click', function () {
            $(this).toggleClass('active');
            $(this).parent().toggleClass('active');
        });

        /* Service */
        $( ".ct-service-grid4 .grid-item-inner" ).hover(
          function() {
            $( this ).find('.item-readmore').slideToggle(300);
          }, function() {
            $( this ).find('.item-readmore').slideToggle(300);
          }
        );

        $( ".ct-service-grid3 .grid-item-inner" ).hover(
          function() {
            $( this ).find('.item--content').slideToggle(300);
          }, function() {
            $( this ).find('.item--content').slideToggle(300);
          }
        );

        /* Mega menu max height */
        var m_h_mega = $('li.megamenu > .sub-menu > li > .container').outerHeight();
        var w_h_mega = $(window).height();
        var w_h_mega_css = w_h_mega - 140;
        if(m_h_mega > w_h_mega) {
            $('li.megamenu > .sub-menu > li > .container').css('max-height', w_h_mega_css + 'px');
            $('li.megamenu > .sub-menu > li > .container').css('overflow-x', 'scroll');
        }

        $('.section-remove-ov').parents('.site-content ').addClass('rm-overflow-hidden');

        $('.case-animate-time').each(function () {
            var eltime = 0;
            var elt_inner = $(this).children().length;
            var _elt = elt_inner - 1;
            $(this).find('> .slide-in-container > .wow').each(function (index, obj) {
                $(this).css('transition-delay', eltime + 'ms');
                if (_elt === index) {
                    eltime = 0;
                    _elt = _elt + elt_inner;
                } else {
                    eltime = eltime + 80;
                }
            });
        });

        // Section Divider
        $('.pxl-divider-curved').each(function () {
            $(this).append('<div class="pxl-curved-inner"><svg class="pxl-svg-top" xmlns="http://www.w3.org/2000/svg" width="100%" viewBox="0 0 100 100" version="1.1" preserveAspectRatio="none"><path stroke-width="0" d="M0 100 C50 0 50 0 100 100 Z"></path></svg><svg class="pxl-svg-bottom" xmlns="http://www.w3.org/2000/svg" width="100%" viewBox="0 0 100 100" version="1.1" preserveAspectRatio="none"><path stroke-width="0" d="M0 100 C50 0 50 0 100 100 Z"></path></svg></div>');
        });

    });

    function bixol_header_sticky() {
        var offsetTop = $('#ct-header-wrap').outerHeight();
        var offsetTopElementor = $('#ct-header-elementor').outerHeight();
        var h_header = $('.fixed-height').outerHeight();
        var offsetTopAnimation = offsetTop + 200;
        var offsetTopAnimationElementor = offsetTopElementor + 200;
        if($('#ct-header-wrap').hasClass('is-sticky')) {
            if (scroll_top > offsetTopAnimation) {
                $('#ct-header').addClass('h-fixed');
            } else {
                $('#ct-header').removeClass('h-fixed');   
            }
        }
        if($('#ct-header-elementor').hasClass('is-sticky')) {
            if (scroll_top > offsetTopAnimationElementor) {
                $('.ct-header-elementor-sticky').addClass('h-fixed');
            } else {
                $('.ct-header-elementor-sticky').removeClass('h-fixed');   
            }
        }
        if (window_width > 1200) {
            $('.fixed-height').css({
                'height': h_header
            });
        }
        if (scroll_status == 'up' && scroll_top > 0) {
            $('#ct-header').addClass('scroll-up');
        } else {
            $('#ct-header').removeClass('scroll-up');
        }
        if (scroll_status == 'down') {
            $('#ct-header').addClass('scroll-down');
        } else {
            $('#ct-header').removeClass('scroll-down');
        }

        if($('#ct-header-mobile').hasClass('is-sticky')) {
            if (scroll_top > 200) {
                $('.ct-header-mobile').addClass('h-fixed');
            } else {
                $('.ct-header-mobile').removeClass('h-fixed');   
            }
        }
    }

    /* =================
     Column Offset
     =================== */
    function bixol_col_offset() {
        var w_vc_row_lg = ($('#content').width() - 1200) / 2;
        if (window_width > 1200) {
            $('body:not(.rtl) .col-offset-left > .elementor-column-wrap > .elementor-widget-wrap').css('padding-left', w_vc_row_lg + 'px');
            $('body:not(.rtl) .col-offset-right > .elementor-column-wrap > .elementor-widget-wrap').css('padding-right', w_vc_row_lg + 'px');

            $('.rtl .col-offset-left > .elementor-column-wrap > .elementor-widget-wrap').css('padding-right', w_vc_row_lg + 'px');
            $('.rtl .col-offset-right > .elementor-column-wrap > .elementor-widget-wrap').css('padding-left', w_vc_row_lg + 'px');
        }

        $('.ct-box-background.offset-right').each(function () {
            var box_offset_left = $(this).offset().left;
            var box_width = $(this).outerWidth();
            var offset_right = window_width - (box_offset_left + box_width);
            $(this).css('margin-right', '-' + offset_right + 'px');
        });
    }

    /* =================
     Footer Fixed
     =================== */
    function bixol_footer_fixed() {
        setTimeout(function(){
            var h_footer = $('.fixed-footer .site-footer-custom').outerHeight() - 1;
            $('.fixed-footer .site-content').css('margin-bottom', h_footer + 'px');
        }, 300);
    }

    /* ====================
     Scroll To Top
     ====================== */
    function bixol_scroll_to_top() {
        if (scroll_top < window_height) {
            $('.scroll-top').addClass('off').removeClass('on');
        }
        if (scroll_top > window_height) {
            $('.scroll-top').addClass('on').removeClass('off');
        }
    }

    /* ====================
     WooComerce Quantity
     ====================== */
    function bixol_quantity_icon() {
        $('#content .quantity').append('<span class="quantity-icon"><i class="quantity-down fa fa-sort-desc"></i><i class="quantity-up fa fa-sort-asc"></i></span>');
        $('.quantity-up').on('click', function () {
            $(this).parents('.quantity').find('input[type="number"]').get(0).stepUp();
            $(this).parents('.woocommerce-cart-form').find('.actions .button').removeAttr('disabled');
        });
        $('.quantity-down').on('click', function () {
            $(this).parents('.quantity').find('input[type="number"]').get(0).stepDown();
            $(this).parents('.woocommerce-cart-form').find('.actions .button').removeAttr('disabled');
        });
        $('.woocommerce-cart-form .actions .button').removeAttr('disabled');
    }

    $( document ).ajaxComplete(function() {
       bixol_quantity_icon();
    });

    function bixol_topbar() {
        var w_logo = $('.ct-header-layout1 .ct-header-branding').outerWidth();
        var w_logo_spacer = w_logo + 38;

        $('body:not(.rtl) .ct-header-layout1 .ct-topbar-layout1 .ct-topbar-meta').css('padding-left', w_logo_spacer + 'px');
        $('body.rtl .ct-header-layout1 .ct-topbar-layout1 .ct-topbar-meta').css('padding-right', w_logo_spacer + 'px');
    }

})(jQuery);
