<?php

$files = scandir(get_template_directory() . '/elementor/core/register');

foreach ($files as $file){
    $pos = strrpos($file, ".php");
    if($pos !== false){
        require_once get_template_directory() . '/elementor/core/register/' . $file;
    }
}

if(!function_exists('bixol_register_custom_icon_library')){
    add_filter('elementor/icons_manager/native', 'bixol_register_custom_icon_library');
    function bixol_register_custom_icon_library($tabs){
        $custom_tabs = [
            'extra_icon1' => [
                'name' => 'material',
                'label' => esc_html__( 'Material Design Iconic', 'bixol' ),
                'url' => get_template_directory_uri() . '/assets/css/material-design-iconic-font.min.css',
                'enqueue' => [  ],
                'prefix' => 'zmdi zmdi-',
                'displayPrefix' => 'material',
                'labelIcon' => 'zmdi zmdi-collection-text',
                'ver' => '1.0.0',
                'fetchJson' => get_template_directory_uri() . '/assets/elementor-icon/materialdesign.js',
                'native' => true,
            ],

            'extra_icon2' => [
                'name' => 'flaticon',
                'label' => esc_html__( 'Flaticon V1', 'bixol' ),
                'url' => get_template_directory_uri() . '/assets/css/flaticon.css',
                'enqueue' => [  ],
                'prefix' => 'flaticon-',
                'displayPrefix' => 'flaticon',
                'labelIcon' => 'flaticon-clean',
                'ver' => '1.0.0',
                'fetchJson' => get_template_directory_uri() . '/assets/elementor-icon/flaticon.js',
                'native' => true,
            ],

            'extra_icon3' => [
                'name' => 'flaticonv2',
                'label' => esc_html__( 'Flaticon V2', 'bixol' ),
                'url' => get_template_directory_uri() . '/assets/css/flaticon-v2.css',
                'enqueue' => [  ],
                'prefix' => 'flaticonv2-',
                'displayPrefix' => 'flaticonv2',
                'labelIcon' => 'flaticonv2-settings',
                'ver' => '1.0.0',
                'fetchJson' => get_template_directory_uri() . '/assets/elementor-icon/flaticon-v2.js',
                'native' => true,
            ],

            'extra_icon4' => [
                'name' => 'flaticonv3',
                'label' => esc_html__( 'Flaticon V3', 'bixol' ),
                'url' => get_template_directory_uri() . '/assets/css/flaticon-v3.css',
                'enqueue' => [  ],
                'prefix' => 'flaticon3-',
                'displayPrefix' => 'flaticon3',
                'labelIcon' => 'flaticon3-location-pin',
                'ver' => '1.0.0',
                'fetchJson' => get_template_directory_uri() . '/assets/elementor-icon/flaticon-v3.js',
                'native' => true,
            ],

        ];

        $tabs = array_merge($custom_tabs, $tabs);

        return $tabs;
    }
}