<?php
ct_add_custom_widget(
    array(
        'name' => 'ct_box_background',
        'title' => esc_html__('Case Box Background', 'bixol'),
        'icon' => 'eicon-posts-ticker',
        'categories' => array(Case_Theme_Core::CT_CATEGORY_NAME),
        'scripts' => array(
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'bixol'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'image',
                            'label' => esc_html__('Image Overlay', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                        ),
                        array(
                            'name' => 'box_color',
                            'label' => esc_html__('Box Color', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .ct-box-background' => 'background-color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'offset',
                            'label' => esc_html__('Offset', 'bixol' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'offset-none',
                            'options' => [
                                'offset-none' => esc_html__('None', 'bixol' ),
                                'offset-right' => esc_html__('Right', 'bixol' ),
                            ],
                        ),
                    ),
                ),
            ),
        ),
    ),
    get_template_directory() . '/elementor/core/widgets/'
);