<?php
$default_settings = [
    'style' => '',
    'banner_image' => '',
    'banner_image_two' => '',
    'banner_title' => '',
    'banner_number' => '',
    'banner_number_suffix' => '',
    'box_align' => '',
    'theme_custom_font' => '',
    'ct_animate' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);

$widget->add_render_attribute( 'selected_icon', 'class' );
$has_icon = ! empty( $selected_icon );
if ( $has_icon ) {
    $widget->add_render_attribute( 'i', 'class', $selected_icon );
    $widget->add_render_attribute( 'i', 'aria-hidden', 'true' );
}
$is_new = \Elementor\Icons_Manager::is_migration_allowed();
if(!empty($banner_image['id'])) : 

	$size = 'full';
	if($style == 'style3') {
		$size = '480x400';
	}

	$img = ct_get_image_by_size( array(
		'attach_id'  => $banner_image['id'],
		'thumb_size' => $size,
		'class' => 'ct-banner-image1'
	));
	$thumbnail = $img['thumbnail'];
	?>
	<div class="ct-banner1 <?php echo esc_attr($ct_animate.' '.$box_align.' '.$style); ?>">
		<div class="ct-banner-inner <?php if($style == 'style5') { echo esc_attr($theme_custom_font); } ?>">
			<?php echo wp_kses_post($thumbnail); ?>
			<?php if($style == 'style3' && !empty($banner_image_two['id']) ) :
				$img2 = ct_get_image_by_size( array(
					'attach_id'  => $banner_image_two['id'],
					'thumb_size' => '372x401',
				));
				$thumbnail2 = $img2['thumbnail'];
				?>
				<div class="ct-banner-image2">
					<?php echo wp_kses_post($thumbnail2); ?>
				</div>
			<?php endif; ?>
			<div class="ct-banner-holder">
				<?php if ( $has_icon ) : ?>
			        <div class="item--icon icon-psb">
			            <?php if($is_new):
			                \Elementor\Icons_Manager::render_icon( $selected_icon, [ 'aria-hidden' => 'true' ] );
			                else: ?>
			                <i <?php ct_print_html($widget->get_render_attribute_string( 'i' )); ?>></i>
			            <?php endif; ?>
			        </div>
			    <?php endif; ?>
				<div class="ct-banner-meta">
					<?php if($style == 'style4' || $style == 'style5') { ?>
						<div class="ct-banner-number">
							<span class="ct-counter-number-value" data-duration="2000" data-to-value="<?php echo esc_attr($banner_number); ?>" data-delimiter="."></span>
							<span class="ct-counter-number-suffix"><?php echo esc_attr($banner_number_suffix); ?></span>
						</div>
					<?php } else { ?>
						<div class="ct-banner-number"><?php echo esc_attr($banner_number); ?></div>
					<?php } ?>
					<h4 class="ct-banner-title"><?php echo esc_attr($banner_title); ?></h4>
				</div>
				<?php if($style == 'style1') : ?>
					<svg class="svg-primary" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 123 112">
					  <path class="svg-banner1" d="M22.46,0.262a673.892,673.892,0,0,1,80.844,6.4c10.079,0.592,18.735,9.565,19.027,19.5,0.3,10.95.4,40.706,0.279,51.6-0.133,9.926-8.631,18.351-18.682,18.816-27.125,3.568-54.074,7.216-81.04,8.5-10.037-.5-18.485-9.1-18.424-18.875,0.077-15.525.671-50.13,0.527-66.126C4.9,9.975,12.466.983,22.46,0.262h0Z"/>
					</svg>
					<svg class="svg-secondary" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 123 112">
					  <path class="svg-banner1" d="M22.46,0.262a673.892,673.892,0,0,1,80.844,6.4c10.079,0.592,18.735,9.565,19.027,19.5,0.3,10.95.4,40.706,0.279,51.6-0.133,9.926-8.631,18.351-18.682,18.816-27.125,3.568-54.074,7.216-81.04,8.5-10.037-.5-18.485-9.1-18.424-18.875,0.077-15.525.671-50.13,0.527-66.126C4.9,9.975,12.466.983,22.46,0.262h0Z"/>
					</svg>
				<?php endif; ?>
			</div>
		</div>
	</div>
<?php endif; ?>