<?php
$default_settings = [
    'banner_image' => '',
    'banner_title' => '',
    'banner_phone' => '',
    'banner_phone_link' => '',
    'ct_animate' => '',
    'pxl_icon' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);

$widget->add_render_attribute( 'pxl_icon', 'class' );
$has_icon = ! empty( $pxl_icon );
if ( $has_icon ) {
    $widget->add_render_attribute( 'i', 'class', $pxl_icon );
    $widget->add_render_attribute( 'i', 'aria-hidden', 'true' );
}
$is_new = \Elementor\Icons_Manager::is_migration_allowed();
if(!empty($banner_image['id'])) : 

	$size = 'full';

	$img = ct_get_image_by_size( array(
		'attach_id'  => $banner_image['id'],
		'thumb_size' => $size,
		'class' => 'ct-banner-image1'
	));
	$thumbnail = $img['thumbnail'];
	?>
	<div class="ct-banner3 <?php echo esc_attr($ct_animate); ?>">
		<div class="ct-banner-inner">
			<?php echo wp_kses_post($thumbnail); ?>
			<div class="ct-banner-holder">
				<?php if ( $has_icon ) : ?>
			        <div class="item--icon">
			            <?php if($is_new):
			                \Elementor\Icons_Manager::render_icon( $pxl_icon, [ 'aria-hidden' => 'true' ] );
			                else: ?>
			                <i <?php ct_print_html($widget->get_render_attribute_string( 'i' )); ?>></i>
			            <?php endif; ?>
			        </div>
			    <?php endif; ?>
				<div class="ct-banner-meta">
					<div class="ct-banner-title"><?php echo esc_attr($banner_title); ?></div>
					<div class="ct-banner-phone"><?php echo esc_attr($banner_phone); ?></div>
				</div>
				<?php if(!empty($banner_phone_link)) : ?>
					<a class="ct-banner-link" href="<?php echo esc_attr($banner_phone_link); ?>"></a>
				<?php endif; ?>
			</div>
		</div>
	</div>
<?php endif; ?>