<?php
$widget->add_render_attribute( 'counter', [
    'class' => 'ct-counter-number-value',
    'data-duration' => $settings['duration'],
    'data-to-value' => $settings['ending_number'],
] );

if ( ! empty( $settings['thousand_separator'] ) ) {
    $delimiter = empty( $settings['thousand_separator_char'] ) ? '' : $settings['thousand_separator_char'];
    $widget->add_render_attribute( 'counter', 'data-delimiter', $delimiter );
}

$widget->add_render_attribute( 'selected_icon', 'class' );
$has_icon = ! empty( $settings['selected_icon'] );
if ( $has_icon ) {
    $widget->add_render_attribute( 'i', 'class', $settings['selected_icon'] );
    $widget->add_render_attribute( 'i', 'aria-hidden', 'true' );
}

$is_new = \Elementor\Icons_Manager::is_migration_allowed();
?>
<div class="ct-counter ct-counter-layout1 <?php echo esc_attr($settings['ct_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['ct_animate_delay']); ?>ms">
    <div class="ct-counter-inner">
        <?php if ( $settings['ct_icon_type'] == 'icon' && $has_icon ) : ?>
            <div class="item--icon <?php echo esc_attr($settings['icon_style']); ?>">
                <?php if($is_new):
                    \Elementor\Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] );
                    else: ?>
                    <i <?php ct_print_html($widget->get_render_attribute_string( 'i' )); ?>></i>
                <?php endif; ?>
            </div>
        <?php endif; ?>
        <?php if ( $settings['ct_icon_type'] == 'image' && !empty($settings['ct_icon_image']['id']) ) : ?>
            <div class="item--icon <?php echo esc_attr($settings['icon_style']); ?>">
                <?php $img_icon  = ct_get_image_by_size( array(
                        'attach_id'  => $settings['ct_icon_image']['id'],
                        'thumb_size' => 'full',
                    ) );
                    $thumbnail_icon    = $img_icon['thumbnail'];
                echo ct_print_html($thumbnail_icon); ?>
            </div>
        <?php endif; ?>
        <div class="ct-counter-holder">
            <div class="ct-counter-number <?php echo esc_attr($settings['theme_custom_font']); ?>">
                <?php if(!empty($settings['prefix'])) : ?>
                    <span class="ct-counter-number-prefix"><?php echo ct_print_html($settings['prefix']); ?></span>
                <?php endif; ?>
                <span <?php ct_print_html($widget->get_render_attribute_string( 'counter' )); ?>><?php echo esc_html($settings['starting_number']); ?></span>
                <?php if(!empty($settings['suffix'])) : ?>
                    <span class="ct-counter-number-suffix"><?php echo ct_print_html($settings['suffix']); ?></span>
                <?php endif; ?>
            </div>
            <?php if ( $settings['title'] ) : ?>
                <div class="ct-counter-title"><?php echo ct_print_html($settings['title']); ?></div>
            <?php endif; ?>
        </div>
    </div>
</div>