<?php
$widget->add_render_attribute( 'selected_icon', 'class' );
$has_icon = ! empty( $settings['selected_icon'] );
if ( $has_icon ) {
    $widget->add_render_attribute( 'i', 'class', $settings['selected_icon'] );
    $widget->add_render_attribute( 'i', 'aria-hidden', 'true' );
}

$widget->add_render_attribute( 'description_text', 'class', 'item--description fs-desc-md' );

$widget->add_inline_editing_attributes( 'title_text', 'none' );
$widget->add_inline_editing_attributes( 'description_text' );

$is_new = \Elementor\Icons_Manager::is_migration_allowed();

if ( ! empty( $settings['item_link_l3']['url'] ) ) {
    $widget->add_render_attribute( 'button', 'href', $settings['item_link_l3']['url'] );

    if ( $settings['item_link_l3']['is_external'] ) {
        $widget->add_render_attribute( 'button', 'target', '_blank' );
    }

    if ( $settings['item_link_l3']['nofollow'] ) {
        $widget->add_render_attribute( 'button', 'rel', 'nofollow' );
    }
}

?>
<div class="ct-fancy-box ct-fancy-box-layout3 <?php echo esc_attr($settings['style_l3']); ?> <?php echo esc_attr($settings['ct_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['ct_animate_delay']); ?>ms">
    <?php if ( $settings['icon_type'] == 'icon' && $has_icon ) : ?>
        <div class="item--icon icon-psb">
            <?php if($is_new):
                \Elementor\Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] );
                else: ?>
                <i <?php ct_print_html($widget->get_render_attribute_string( 'i' )); ?>></i>
            <?php endif; ?>
            <?php if($settings['style_l3'] == 'style2') : ?>
                <span class="item--number"><?php echo esc_attr($settings['number']); ?></span>
            <?php endif; ?>
        </div>
    <?php endif; ?>
    <?php if ( $settings['icon_type'] == 'image' && !empty($settings['icon_image']['id']) ) : ?>
        <div class="item--icon icon-psb">
            <?php $img_icon  = ct_get_image_by_size( array(
                    'attach_id'  => $settings['icon_image']['id'],
                    'thumb_size' => 'full',
                ) );
                $thumbnail_icon    = $img_icon['thumbnail'];
            echo ct_print_html($thumbnail_icon); ?>
            <?php if($settings['style_l3'] == 'style2') : ?>
                <span class="item--number"><?php echo esc_attr($settings['number']); ?></span>
            <?php endif; ?>
        </div>
    <?php endif; ?>
    <div class="item--holder">
        <h3 class="item--title ct-title-line">
            <?php echo ct_print_html($settings['title_text']); ?>
        </h3>
        <div <?php ct_print_html($widget->get_render_attribute_string( 'description_text' )); ?>><?php echo ct_print_html($settings['description_text']); ?></div>
    </div>

    <?php if ( ! empty( $settings['item_link_l3']['url'] ) && $settings['style_l3'] == 'style3' ) { ?>
        <a class="item--link" <?php ct_print_html($widget->get_render_attribute_string( 'button' )); ?>></a>
    <?php } ?>
</div>