<?php
$default_settings = [
    'title' => '',
    'title_tag' => 'h3',
    'style' => 'st-default',
    'sub_title_style' => 'st-default',
    'sub_title' => '',
    'content_alignment_section' => 'left',
    'text_align' => '',
    'ct_animate' => '',
    'ct_animate_delay' => '',
    'ct_icon' => '',
    'highlight_image' => '',
    'ct_animate_sub' => '',
    'ct_animate_delay_sub' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings); 
$is_new = \Elementor\Icons_Manager::is_migration_allowed();
$primary_color = bixol_get_opt( 'primary_color' );
$secondary_color = bixol_get_opt( 'secondary_color' );
$editor_title = $widget->get_settings_for_display( 'title' );
$editor_title = $widget->parse_text_editor( $editor_title );
$html_id = ct_get_element_id($settings);
?>
<div id="<?php echo esc_attr($html_id); ?>" class="ct-heading h-align-<?php echo esc_attr($text_align); ?> ct-heading-<?php echo esc_attr($content_alignment_section); ?> item-<?php echo esc_attr($style); ?>">
	<div class="ct-heading--inner">
        <div class="ct-inline-css"  data-css="
            <?php if( !empty($highlight_image['url']) ) : ?>
                #<?php echo esc_attr($html_id) ?>.ct-heading .ct-text-highlight::before {
                    background-image: url(<?php echo esc_url($highlight_image['url']); ?>);
                }
            <?php endif; ?>">
        </div>
        <?php if(!empty($sub_title)) : ?>
    		<div class="item--sub-title <?php echo esc_attr($sub_title_style); ?> <?php echo esc_attr($ct_animate_sub); ?>" data-wow-delay="<?php echo esc_attr($ct_animate_delay_sub); ?>ms">
                <div class="item--sub-title-inner">
                    <?php if($sub_title_style == 'st-default') : ?>
                        <div class="icon-sub-title">
                            <svg version="1.0" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 382.000000 382.000000" preserveAspectRatio="xMidYMid meet">
                                <defs>
                                    <linearGradient id="sub-icon1" x1="0%" y1="0%" x2="0%" y2="100%">
                                          <stop offset="0%" style="stop-color:<?php echo esc_attr($secondary_color); ?>;stop-opacity:1" />
                                          <stop offset="100%" style="stop-color:<?php echo esc_attr($primary_color); ?>;stop-opacity:1" />
                                    </linearGradient>
                                  </defs>
                                <g fill="url(#sub-icon1)" transform="translate(0.000000,382.000000) scale(0.100000,-0.100000)" fill="#000000" stroke="none"><path d="M1856 3797 c-20 -20 -23 -36 -29 -142 -50 -901 -761 -1612 -1662 -1662 -106 -6 -122 -9 -142 -29 -30 -30 -30 -78 0 -108 20 -20 36 -23 142 -29 901 -50 1612 -761 1662 -1662 6 -106 9 -122 29 -142 30 -30 78 -30 108 0 20 20 23 36 29 142 50 901 761 1612 1662 1662 106 6 122 9 142 29 30 30 30 78 0 108 -20 20 -36 23 -142 29 -901 50 -1612 761 -1662 1662 -6 106 -9 122 -29 142 -14 14 -35 23 -54 23 -19 0 -40 -9 -54 -23z"/></g>
                            </svg>
                            <svg version="1.0" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 382.000000 382.000000" preserveAspectRatio="xMidYMid meet">
                                <defs>
                                    <linearGradient id="sub-icon2" x1="0%" y1="0%" x2="0%" y2="100%">
                                          <stop offset="0%" style="stop-color:<?php echo esc_attr($secondary_color); ?>;stop-opacity:1" />
                                          <stop offset="100%" style="stop-color:<?php echo esc_attr($primary_color); ?>;stop-opacity:1" />
                                    </linearGradient>
                                  </defs>
                                <g fill="url(#sub-icon2)" transform="translate(0.000000,382.000000) scale(0.100000,-0.100000)" fill="#000000" stroke="none"><path d="M1856 3797 c-20 -20 -23 -36 -29 -142 -50 -901 -761 -1612 -1662 -1662 -106 -6 -122 -9 -142 -29 -30 -30 -30 -78 0 -108 20 -20 36 -23 142 -29 901 -50 1612 -761 1662 -1662 6 -106 9 -122 29 -142 30 -30 78 -30 108 0 20 20 23 36 29 142 50 901 761 1612 1662 1662 106 6 122 9 142 29 30 30 30 78 0 108 -20 20 -36 23 -142 29 -901 50 -1612 761 -1662 1662 -6 106 -9 122 -29 142 -14 14 -35 23 -54 23 -19 0 -40 -9 -54 -23z"/></g>
                            </svg>
                            <svg version="1.0" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 382.000000 382.000000" preserveAspectRatio="xMidYMid meet">
                                <defs>
                                    <linearGradient id="sub-icon3" x1="0%" y1="0%" x2="0%" y2="100%">
                                          <stop offset="0%" style="stop-color:<?php echo esc_attr($secondary_color); ?>;stop-opacity:1" />
                                          <stop offset="100%" style="stop-color:<?php echo esc_attr($primary_color); ?>;stop-opacity:1" />
                                    </linearGradient>
                                  </defs>
                                <g fill="url(#sub-icon3)" transform="translate(0.000000,382.000000) scale(0.100000,-0.100000)" fill="#000000" stroke="none"><path d="M1856 3797 c-20 -20 -23 -36 -29 -142 -50 -901 -761 -1612 -1662 -1662 -106 -6 -122 -9 -142 -29 -30 -30 -30 -78 0 -108 20 -20 36 -23 142 -29 901 -50 1612 -761 1662 -1662 6 -106 9 -122 29 -142 30 -30 78 -30 108 0 20 20 23 36 29 142 50 901 761 1612 1662 1662 106 6 122 9 142 29 30 30 30 78 0 108 -20 20 -36 23 -142 29 -901 50 -1612 761 -1662 1662 -6 106 -9 122 -29 142 -14 14 -35 23 -54 23 -19 0 -40 -9 -54 -23z"/></g>
                            </svg>
                        </div>
                    <?php endif; ?>
                    <?php echo esc_attr($sub_title); ?>
                </div>
            </div>
    	<?php endif; ?>
        <<?php echo esc_attr($title_tag); ?> class="item--title <?php echo esc_attr($settings['theme_custom_font']); ?> <?php echo esc_attr($style); ?> <?php if($ct_animate != 'case-fade-in-up') { echo esc_attr($ct_animate); } else { echo 'case-animate-time'; } ?>" data-wow-delay="<?php echo esc_attr($ct_animate_delay); ?>ms">
            <?php if($ct_animate == 'case-fade-in-up') {
                $arr_str = explode(' ', $title);
                foreach ($arr_str as $index => $value) {
                    $arr_str[$index] = '<span class="slide-in-container"><span class="d-inline-block wow '.$ct_animate.'">' . $value . '</span></span>';
                }
                $str = implode(' ', $arr_str);
                echo wp_kses_post($str);
            } else {
                echo '<span class="ct-text-inner">';
                echo wp_kses_post($editor_title);
                echo '</span>';
            } ?>
        </<?php echo esc_attr($title_tag); ?>>
    </div>
</div>