<?php
$default_settings = [
    'content_list' => '',
    'slidestoshow' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);

$widget->add_render_attribute( 'inner', [
    'class' => 'ct-carousel-inner',
] );

$arrows = $widget->get_setting('arrows');
if (is_rtl()) {
    $carousel_dir = 'true';
} else {
    $carousel_dir = 'false';
}
$widget->add_render_attribute( 'carousel', [
    'class' => 'ct-slick-carousel',
] );

?>
<?php if(isset($content_list) && !empty($content_list) && count($content_list)): ?>
    <div class="ct-history ct-history-carousel1 ct-slick-slider">
        <div <?php ct_print_html($widget->get_render_attribute_string( 'inner' )); ?>>

            <div class="ct-slick-nav" data-nav="<?php if(!empty($slidestoshow)) { echo esc_attr($slidestoshow); } else { echo '4'; } ?>" data-dir="<?php echo esc_attr($carousel_dir); ?>">
                <?php foreach ($content_list as $key => $value_nav) :
                    $year = isset($value_nav['year']) ? $value_nav['year'] : '';
                    ?>
                    <div class="slick-slide">
                        <div class="item--meta">
                            <div class="item--year"><?php echo ct_print_html($year); ?></div>
                       </div>
                    </div>
                <?php endforeach; ?>
            </div>

            <div class="ct-slick-primary">
                <div <?php ct_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                    <?php foreach ($content_list as $key => $value) :
                        $title = isset($value['title']) ? $value['title'] : '';
                        $description = isset($value['description']) ? $value['description'] : '';
                        ?>
                        <div class="slick-slide">
                            <div class="item--holder">
                                <h3 class="item--title">    
                                    <?php echo ct_print_html($title); ?>
                                </h3>
                                <div class="item--description"><?php echo ct_print_html($description); ?></div>
                           </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
            
        </div>
    </div>
<?php endif; ?>
