<?php
$default_settings = [
    'before_image' => '',
    'after_image' => '',
    'selected_icon' => '',
    'title' => '',
    'year' => '',
    'ct_animate' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);

$is_new = \Elementor\Icons_Manager::is_migration_allowed();

$has_icon = ! empty( $selected_icon );
if ( $has_icon ) {
    $widget->add_render_attribute( 'i', 'class', $selected_icon );
    $widget->add_render_attribute( 'i', 'aria-hidden', 'true' );
}

$before_img = ct_get_image_by_size( array(
	'attach_id'  => $before_image['id'],
	'thumb_size' => '284x284',
));
$before_thumbnail = $before_img['thumbnail']; 

$after_img = ct_get_image_by_size( array(
	'attach_id'  => $after_image['id'],
	'thumb_size' => '284x284',
));
$after_thumbnail = $after_img['thumbnail']; ?>

<?php if(!empty($before_image['id']) && !empty($after_image['id'])) : 
	?>
	<div class="ct-image-before-after2">
		<div class="item--holder">
			<div class="item--meta">
				<?php if ( $has_icon ) : ?>
			        <div class="item--icon">
			            <?php if($is_new):
			                \Elementor\Icons_Manager::render_icon( $selected_icon, [ 'aria-hidden' => 'true' ] );
			                else: ?>
			                <i <?php ct_print_html($widget->get_render_attribute_string( 'i' )); ?>></i>
			            <?php endif; ?>
			        </div>
			    <?php endif; ?>
			    <div class="item--title"><?php echo esc_attr($title); ?></div>
			    <div class="item--year"><?php echo esc_attr($year); ?></div>
			</div>
		</div>
		<div class="twentytwenty-container" data-before-text="<?php echo esc_html__('Before', 'bixol'); ?>" data-after-text="<?php echo esc_html__('After', 'bixol'); ?>">
	    	<?php echo wp_kses_post($before_thumbnail); ?>
	    	<?php echo wp_kses_post($after_thumbnail); ?>
	    </div>
	</div>
<?php endif; ?>