<?php 
$default_settings = [
    'image' => '',
    'image_link' => '',
    'img_size' => '',
    'style' => '',
    'ct_animate' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);
$size = '';
if(!empty($img_size)) {
    $size = $img_size;
} else {
    $size = 'full';
}
$widget->add_render_attribute( 'selected_icon', 'class' );
$has_icon = ! empty( $settings['selected_icon'] );
if ( $has_icon ) {
    $widget->add_render_attribute( 'i', 'class', $settings['selected_icon'] );
    $widget->add_render_attribute( 'i', 'aria-hidden', 'true' );
}
$is_new = \Elementor\Icons_Manager::is_migration_allowed(); ?>
<div class="ct-image-box <?php echo esc_attr($style.' '.$ct_animate); ?>">
    <?php if ( ! empty( $image['id'] ) ) { 
        $img  = ct_get_image_by_size( array(
            'attach_id'  => $image['id'],
            'thumb_size' => $size,
        ) );
        $thumbnail    = $img['thumbnail'];
        if ( ! empty( $image_link['url'] ) ) {
            $widget->add_render_attribute( 'image_link', 'href', $image_link['url'] );

            if ( $image_link['is_external'] ) {
                $widget->add_render_attribute( 'image_link', 'target', '_blank' );
            }

            if ( $image_link['nofollow'] ) {
                $widget->add_render_attribute( 'image_link', 'rel', 'nofollow' );
            }
        } ?>
        <div class="ct-item--image">
            <?php echo wp_kses_post($thumbnail); ?>
            <?php if ( ! empty( $image_link['url'] ) ) { ?><a class="ct-item-link" <?php ct_print_html($widget->get_render_attribute_string( 'image_link' )); ?>>
                <svg class="ct-icon--link" width="100" height="100" viewBox="0 0 100 100" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M21.801 15.6989C19.3602 13.2581 15.4029 13.2581 12.9621 15.6989L12.2473 16.4138C9.8065 18.8546 9.8065 22.8119 12.2473 25.2526L36.9945 49.9999L12.2473 74.747C9.80646 77.1878 9.80646 81.1453 12.2473 83.5861L12.9621 84.3007C15.4029 86.7416 19.3602 86.7416 21.801 84.3007L50.9546 55.147L51.6825 54.4195C51.9896 54.1124 52.2567 53.7828 52.485 53.4374C54.0863 51.012 53.8167 47.7145 51.6825 45.5803L21.801 15.6989ZM10.0159 12.7526C14.0838 8.68467 20.6793 8.68467 24.7473 12.7526L54.6288 42.634C58.19 46.1953 58.6321 51.6891 55.9621 55.7332C55.58 56.3116 55.1354 56.8591 54.6288 57.3657L53.9138 58.0803L53.9008 58.0936L24.7473 87.247C20.6793 91.3149 14.0838 91.3149 10.0159 87.247L9.30096 86.5324C5.233 82.4645 5.233 75.8686 9.30096 71.8007L31.1019 49.9999L9.30096 28.1989C5.233 24.131 5.233 17.5355 9.301 13.4675L10.0159 12.7526ZM13.9731 36.0268C13.1595 35.2131 11.8405 35.2131 11.0269 36.0268C10.2132 36.8403 10.2132 38.1594 11.0269 38.973L20.5806 48.5266C21.3942 49.3403 21.3942 50.6595 20.5806 51.4732L11.0269 61.0266C10.2132 61.8403 10.2132 63.1595 11.0269 63.9732C11.8405 64.7865 13.1595 64.7865 13.9731 63.9732L23.5269 54.4195C25.9676 51.9786 25.9676 48.0211 23.5269 45.5803L13.9731 36.0268ZM55.64 36.0268C54.8263 35.2131 53.5071 35.2131 52.6933 36.0268C51.88 36.8403 51.88 38.1594 52.6933 38.973L62.2471 48.5266C63.0608 49.3403 63.0608 50.6595 62.2471 51.4732L52.6933 61.0266C51.88 61.8403 51.88 63.1595 52.6933 63.9732C53.5071 64.7865 54.8263 64.7865 55.64 63.9732L65.1933 54.4195C67.6342 51.9786 67.6342 48.0211 65.1933 45.5803L55.64 36.0268ZM54.6288 15.6989C57.0696 13.2581 61.0267 13.2581 63.4675 15.6989L93.3492 45.5803C95.4833 47.7145 95.7529 51.012 94.1517 53.4374C93.9233 53.7828 93.6562 54.1124 93.3492 54.4195L92.6213 55.147L63.4675 84.3007C61.0267 86.7416 57.0696 86.7416 54.6288 84.3007L53.9138 83.5861C51.4733 81.1453 51.4733 77.1878 53.9138 74.747L78.6613 49.9999L53.9138 25.2526C51.4733 22.8119 51.4733 18.8546 53.9138 16.4138L54.6288 15.6989ZM66.4138 12.7526C62.3458 8.68467 55.7504 8.68467 51.6825 12.7526L50.9675 13.4675C46.8996 17.5355 46.8996 24.131 50.9675 28.1989L72.7688 49.9999L50.9675 71.8007C46.8996 75.8686 46.8996 82.4645 50.9675 86.5324L51.6825 87.247C55.7504 91.3149 62.3458 91.3149 66.4138 87.247L95.5675 58.0936L95.5804 58.0803L96.2954 57.3657C96.8021 56.8591 97.2467 56.3116 97.6288 55.7332C100.299 51.6891 99.8567 46.1953 96.2954 42.634L66.4138 12.7526Z" fill="white"/></svg>
            </a><?php } ?>
            <?php if ( $has_icon ) : ?>
                <div class="ct-item--icon">
                    <?php if($is_new):
                        \Elementor\Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] );
                        else: ?>
                        <i <?php ct_print_html($widget->get_render_attribute_string( 'i' )); ?>></i>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    <?php } ?>
    <div class="ct-item--holder">
        <h5 class="ct-item--title"><?php echo ct_print_html($settings['title_text']); ?></h5>
        <div class="ct-item--description"><?php echo ct_print_html($settings['description_text']); ?></div>
    </div>
</div>