<?php
$secondary_color = bixol_get_opt( 'secondary_color' );
$default_settings = [
    'title' => '',
    'description' => '',
    'percentage_value' => '',
    'bar_color' => '',
    'track_color' => '',
    'chart_size' => '',
    'selected_icon' => '',
    'icon_type' => '',
    'icon_image' => '',
    'ct_animate' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);
$is_new = \Elementor\Icons_Manager::is_migration_allowed();
$has_icon = ! empty( $selected_icon );
if ( $has_icon ) {
    $widget->add_render_attribute( 'i', 'class', $selected_icon );
    $widget->add_render_attribute( 'i', 'aria-hidden', 'true' );
}
?>
<div class="ct-piechart ct-piechart-layout1 <?php echo esc_attr($ct_animate); ?>">
    <div class="item--meta">
        <span class="ct-piechart-counter"><?php echo esc_attr($percentage_value); ?>%</span>
        <div class="item--value percentage" style="min-height: <?php echo esc_attr($chart_size['size']); ?>px;" data-size="<?php echo esc_attr($chart_size['size']); ?>" data-bar-color="<?php if(!empty($bar_color)) { echo esc_attr($bar_color); } else { echo esc_attr($secondary_color); } ?>" data-track-color="<?php if(!empty($track_color)) { echo esc_attr($track_color); } else { echo '#cddae6'; } ?>" data-line-width="10" data-percent="-<?php echo esc_attr($percentage_value); ?>">
            <?php if ( $icon_type == 'icon' && $has_icon ) : ?>
                <div class="item--icon">
                    <?php if($is_new):
                        \Elementor\Icons_Manager::render_icon( $selected_icon, [ 'aria-hidden' => 'true' ] );
                        else: ?>
                        <i <?php ct_print_html($widget->get_render_attribute_string( 'i' )); ?>></i>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <?php if ( $icon_type == 'image' && !empty($icon_image['id']) ) : ?>
                <div class="item--icon">
                    <?php $img_icon  = ct_get_image_by_size( array(
                            'attach_id'  => $icon_image['id'],
                            'thumb_size' => 'full',
                        ) );
                        $thumbnail_icon    = $img_icon['thumbnail'];
                    echo ct_print_html($thumbnail_icon); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <h3 class="item--title ct-title-line"><?php echo ct_print_html($title); ?></h3>
    <div class="item--desc"><?php echo ct_print_html($description); ?></div>
</div>