<?php
$default_settings = [
    'team' => '',
    'thumbnail_size' => 'full',
    'thumbnail_custom_dimension' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);

if($thumbnail_size != 'custom'){
    $img_size = $thumbnail_size;
}
elseif(!empty($thumbnail_custom_dimension['width']) && !empty($thumbnail_custom_dimension['height'])){
    $img_size = $thumbnail_custom_dimension['width'] . 'x' . $thumbnail_custom_dimension['height'];
}
else{
    $img_size = '270x352';
}

$widget->add_render_attribute( 'inner', [
    'class' => 'ct-carousel-inner',
] );

$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$arrows = $widget->get_setting('arrows');
$dots = $widget->get_setting('dots');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay', '');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');
if (is_rtl()) {
    $carousel_dir = 'true';
} else {
    $carousel_dir = 'false';
}
$widget->add_render_attribute( 'carousel', [
    'class' => 'ct-slick-carousel slick-shadow',
    'data-arrows' => $arrows,
    'data-dots' => $dots,
    'data-pauseOnHover' => $pause_on_hover,
    'data-autoplay' => $autoplay,
    'data-autoplaySpeed' => $autoplay_speed,
    'data-infinite' => $infinite,
    'data-speed' => $speed,
    'data-colxs' => $col_xs,
    'data-colsm' => $col_sm,
    'data-colmd' => $col_md,
    'data-collg' => $col_lg,
    'data-colxl' => $col_xl,
    'data-dir' => $carousel_dir,
    'data-slidesToScroll' => $slides_to_scroll,
] );
$primary_color = bixol_get_opt( 'primary_color', '#22d3ee' );
$secondary_color = bixol_get_opt( 'secondary_color', '#000000' );
?>
<?php if(isset($team) && !empty($team) && count($team)): ?>
    <div class="ct-team ct-team-carousel3 ct-slick-slider <?php echo esc_attr($settings['ct_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['ct_animate_delay']); ?>ms">
        <div <?php ct_print_html($widget->get_render_attribute_string( 'inner' )); ?>>
            <div <?php ct_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <?php foreach ($team as $key => $value) :
                    $title = isset($value['title']) ? $value['title'] : '';
                    $position = isset($value['position']) ? $value['position'] : '';
                    $desc = isset($value['desc']) ? $value['desc'] : '';
                    $image = isset($value['image']) ? $value['image'] : '';
                    $img = ct_get_image_by_size( array(
                        'attach_id'  => $image['id'],
                        'thumb_size' => $img_size,
                    ));
                    $thumbnail = $img['thumbnail'];
                    $social = isset($value['social']) ? $value['social'] : '';
                    ?>
                    <div class="slick-slide">
                        <div class="item--inner">
                            <?php if(!empty($image)) { ?>
                                <div class="item--image">
                                    <?php echo wp_kses_post($thumbnail); ?>
                                </div>
                            <?php } ?>
                            <div class="item--holder">
                                <h3 class="item--title">    
                                    <?php echo ct_print_html($title); ?>
                                </h3>
                                <div class="item--position"><?php echo ct_print_html($position); ?></div>
                            </div>
                            <div class="item--social">
                                <?php if(!empty($social)):
                                    $team_social = json_decode($social, true); ?>
                                    <span class="item--social-btn"><i class="flaticonv2-plus"></i></span>
                                    <div class="item--social-link">
                                        <?php foreach ($team_social as $value): ?>
                                            <a href="<?php echo esc_url($value['url']); ?>"><i class="<?php echo esc_attr($value['icon']); ?>"></i></a>
                                        <?php endforeach; ?>
                                        </div>
                                <?php endif; ?>
                            </div>
                            <div class="item--shape">
                                <svg class="item--shape-white" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="270" height="160" viewBox="0 0 270 160">
                                  <path d="M38.6,34.81A4.906,4.906,0,0,0,34.248,33.3a8.767,8.767,0,0,0-5.479-2.66,4.266,4.266,0,0,1-1.63-.547,10.274,10.274,0,0,0-4.347-1.234,23.257,23.257,0,0,1-6.71-1.723,2.309,2.309,0,0,0-.536-0.208c-2.567-.466-4.911-1.617-7.479-2.131A33.221,33.221,0,0,1,2.78,23.293,21.082,21.082,0,0,0-2.5,22a23.9,23.9,0,0,1-8.98-2.773,10.474,10.474,0,0,0-2.154-.81,8.316,8.316,0,0,1-2.53-1.3l0.643-1.029c1.805-.412,3.84.867,5.641,0.029a1.986,1.986,0,0,0-.571-0.717,7,7,0,0,0-2.142-.677,26.126,26.126,0,0,1-4.875-1.173c-0.133-.669.437-0.784,0.83-0.68,2.3,0.612,4.663.53,6.983,1.561a59.777,59.777,0,0,0,7.437,2.349,62.166,62.166,0,0,0,6.965,1.963,4.72,4.72,0,0,1,1.073.526A13.406,13.406,0,0,1-1.3,17.7l-1.9.192a2.621,2.621,0,0,0-.136,1.073,1.623,1.623,0,0,0,.727.911,5.093,5.093,0,0,0,2.761.616,3.553,3.553,0,0,1,2.177.526,4.911,4.911,0,0,0,2.736.694,15.5,15.5,0,0,1,4.808.79c1.913,0.55,2.137.438,2.838-.94a2.489,2.489,0,0,1,.283-0.357c1.2,0.215,2.429.377,3.626,0.681a6.744,6.744,0,0,1,1.574,1.019c-0.665.126-1.053,0.226-1.462,0.273-0.792.089-.789,0.088-0.505,1.107,0.915,0.044,1.845.032,2.774,0.148,0.9,0.113,1.514,1.127,2.778.758l-0.64-2.254-0.014.056a3.087,3.087,0,0,0,1.671-.548,3.094,3.094,0,0,1,2.668-.007,10.391,10.391,0,0,1,2.561,1.188c1.618,1.266,2.513,1.31,4.24.373a0.852,0.852,0,0,1,.969-0.052,3,3,0,0,0,1.9.453,3.68,3.68,0,0,1,2.649.837,8.82,8.82,0,0,0,3.9,1.619c2.079,0.411,4.131,1,6.208,1.437,1.11,0.231,2.263.207,3.371,0.445a15.812,15.812,0,0,1,3.006.978,51.161,51.161,0,0,0,5,1.369,4.926,4.926,0,0,0,1.4.2A14.066,14.066,0,0,1,67.087,32.4a1.871,1.871,0,0,0,.835.2c1.936-.089,3.758.8,5.667,1.011s3.809,0.54,5.71.861c1.033,0.174,2.067.406,3.087,0.664,1.778,0.452,3.544.954,5.321,1.414a5.386,5.386,0,0,0,1.7.308c2.664-.284,5.23.627,7.851,1.122a22.934,22.934,0,0,1,6.106,1.588c2.178-.018,4.307.73,6.47,1.011,2.854,0.371,5.711.819,8.556,1.327a25.544,25.544,0,0,1,4.188,1.109,18.563,18.563,0,0,0,2.487.683c1.281,0.275,2.613.274,3.784,1.151a8.176,8.176,0,0,0,2.452.7l0.06,0.142-0.127-.142c1.089,0.13,1.944-.343,2.927-0.347s2.081,0.482,3.1.538c2.285,0.123,4.531.73,6.8,0.984a48.358,48.358,0,0,1,7.327,1.559l1.845-1.1c0.376,0.628.476,1.252,1.4,1.41a3.736,3.736,0,0,0,1.338.085,9.565,9.565,0,0,0,1.571-.644l4.31,1.165,0.5,1.041c0.659-.09,1.262-0.137,1.825-0.255a7.274,7.274,0,0,1,5.167.821l-0.366.913c0.011,0.059.021,0.117,0.032,0.175l-0.142-.177c0.132-.3.263-0.6,0.4-0.905,0.158-.231.315-0.462,0.516-0.755,1.624,0.307,3.219.576,4.8,0.914a52,52,0,0,0,7.341,1.041c2.185,0.148,4.275.878,6.447,1.036,1.589,0.116,3.2.552,4.805,0.773a40.331,40.331,0,0,0,4.5.444,20.958,20.958,0,0,1,4.539.774,10.14,10.14,0,0,0,4.493.535,0.959,0.959,0,0,1,.555.025,4.487,4.487,0,0,0,3.514.121,2.974,2.974,0,0,1,2.409.407,5.19,5.19,0,0,0,3.224.932,5.992,5.992,0,0,1,1.392.321,21.99,21.99,0,0,0,3.666.793c3.982,0.182,7.971,1.324,11.946,1.316a7.809,7.809,0,0,1,2.233.485,26.051,26.051,0,0,0,5.94,1.148c2.351,0.183,4.731.77,7.055,0.551a2.3,2.3,0,0,1,.845.167c2.65,0.884,5.21.715,7.761,0.619,0.215-.357-0.119-0.581-0.455-0.733-1.213-.547-2.445-1.064-3.67-1.592l0.014,0.059a1.086,1.086,0,0,1,.415-0.621c0.754-.128,1.611.385,2.412,0.085A14.6,14.6,0,0,1,258,59.228c0.008-.254.017-0.521,0.026-0.788l0.009,0.075c0.818,0.265,1.646.506,2.45,0.8,0.86,0.316,1.7.68,2.617,1.053a1,1,0,0,1-.407.454c-0.517.1-1.09,0.1-1.63,0.157a2.512,2.512,0,0,0-1.945.826,1.254,1.254,0,0,0,.387.366,10.311,10.311,0,0,1,3.733,1.361,2.772,2.772,0,0,0,1.6.374,8.466,8.466,0,0,1,3.926.445,2.272,2.272,0,0,0,2.331-.32c-0.574-1.1-2.1-1.535-3.409-2.434,1.416-.232,2.388-0.681,3.874-0.321a15.086,15.086,0,0,0,3.389.143c0.493,0,.982-0.174.876-0.577a1.623,1.623,0,0,0-.8-0.868,10.976,10.976,0,0,0-1.922-.59c-0.819-.212-1.647-0.393-2.566-0.61,0.18-.269.293-0.44,0.436-0.652a14.737,14.737,0,0,1,2.168.649c1.75,0.834,3.51.45,5.258,0.711a5.98,5.98,0,0,0,2.244-.561l-0.022-.055a4.006,4.006,0,0,0,1.8,1.83l-0.008-.068a2.808,2.808,0,0,1-.926.264c-0.933-.051-1.888-0.245-2.812-0.261a5.4,5.4,0,0,0-1.439.346,1.873,1.873,0,0,0,1.85,1.378c1.136,0.192,2.276.327,3.412,0.519a14.189,14.189,0,0,1,3.819,1.092c0.054,0.546-.441.384-0.77,0.319A24.513,24.513,0,0,0,278.164,64c0.106,0.393.2,0.726,0.249,0.924a26.321,26.321,0,0,0,5.54,1.629,100.151,100.151,0,0,0,9.963,1.459,3.228,3.228,0,0,1,1.345.292c1.441,1.1,2.85.8,4.276,0.57a4.347,4.347,0,0,0,.734-0.235,5.54,5.54,0,0,1,3.044.1c1.126,0.258,1.808-.094,2.089-0.911l8.2,0.337c0.22-.5-0.132-0.828-0.753-1.032a6.566,6.566,0,0,0-1.406-.352,5.273,5.273,0,0,1-2.8-1.257l0.02,0.076a7.128,7.128,0,0,1,1.8-.238c2.184,0.254,4.37.6,6.553,0.924a10.316,10.316,0,0,1,1.069.272c0.346,0.945-1.014.823-1.317,1.515,0.217,0.488.493,1.1,0.731,1.638a11.8,11.8,0,0,0,4.282,1.023c0.13,0.139.337,0.381,0.57,0.61a1.593,1.593,0,0,0,1.764.475c1.325-.593,2.764-0.107,4.084.292,2.6,0.789,5.284.874,7.883,1.576a0.609,0.609,0,0,0,.283.024c2.164-.624,4.637,0,6.922-0.129,0.778-.043.945-0.175,1.556-1.166a19.8,19.8,0,0,0-4.125-.937,8.554,8.554,0,0,1-4.386-1.064,5.29,5.29,0,0,0-1.928-.486c-1.327-.162-2.655-0.243-3.983-0.363-0.962-.088-0.962-0.093-2.132-1.206a5,5,0,0,1,1.363-.123c1.7,0.335,3.389.538,5.088,0.7a6.144,6.144,0,0,1,1.415.259,8.236,8.236,0,0,0,4.957.48,4.763,4.763,0,0,1,2.5.41,10.845,10.845,0,0,0,1.916.529,7.771,7.771,0,0,1,3.674,1.394c0.358,0.84-.773,1.118-0.96,1.9,0.665,0.619,1.358,1.346,2.168,1.993,0.738,0.59,1.6,1.092,2.412,1.632-0.107.615-.854,0.6-1.421,0.737a0.8,0.8,0,0,0-.756.717c-0.032.593,0.6,0.694,1.128,0.888a1.511,1.511,0,0,1,.278.23l-2.4.829a1.462,1.462,0,0,0,1.461,1.129,7.8,7.8,0,0,1,3.36,1.459c0.812,0.473.831,1.184-.082,1.281-1.066.113-1.072,0.551-.946,1.144a10.518,10.518,0,0,0,.408,1.212c-0.961,1.305-2.786.762-4.4,0.8l-0.54.858-0.02-.068c0.485,0.394.952,0.8,1.465,1.174a4.433,4.433,0,0,0,.836.353c0.248,0.9.5,1.807,0.738,2.678,1.935,0.549,1.935.549,2.6-.3,0.867,0.066,1.809.121,2.752,0.214a4.077,4.077,0,0,1,2.792,1.058,5.883,5.883,0,0,0,2.048.942c1.153,0.408,2.336.752,3.593,1.15a9.325,9.325,0,0,1,.79,1.635c0.313,1.2.262,1.2,1.42,1.518a22.371,22.371,0,0,1,5.719,1.9c0.2,0.119.36,0.279,0.91,0.713-1.368-.309-2.263-0.549-3.167-0.707a9.964,9.964,0,0,0-4.191-.227c-0.723.189-1.3,0.707-.95,1.248,0.51,0.791.238,1.728,1.3,2.4a0.38,0.38,0,0,1,.166.189,3.566,3.566,0,0,0,2.539,2.617,11.658,11.658,0,0,0,3.858,1.1,5.746,5.746,0,0,1,3.043.972c0.158,1-.12,2.026.628,3.11,0.24,0.347-.223.9-0.4,1.457,1.26,0.784,1.182,1.92,1.725,2.929a1.462,1.462,0,0,0,1.249.964c0.519-.6-0.457-1.546.288-2.1,0.676-.507,1.336-1.026,2.1-1.617,1.521,0.607,3.287.466,4.856,1.31a3.382,3.382,0,0,1,1.327.879,6.9,6.9,0,0,0,2.628,1.9,2.816,2.816,0,0,0,1.919.358,7.639,7.639,0,0,1,4.665.614,7.184,7.184,0,0,0,5.253.459c1.86,0.792,3.523,1.51,5.2,2.209a3.137,3.137,0,0,0,2.192.283,9.944,9.944,0,0,1,4.686.026l-0.014-.047-2.057.877c-0.482,1.469-.482,1.469-2.92,1.977-1.338-.909-2.986-0.752-4.562-0.914a8.525,8.525,0,0,1-3.294-.842c-1.367-.736-2.858-0.641-4.3-0.805a0.82,0.82,0,0,0-1.017.945c0.224,0.554.562,1.095,0.823,1.592a0.642,0.642,0,0,1-.977.088c-0.765-.7-1.468-1.443-2.227-2.2a29.57,29.57,0,0,1-2.938-.738c-1.31-.464-2.227-0.414-2.82.471a2.35,2.35,0,0,1-.673.407c-0.8-.193-1.637-0.366-2.457-0.6-0.731-.212-1.438-0.5-2.246-0.782l-3.273.868c0.347,1.525,2.191,2.347,3.171,3.521,1.049,1.258,2.685,1.828,4.255,2.5l-0.022.113-0.072-.114a4.206,4.206,0,0,1,2.462.077V128.5c-0.369.352-.766,0.689-1.1,1.062a1.153,1.153,0,0,0,.363,1.557,2.673,2.673,0,0,0,1.313.357,1.083,1.083,0,0,0,1.1-1.17,5.777,5.777,0,0,0-.733-1.187l0.025,0.114,2.5-1.275a4.081,4.081,0,0,1,2.179,1.587,7.263,7.263,0,0,0,5,3.336,1.785,1.785,0,0,1,1.663,1.373l-0.017-.091c-1.512.115-2.835,0.433-3.526,1.483a1.7,1.7,0,0,1-.573.342c-0.735-.087-1.424-0.164-1.528-0.866-0.152-1.024-.827-1.628-2.451-1.653l-0.732,1.668c-0.555.244-1.159,0.507-1.755,0.779a0.383,0.383,0,0,0-.117.173,6.109,6.109,0,0,0,2.933,1.607c1.12,0.051,2.226.008,3.523,0,0.351,0.234.819,0.527,1.255,0.843,0.755,0.548,1.442,1.1,2.53.682a2.631,2.631,0,0,1,1.339.326,13.112,13.112,0,0,1,1.476.825,13.3,13.3,0,0,0,6.385,2.16,38.714,38.714,0,0,1,4.238.729c4.176,0.662,8.358,1.272,12.5,2.212a13.165,13.165,0,0,1,2.5.737,24.286,24.286,0,0,0,4.686,1.382,16.166,16.166,0,0,1,3.237,1.094,16.141,16.141,0,0,0,2.954,1.1c0.923,0.238,1.814.6,2.718,0.906a5.673,5.673,0,0,0,.807.292c0.839,0.145,1.817,0,2.452.621,1.1,1.079,2.757,1.882,3.287,3.347l-0.923,1.058a1.813,1.813,0,0,1-.562-0.051,5.357,5.357,0,0,1-2.071-1.589,11.335,11.335,0,0,0-4.158-2.929,15.551,15.551,0,0,0-7.815-1.579l-0.6.683c-1.335-.424-2.809-0.273-4.146-0.989a2.63,2.63,0,0,0-1.071-.1,12.858,12.858,0,0,1-5.464-1.289,2.622,2.622,0,0,0-1.041-.313,18.73,18.73,0,0,1-5.37-.718,46.242,46.242,0,0,0-8.246-1.148,36.8,36.8,0,0,1-5.343-.866c-1.853-.436-3.59-1.357-5.525-1.414-0.96-.909-2.31-0.759-3.473-1.028a23.045,23.045,0,0,0-7.6.19c-0.665.141-.553,0.7-0.928,0.839-1.954.735-2.23,2.476-3.633,3.536-0.511.387,0.034,1.169,0.875,1.358,0.751,0.167,1.518.259,2.4,0.4,0.043,0.425.074,0.829,0.127,1.234,0.055,0.423.132,0.847,0.187,1.195-0.582.8-1.851,0.589-2.748,1.037-0.016.807,0.94,1.194,1.672,1.679l-0.018-.088c-0.808.536-2.055-.213-3,0.255-0.394.832,1.366,1.883,0.243,2.8-0.92-.866-2.058-0.631-3.137-0.682a1.051,1.051,0,0,0-1.318.994,6.546,6.546,0,0,0,.276,1.208c-0.5.525-1,.975-1.4,1.481a1.016,1.016,0,0,0,.839,1.436c1.206,0.334,2.425.651,3.65,0.893,1.615,0.318,2.114.186,3.8-.777,1.253,1.327,3.088.952,4.689,1.374h-0.1c0.689,0.283,1.392.547,2.057,0.865a0.918,0.918,0,0,1,.262.466,0.9,0.9,0,0,1-.278.172c-0.522-.195-1.037-0.406-1.693-0.667a12.366,12.366,0,0,0-1.212.577c-0.467.282-.87,0.62-1.308,0.928a4.445,4.445,0,0,1-4.445.585,1.337,1.337,0,0,0,.385-1.861,0.962,0.962,0,0,0-1.15-.314,1.263,1.263,0,0,0-.457.828c-0.038.657,0.791,0.952,1.36,1.347a11.855,11.855,0,0,1-1.14.432c-0.5.137-1.064,0.175-1.535,0.341-0.776.274-.729,0.89,0.033,1.365a4.4,4.4,0,0,0,3.22.793c0.525-.1,1.053-0.187,1.666-0.3,0.905,0.8,1.923,1.574,3.412,1.114,1.193,0.291,2.4.538,3.575,0.885a10.048,10.048,0,0,0,3.659.371,51.156,51.156,0,0,1,6.814.387c1.03,0.069,2.067.158,3.1,0.205,2.816,0.129,5.64.324,8.46,0.48a5.574,5.574,0,0,0,1.668-.018,3.2,3.2,0,0,1,2.193.194,12.565,12.565,0,0,0,5.352.729,36.849,36.849,0,0,1,4.915.4l2.591,2.306c-0.322,1.209-1.159,1.949-3.1,1.882a20.157,20.157,0,0,1-3.4-.242,57.507,57.507,0,0,0-12.781-.819,37.686,37.686,0,0,1-5.88-.153,37.784,37.784,0,0,0-4.231-.067,15.54,15.54,0,0,1-2.552-.125,61.922,61.922,0,0,0-11.082-.745,12.854,12.854,0,0,1-3.627-.432c-1.775-.5-3.606-0.565-4.883.422,0.018,0.89,1.228.712,1.64,1.2l-0.764,1.093c0.79,0.46,1.521.851,2.2,1.292a2.886,2.886,0,0,0,3.14.283,3.628,3.628,0,0,1,3.151-.176,27.944,27.944,0,0,0,4.818.875,50.912,50.912,0,0,1,5.923,1.126,8.005,8.005,0,0,0,1.9.332c1.22,0.026,2.474.24,3.7,0.29,1.419,0.057,2.829.046,4.232,0.02a29.134,29.134,0,0,1,7.594.76,5.928,5.928,0,0,0,1.133.2c3.773,0.161,7.6.926,11.355,0.771a6.474,6.474,0,0,1,3.8.965,11.974,11.974,0,0,0,3.3.823c0.329,0.635-.829.484-0.958,0.946a4.411,4.411,0,0,1-.775,1.122l-9.556-.207a4.185,4.185,0,0,0-1.377-.008,4.377,4.377,0,0,1-2.457-.036,8.508,8.508,0,0,0-3.888,0,4.05,4.05,0,0,1-2.5-.13,5.3,5.3,0,0,0-1.944-.3c-1.57.115-3.2-.819-4.758-0.312-1.361.442-2.98,0.051-4.489-.047-1.322-.087-2.665-0.385-3.991-0.494-1.615-.133-3.234-0.219-4.828-0.223a2.531,2.531,0,0,1-2.045-.655,2.8,2.8,0,0,0-2.033-.791c-2.468-.226-4.939-0.489-7.408-0.717-0.953-.088-1.9-0.077-2.855-0.187a7.209,7.209,0,0,0-4.681.644,10.138,10.138,0,0,1-1.5.35,3.631,3.631,0,0,0-.852.579,2.311,2.311,0,0,0,.426.5c1.172,0.669,2.6.789,3.8,1.3a10.817,10.817,0,0,0,3.876.948,2.028,2.028,0,0,1,.846.115c1.369,0.852,2.755.521,4.024,0.524a3.028,3.028,0,0,1,.609.323,11.918,11.918,0,0,0,4.927,2.9,12.492,12.492,0,0,0,3.568.843c1.02,0.036,2.065.24,3.078,0.366,1.053-.306.887-1.249,1.484-1.911,3.143,0.753,6.192.147,9.345,0.9a5.435,5.435,0,0,0,1.7.047,9.168,9.168,0,0,1,2.817.208,12.4,12.4,0,0,0,3.957.152c1.134-.113,1.582.07,3.241,1.018a8.847,8.847,0,0,1-1.146.088c-1.805-.1-3.613-0.236-5.417-0.339a7.68,7.68,0,0,0-2.242-.018,8.362,8.362,0,0,1-4.441-.126,1.564,1.564,0,0,0-.828-0.021,2.011,2.011,0,0,0-.918.61c-0.185.283,0.485,0.81,1.093,0.934a2.255,2.255,0,0,0,.567.092,11.866,11.866,0,0,1,4.194.774l0.02,0.116-0.084-.128,2.2,0.377-0.057.135-0.014-.139a4.643,4.643,0,0,1,1.283-.049,7.015,7.015,0,0,0,2.707.11l0.073,0.115,0.031-.114a11.623,11.623,0,0,1,4.434.257c2.336,0.876,4.632.7,6.938,1.055l-0.032-.029a5.787,5.787,0,0,1-4.165.979,9.181,9.181,0,0,0-2.754.162,4.4,4.4,0,0,1-2.765-.268,9.887,9.887,0,0,0-3.627-.739,15.54,15.54,0,0,1-5.321-.878,0.688,0.688,0,0,0-.281-0.056c-2.389.083-4.926-.216-7,0.667a1.162,1.162,0,0,0-.37.509l-0.111-.04,0.1-.009a0.8,0.8,0,0,1-.121.569c-1.5.545-1.087,1.629-.557,2.54a2.9,2.9,0,0,0,3.089,1.326,7.054,7.054,0,0,0,4.714,2.636c-0.425.4-.728,0.665-1,0.948-0.642.665-.588,0.813,0.59,1.786l-0.007-.08c-0.97.534-1.717,1.132-.948,2.268,0.381,0.562-.344.883-0.35,1.352a1.248,1.248,0,0,0,.418.98,2,2,0,0,0,1.307.251,13.114,13.114,0,0,0,1.954-.83,2.127,2.127,0,0,1,1.488,1.664,2.332,2.332,0,0,1-2.522.791,8.323,8.323,0,0,0-1.991-.133c-1.338.062-1.816,0.675-1.458,1.712a4.1,4.1,0,0,1,.361,1.255,1.165,1.165,0,0,1-.5.878,3.282,3.282,0,0,1-1.186.077c-0.17.47-.355,0.979-0.541,1.492a2.744,2.744,0,0,1-.773.195,4.9,4.9,0,0,1-1.695-.191,7.2,7.2,0,0,0-3.352-.349l0.064,0.015a3.6,3.6,0,0,0-.5-0.19,1.169,1.169,0,0,0-.359.03,1.021,1.021,0,0,0,.117.184c0.113,0.116.242,0.224,0.364,0.336l-0.033-.04c-0.671.432-.426,0.966,0.066,1.573,1.317,0.554,2.964-.482,4.215.9-0.3.4-.949,0.154-1.416,0.2a6.914,6.914,0,0,1-1.382-.11c-1.515-.159-3.03-0.306-4.545-0.49-1.6-.193-3.038-0.13-3.981.912a19.844,19.844,0,0,0-5.978-.967,4.424,4.424,0,0,0-3.462.848,0.79,0.79,0,0,0-.169.742,1.093,1.093,0,0,0,1.006.735c0.638,0.064,1.274.115,2.022,0.182,0.084,0.6.15,1.079,0.238,1.712a10.18,10.18,0,0,1-1.748.278c-1.565,0-1.827-.259-1.925-1.594a3.169,3.169,0,0,0-.288-0.711c-0.929.2-1.777,0.364-2.609,0.557a3,3,0,0,1-.967.3c-1.621-.268-2.248.618-3.173,1.173a1.1,1.1,0,0,0,1.024,1.193,3.286,3.286,0,0,0,.831.24c2.154-.017,4.388.834,6.51,0.458a1.622,1.622,0,0,1,.535.149l-0.008-.068a2.656,2.656,0,0,1-2.054,1.423c-0.785-.2-1.615-0.452-2.457-0.615a5.328,5.328,0,0,0-3,.107,2.678,2.678,0,0,1-1.235.34c-2.684-.366-5.111.381-7.807,0.034-0.756.5-1.48,1.052-1.3,2.009,0.964,1.034,2.186.884,3.386,0.823l0.115,0.13,0.062-.129,4.425,2.035c-0.653.372-1.147,0.615-1.577,0.909s-0.315.791,0.193,1.127c1.343,0.889,3.637,1.393,4.534-.134,0.386-.657,1-0.8,2.1-0.717-0.344.434-.627,0.789-0.976,1.228l2.39,2.2a3.415,3.415,0,0,1-.927.367,11.038,11.038,0,0,1-2.5.07,2.7,2.7,0,0,0-1.459.362c-0.671.187-.507,0.583-0.371,1.039a0.907,0.907,0,0,1-.324.745,2.258,2.258,0,0,0-.244,2.305,19.441,19.441,0,0,0,3.4,1.08c1.125,0.16,2.254.238,3.346,0.35,1.134,0.975.459,1.588-.263,2.329l-3.631-1.473a3.543,3.543,0,0,1-.739.886,2.2,2.2,0,0,1-1.171.32,6.548,6.548,0,0,1-1.382-.394c-1.511-.44-1.549-0.431-3.055.563,0.531,1.338,2.457.755,3.407,1.66-0.148.938-1.695,0.84-2.038,1.759-0.769-.374-1.331-0.657-1.9-0.924-1.471-.685-2.969-0.32-3.244.8a1.61,1.61,0,0,0-.055.831,4.5,4.5,0,0,1-.409,2.9,6.738,6.738,0,0,0,1.593.6,12.764,12.764,0,0,0,3.1.013,13.368,13.368,0,0,1,7.046.572c1.316-.1,1.343-0.925,1.912-1.549l2.193-.085a3.048,3.048,0,0,1,.425.195c3.6,2.9,2.8,1.976,6.856,2.471,1.014-.407,2.023.438,3.029,0.377a18.952,18.952,0,0,1,3.042-.2,18.6,18.6,0,0,1,5.443.862c-0.216,1.343.937,2.724,0.723,4.243-2.44.271-4.909,0.634-7.524-.68a3.486,3.486,0,0,0-2.211-.323,7.926,7.926,0,0,0-1.088.124c-2.716.918-5.757,0.633-8.812,0.29-0.555-.062-1.112-0.211-1.667-0.319l-2.716-.526c-2.873,1.972-6.483,1.383-10.429.833a9.156,9.156,0,0,1-1.344.836,12.1,12.1,0,0,1-1.786.478c0.075,0.448.146,0.872,0.192,1.142l2.33,1.556a9,9,0,0,1-3.188.468q-1.54,0-3.088-.021c-0.512-.009-0.515-0.02-1.754-0.887l0.6-1.175a2.724,2.724,0,0,0-2.447-.7,3.176,3.176,0,0,1-2.408-.4,3.252,3.252,0,0,0-2.472-.333c-0.764.164-1.477,0.418-2.267,0.648a3.32,3.32,0,0,0,2.6,1.5,14.444,14.444,0,0,0,1.7.064,2.393,2.393,0,0,1,2.035.768,3.587,3.587,0,0,0,2.959,1.348c1.8,1.259,3.215,2.892,6.062,3.771-1.849.325-3.21-.381-4.558-0.488s-2.672-1.2-4.211-.527A4.291,4.291,0,0,0,361,269.72c1.554,0.288,2.688.818,2.709,2.024a2.071,2.071,0,0,1-1.9,2.349,3.813,3.813,0,0,0-.493.153c0.546,1.633.412,2.062-.969,2.836-0.558.312-1.174,0.57-1.746,0.869a13.188,13.188,0,0,0-1.241.726,3.289,3.289,0,0,0-.518.583c0.418,0.387.821,0.8,1.289,1.177,0.415,0.331.9,0.614,1.371,0.927-0.023.6-.554,0.78-1.263,0.753-0.854-.034-1.734-0.189-2.567-0.163a15.594,15.594,0,0,0-2.16.354,7.358,7.358,0,0,1-.983-0.558,3.8,3.8,0,0,0-3.431-.787,7.013,7.013,0,0,1-3.048-.074c-1.518-.282-3.055-0.405-4.583-0.617a13.676,13.676,0,0,1-1.354-.369c1.524-.609,2.874.018,4.311,0.095,0.087-.285.179-0.583,0.272-0.884a7.206,7.206,0,0,0-3.043-1.018c-1.616-.3-3.226-0.658-4.843-0.945-0.849-.151-1.709-0.2-2.563-0.3-1.238-.143-2.479-0.245-3.71-0.458a3.792,3.792,0,0,1-1.111-.715,2.676,2.676,0,0,1,2.717-.2,9.052,9.052,0,0,0,3.641.428c1.392,0.016,2.813.171,4.278,0.271,0.65-.337.475-0.931,0.343-1.5a1.244,1.244,0,0,0-1.412-.952c-1.537.167-3.241-.325-4.7,0.174a2.922,2.922,0,0,1-1.639.052,25.849,25.849,0,0,0-4.261-.578c-4.182-.64-8.356-1.1-12.533-1.459-2.19-.191-4.383-0.41-6.574-0.62a3.053,3.053,0,0,0-1.824.256,7.332,7.332,0,0,1-1.8.346c-0.512.1-1.008,0.231-1.557,0.359a4.166,4.166,0,0,1,.537,1.228,3.657,3.657,0,0,1-.4,1.229l3.033,1.342c-3.759.3-7.395-.284-11.043-0.254-0.3-.435-0.6-0.817-0.83-1.214a1.644,1.644,0,0,0-1.6-.82c-1.686.019-3.373,0.032-5.067,0.016a18.84,18.84,0,0,1-2.278-.154,74.923,74.923,0,0,1-8.292-1.225,3.936,3.936,0,0,0-.856-0.138c-3.45-.061-6.8-1.214-10.2-1.768a0.879,0.879,0,0,1-.175-0.27,15.825,15.825,0,0,1,6.354.3,7.876,7.876,0,0,0,2.544.33,4.2,4.2,0,0,1,1.363.283,7.372,7.372,0,0,0,1.9.583,22.674,22.674,0,0,1,5.387.73,1.357,1.357,0,0,0,.808-0.012c0.977-.854,2.667-0.653,3.884-1.136a0.6,0.6,0,0,0,.119-0.283c-1.34-.6-2.672-1.291-4.086-1.806a6.835,6.835,0,0,0-3.891-.126l0.033-.068L281.4,269.1a3.016,3.016,0,0,1-2.373-.63,5.541,5.541,0,0,0-2.868-1.056c-3.913-.765-7.78-0.612-11.68-1.187a14.667,14.667,0,0,1-3.644-.811,20.357,20.357,0,0,0-5.358-.975,18.485,18.485,0,0,1-4.184-.944,8.3,8.3,0,0,0-3.371-.612,2.747,2.747,0,0,1-2.072-.348,4.038,4.038,0,0,1-2.215-.169c-0.745-.124-1.5-0.245-2.231-0.426a1.556,1.556,0,0,0-1.477.146,4.075,4.075,0,0,1-1.572-.188l0,0.057L237.8,261.6h0.055q-0.2.188-.395,0.372l-0.048-.077-1.98-.281,0.051-.124-0.018.143c-0.448.048-.889,0.124-1.346,0.136a1.132,1.132,0,0,1-1.153-.567,0.888,0.888,0,0,0-.838-0.543c-2.639-.11-5.252-0.957-7.916-1.058a10.081,10.081,0,0,1-3.289-.883,16.521,16.521,0,0,0-4.173-.888c-3.146-.4-6.294-0.7-9.44-1.047a14.611,14.611,0,0,1-2.847-.4,31.929,31.929,0,0,0-5.974-.96c-1.613-.209-3.224-0.461-4.836-0.7-5.807-.855-11.615-1.687-17.42-2.58-2.087-.321-4.169-0.768-6.248-1.2a44.887,44.887,0,0,0-5.133-.792,32.214,32.214,0,0,1-4.223-.931c-0.743-.933-2.161-1.026-3.162-1.641a2.68,2.68,0,0,0-.75-0.392,46.979,46.979,0,0,1-5.79-1.681,31.781,31.781,0,0,0-5.665-1.047c-1.9-.3-3.823-0.431-5.693-0.855a25.577,25.577,0,0,0-3.4-.511c-1.043-.1-2.09-0.244-3.135-0.378a2,2,0,0,1-.831-0.172c-1.357-1.106-3.042-.937-4.609-1.246-2.177-.43-4.343-0.945-6.522-1.352-1.414-.263-2.843-0.389-4.265-0.59a5.945,5.945,0,0,1-1.685-.318,19.077,19.077,0,0,0-6.423-1.522,51.24,51.24,0,0,1-7.281-1.7,16.1,16.1,0,0,0-4.243-.526,13.284,13.284,0,0,1-4.2-.428c-2.393-.824-4.736-0.784-7.1-1.069a20.654,20.654,0,0,1-2.81-.538c-1.865-.486-3.783-0.783-5.684-1.117-1.7-.3-3.407-0.544-5.088-0.808-0.376.951-.376,0.951,0.925,1.367l-0.09.01a51.247,51.247,0,0,0,9.784,2.46,4.789,4.789,0,0,1,1.4.327c1.938,0.959,4.079,1.079,6.122,1.59a3.165,3.165,0,0,1,.566.062c1.862,0.959,3.9.959,5.875,1.329a4.725,4.725,0,0,1,1.082.614,5.492,5.492,0,0,1-3.432.139,22.235,22.235,0,0,1-2.212-.661,6.712,6.712,0,0,0-1.073-.385,14.454,14.454,0,0,1-3.033-.319,22.686,22.686,0,0,0-2.978-1.038c-2.546-.546-5.1-1.07-7.646-1.6a14.423,14.423,0,0,1-1.687-.37,5.427,5.427,0,0,0-2.755-.17c-2.277.36-2.382,0.277-4.07-1.415l-1.88-.279,0.013,0.08-0.048-.768c-1.6-.406-3.066-1.268-4.819-1.516-0.751-.107-1.49-0.412-2.244-0.588-0.554-.129-1.12-0.206-1.682-0.29-0.657-.1-1.141.381-1.894,0.054-1.4-.611-3-0.684-4.384-1.43a14.408,14.408,0,0,0-7.526-1.859,7.811,7.811,0,0,0-3.9-1.426,3.835,3.835,0,0,1-1.918-.506c-0.926-.788-2.114-0.857-3.176-1.232a4.9,4.9,0,0,0-3.287-.422,3.641,3.641,0,0,1-2.46-.538,4.337,4.337,0,0,0-2.156-.65c-1.474.069-1.494,0-3.073-1.247,1.062-.21,2.092-0.379,3.079-0.62a0.613,0.613,0,0,0,.131-1.2,18.048,18.048,0,0,0-2.585-1.168,34.842,34.842,0,0,0-3.621-1.067c-1.3-.3-2.625-0.489-4.156-0.766l-0.727-2.1a12.741,12.741,0,0,0-3.837-.818c-1.2-.14-1.482.327-0.874,1.273a2.365,2.365,0,0,1,.17.405c-0.489.37-1.629,0.47-.741,1.509a10.491,10.491,0,0,1,3.57,1.349,9.967,9.967,0,0,0,2.74.827,2.18,2.18,0,0,1,1.659.972c-1.845,0-3.508-1-5.417-1.044l-1.172.814a32.272,32.272,0,0,1-3.7-1.01c-1.449-.585-2.752-0.936-3.707-0.174-1.408-.441-1.34-1.329-1.853-1.862-4.683-.6-9.057-1.575-12.9-4.169l-0.554-1.644c0.2-.347.41-0.708,0.617-1.07a1.785,1.785,0,0,1,1.959-.771c1.028,0.1,2.052.106,3.161,0.156a3.529,3.529,0,0,0,.569,1.267,9.545,9.545,0,0,0,1.453.781c1.671,1.041,3.714,1.394,5.523,2.213a8.055,8.055,0,0,0,5.225.227,0.544,0.544,0,0,0,.139-0.358l-4.457-1.617c-0.257-1.571-1.435-2.373-3.308-2.567a10.014,10.014,0,0,1-4.3-1.451,4.776,4.776,0,0,0-3.86-.679,3.838,3.838,0,0,1,1.059-.886,4.228,4.228,0,0,1,1.14.135c-0.007-.37-0.024-0.723-0.016-1.071a3.729,3.729,0,0,1,.062-0.5,11.762,11.762,0,0,0-1.13-.746,63.4,63.4,0,0,1-6.877-3.8,5.855,5.855,0,0,0-3.512-1.013c-0.591.405-.2,0.932,0.137,1.353,0.613,0.774,1.364,1.5,2.056,2.245l-3.9,1.748c-0.246-.2-0.545-0.472-0.883-0.711a15.4,15.4,0,0,0-2.5-1.673,4.273,4.273,0,0,1-2.592-2.4,6.2,6.2,0,0,0-.73-1.107l1.935-.885a1.243,1.243,0,0,0-.153-0.508q-0.832-.822-1.718-1.616A8.559,8.559,0,0,1-26,193.837a6.515,6.515,0,0,0-3.846-2.478c-0.117-1.832-1.53-3.793.737-5.039-1.008-1.37-2.085-2.61-1.5-4.1a2.171,2.171,0,0,0-.553-2.063c-1.384-1.348-1.013-2.534-.7-3.779,0.032-.129.088-0.253,0.154-0.438a8.64,8.64,0,0,1,1.938.418,6.568,6.568,0,0,0,4.611.367c0.834-.95,1.678-1.9.558-3.3-1.019-.4-2.117-0.77-3.144-1.246a2.8,2.8,0,0,1-1.185-.984,1.7,1.7,0,0,1,.251-1.055,5.792,5.792,0,0,0-3.164-1.484,4.726,4.726,0,0,1-2.807-1.232c-1.2-1.319-3.037-1.817-4.778-2.277a73.013,73.013,0,0,1-8.386-2.286,9.57,9.57,0,0,0-2.513-.506,57.174,57.174,0,0,1-12.314-3.066c-1.434-.477-2.915-0.276-4.216-0.77a12.4,12.4,0,0,0-4.168-.941,5.879,5.879,0,0,1-1.421-.251c-1.383-.4-2.756-0.828-4.2-1.265,0.1-.453.686-0.281,1.04-0.234,1.127,0.146,2.253.385,3.381,0.545a2.273,2.273,0,0,0,1.051-.075,10.758,10.758,0,0,1,5.149-.324c1.225,0.136,2.453.322,3.678,0.508,0.513,0.077.961,0.1,1.119-.307A1,1,0,0,0-61.779,155a2.992,2.992,0,0,0-.779-0.329c-1.289-.4-2.568-0.889-3.88-1.156-1.878-.384-3.667-1.218-5.613-1.264a1.882,1.882,0,0,1-.776-0.315c-0.382-.222-0.732-0.479-1.323-0.874a4.594,4.594,0,0,1,1.132-.324,9.561,9.561,0,0,1,1.707.181c3.032,0.585,6.111,1.023,9.076,1.843a60.369,60.369,0,0,0,6.757,1.22c2.282,0.363,4.564.751,6.846,1.074a14.891,14.891,0,0,0,2.543.108A1.074,1.074,0,0,0-45,153.977c-0.1-.561-0.248-1.124-0.371-1.674,0.94-.178,1.349-0.591.948-1.262-0.778-1.3-.335-2.687-1.4-3.96a0.471,0.471,0,0,1-.089-0.418c0.263-.754.555-1.5,0.816-2.192a1.519,1.519,0,0,1,1.479.874,5.765,5.765,0,0,0,3.333,2.528,2.536,2.536,0,0,1,.5.362l-0.884,1.225,0.871,0.754a3.077,3.077,0,0,0,.792.664c1.6,0.612,3.236,1.152,4.838,1.76a12.624,12.624,0,0,1,2.307,1.063,6.031,6.031,0,0,0,4.331.966c1.851-.294,3.932.023,5.666-0.6,0.409-.147,1.16.269,1.509-0.188a8.912,8.912,0,0,0-3.792-1.686c-2.717-.672-5.453-1.269-8.172-1.937a8.357,8.357,0,0,1-1.441-.652c0.39-.635,1.016-0.375,1.531-0.258,1.974,0.45,3.938.947,5.912,1.395a26.176,26.176,0,0,0,6.8.62,8.335,8.335,0,0,1,3.364.512c1.221,0.464,2.315-.144,2.228-1.118a2.767,2.767,0,0,0-.613-1.451,10.113,10.113,0,0,0-1.759-1.586,2.729,2.729,0,0,0-1.281-.533,40.128,40.128,0,0,1-10.37-2.5c-1.244-.43-2.519-0.788-3.782-1.179-0.033-1.246,1.95-1.655,1.695-3.149-0.354-.2-0.818-0.47-1.3-0.721-1.094-.567-2.25-1.063-2.243-2.229a1.949,1.949,0,0,0-.816-0.923c-0.488-.387-1.054-0.72-1.71-1.158-0.03-.414-0.092-0.9-0.094-1.388a2.179,2.179,0,0,0-1.837-2.112c-0.787-.254-1.547-0.891-2.382-0.412-0.718.411-.119,1.043-0.07,1.582,0.007,0.072.008,0.142,0.015,0.266a8.166,8.166,0,0,1-2.851-.854,2.793,2.793,0,0,0-2.416-.062c-0.811.384-1.574,0.816-2.482,1.292l-0.578-1.048c1.412-.727,2.745-1.438,4.119-2.109a2.782,2.782,0,0,1,3.107.285,2.852,2.852,0,0,0,.651.222l0.4-.818,4.993,0.459c0.443-.507-0.39-1.525.728-1.934,2.332,0.7,4.733,1.424,7.132,2.152a2.836,2.836,0,0,0,2.248-.054,1.758,1.758,0,0,0-1.265-1.077c-1.324-.558-2.7-1.036-4.022-1.591a2.13,2.13,0,0,1-1.073-.743c-0.347-1.361-1.865-1.77-3.17-2.218a17.3,17.3,0,0,1-4.4-2.433,2.077,2.077,0,0,1-.763-0.693c-0.329-1-1.525-1.571-2.254-2.366l-0.016.022a19.807,19.807,0,0,1,4.753.175,3.147,3.147,0,0,0,3.335-1.027l-3.671-2.667a1.05,1.05,0,0,1,1.3-.179c2.439,1.019,5.291,1.5,7.045,3.56h2.195c0.252-1.327-.837-2.325-1.675-3.319a5.676,5.676,0,0,0-3.212-1.646c-2.585-.506-5.008-1.465-7.533-2.118-2.147-.555-4.326-1.024-6.434-1.685-2.857-.9-5.735-1.675-8.645-2.386a10.85,10.85,0,0,1-3.691-1.635,7.686,7.686,0,0,1,1.578-.062c2.455,0.516,4.907,1.05,7.35,1.624a66.562,66.562,0,0,0,8.213,1.532c0.845,0.089,1.933.351,2.341-.535A1.611,1.611,0,0,1-37.9,109.2c2.244,0.927,4.789.746,6.961,1.878a0.6,0.6,0,0,0,.274.082c1.9-.148,3.765.721,5.651,0.781,0.747,0.024,1.48-.04,2.221-0.055s1.483,0,2.217-.032a2.832,2.832,0,0,0,1.288-.162,2.8,2.8,0,0,0,.541-1.179,33.519,33.519,0,0,0-6.08-1.963,6.586,6.586,0,0,1-.494.77,1.056,1.056,0,0,1-1.593.132c-0.637-.493-1.222-1.024-1.871-1.574a4.756,4.756,0,0,0,.333-1.361,6.423,6.423,0,0,0-.469-1.5c2.8-.022,5.419.7,8.246,1.144-0.061-.48-0.11-0.866-0.154-1.212-1.1-.674-2.652-0.61-3.281-1.851a16.13,16.13,0,0,1,5.84.187c1.757,0.5,3.6.453,5.31,1.148a1.161,1.161,0,0,0,.565.057A13.274,13.274,0,0,1-7.663,105c0.769-.524.769-0.524,1.4-2.124l4.218,0.435a1.493,1.493,0,0,0,.854-1.274,15.234,15.234,0,0,0-6.216-3.824c-2.909-.994-5.94-1.707-8.92-2.534-0.745-.206-1.5-0.391-2.25-0.568-1.507-.353-3.011-0.735-4.527-1.027a13.84,13.84,0,0,1-4.875-1.633,10.514,10.514,0,0,0-1.856-.714c-0.533-.2-1.093-0.358-1.594-0.6-0.709-.343-1.085-0.976-0.719-1.036a2.916,2.916,0,0,1,1.3.126c2.6,0.89,3.3.912,5.683,0.028l2.01,2.05a3.005,3.005,0,0,0,2.4-.486,2.29,2.29,0,0,1,1.826-.2,19.953,19.953,0,0,0,2.843.475c1.22,0.116,2.438.058,3.654,0.218s2.45,0.569,3.678.738c1.127,0.155,2.259.121,3.392,0.2a8.02,8.02,0,0,1,1.667.235,1.371,1.371,0,0,0,1.453-.425c-0.333-1.315-2.157-1.677-3.222-2.575,0.208-.442.929-0.22,1.3-0.424,0.407-.223.77-0.487,1.227-0.781L-4.962,87.57l2.2-.553A1.219,1.219,0,0,0-2.7,86.491a2.174,2.174,0,0,0-1.624-1.249c-1.1-.353-2.219-0.638-3.423-0.979l-1.981-3.114C-6.265,81.34-2.8,82.219.831,82.4c1.856-1.081,1.856-1.081.989-2.758l0.012,0.072a5.641,5.641,0,0,1,1.633.2,8.9,8.9,0,0,0,3.379.611c0.942,0.056,1.388-.56,1.01-1.3a12.142,12.142,0,0,0-.718-1.076l4.209-1.568c0.029-.86.055-1.617,0.075-2.24,0.542-.509,1.184-0.155,1.707-0.194,1.412-.108,1.772-0.841.789-1.794a15.108,15.108,0,0,0-1.541-1.142c0.215-.234.4-0.448,0.6-0.655s0.409-.4.633-0.623a2.231,2.231,0,0,0-.508-0.59q-2.841-1.53-5.723-3.013a4.17,4.17,0,0,0-1.356-.466,14.4,14.4,0,0,1-4.266-1.572c-2.181-.956-4.093-2.245-6.32-3.155A7.663,7.663,0,0,0-7.6,60.5c-1.124,0-2.259-.031-3.394-0.087a14.118,14.118,0,0,1-1.5-.247c-0.191-.815.17-1.585-0.675-2.307a2.554,2.554,0,0,0-2.243-.829,7.96,7.96,0,0,1-4.438-.617c-0.532-.2-1.127-0.285-1.666-0.479s-1.018-.452-1.614-0.723l-0.945.743a4.112,4.112,0,0,0,.458.571c1.055,0.92,1.1,1.1.228,1.752-0.43.32-.924,0.591-1.508,0.959a9.008,9.008,0,0,0,4.746,2.1c2.138,0.381,2.137.386,3.962,1.919a1.88,1.88,0,0,1-.738.083c-0.436-.181-0.8-0.473-1.232-0.676a2.821,2.821,0,0,0-2.166-.347,7.421,7.421,0,0,1-1.354.162,3.617,3.617,0,0,1-1.9-.286,33.271,33.271,0,0,0-4.936-1.485,32.055,32.055,0,0,1-7.808-2.916,3.05,3.05,0,0,1-1.645-1.472,14.109,14.109,0,0,1,2.914-.656c1.076-.03,2.266.446,3.471,0.108l0.291-1.152a3.888,3.888,0,0,0-.612-0.507c-0.663-.358-1.4-0.643-2.018-1.037a17.232,17.232,0,0,1-1.591-1.257,0.945,0.945,0,0,1,1.255-.271c1.7,0.357,3.4.767,5.094,1.149,0.368,0.082.743,0.127,1.227,0.207a1.8,1.8,0,0,0-.327-1.852,4.32,4.32,0,0,1-.907-1.634c-0.139-1.226-1-2.041-2.4-2.683a1.873,1.873,0,0,1-.4-0.342c-0.022-.687.508-1.009,1.361-0.956,1.036,0.065,2.086.275,3.127,0.37a2.314,2.314,0,0,0,1.31-.1c0.608-1.019,1.981-.687,3.244-0.808,0.35,0.311.709,0.665,1.117,0.984a4.609,4.609,0,0,0,2.643.956,15.585,15.585,0,0,1,7.123,1.953,3.214,3.214,0,0,0,.992.087l0.346-1.106a3.641,3.641,0,0,0-.584-0.549,8.276,8.276,0,0,0-1.023-.479,24.084,24.084,0,0,1-3.405-1.5c-2.34-1.5-5.09-2-7.7-2.895a10.909,10.909,0,0,1-5-3.066c0.472-.064.792-0.1,1.1-0.152,0.256-.042.5-0.1,0.854-0.174-0.1-.434-0.2-0.849-0.318-1.354a11.472,11.472,0,0,0,1.4.184,0.653,0.653,0,0,0,.563-0.291,0.686,0.686,0,0,0-.378-0.536c-1.21-.53-2.593-0.819-3.533-1.782,0.071-.743.635-1.032,1.685-0.81,1.758,0.371,3.411.516,4.824-.28a2.8,2.8,0,0,1,1.373,0c0.848,0.118,1.7.3,2.5,0.448,0.717-1.073.717-1.073,2.856-.926,0.772-.458,1.222-1.267,2.677-1.327,0.972,0.49.906,2.068,2.878,1.952a1.787,1.787,0,0,0,.8-1.31,0.858,0.858,0,0,0-.23-0.82c-1.066-.924-2.182-1.819-3.322-2.695a16.443,16.443,0,0,0-4.4-1.952l0.951-1.928-1.015-1.494a0.517,0.517,0,0,1,.167-0.225c1.551-.042,2.682-1.456,4.6-0.2a5.349,5.349,0,0,0,1.048,1.449,4.333,4.333,0,0,0,1.609.245l0.743,0.013a0.634,0.634,0,0,0-.8-0.429l-1.063-.547c1.356-.151,1.519-0.2,1.854-0.025A10.351,10.351,0,0,0-3.681,25.33c3.681-.165,6.991.958,10.261,2.4a4.51,4.51,0,0,0,2.15.647,0.969,0.969,0,0,1,.55.134c1.576,1.23,3.632.946,5.408,1.553,0.744,0.254,1.693.669,2.279-.032,1.1,0.189,2.287.034,3.229,0.854a3.052,3.052,0,0,0,2.025.87,2.114,2.114,0,0,1,.979.383,8.036,8.036,0,0,0,5.887,1.46c1.242-.19,2.5-0.338,3.737-0.5,1.356,0.443,1.549,1.353,1.969,2.266a3.221,3.221,0,0,0,3.78-.648c2.024,0.62,4,1.3,5.105,2.736a34.711,34.711,0,0,0,7.248.942c1.042,0.092,1.25-.291,1.279-0.933a8.556,8.556,0,0,0-1.549-1.087c-1.028-.437-1.369-1.3-2.274-1.778-0.759-1.6-2.314-1.954-4.179-1.873-0.552.024-1.15-.1-1.693-0.058a2.887,2.887,0,0,0-1.217.343C40.36,33.577,39.491,34.2,38.6,34.81ZM338.206,260.775l0.533-.05-0.571-.131-0.309.1Zm-5.689,1.96-0.06.107,0.039-.152a8.325,8.325,0,0,0,2.393-.864,2.938,2.938,0,0,0-2.425-1.315,2.274,2.274,0,0,0-2.212.5C330.67,261.814,331.839,262.105,332.517,262.735Zm2.885-187.4a18.948,18.948,0,0,0,5.528,1.421,12.81,12.81,0,0,1,2.539.372,24.551,24.551,0,0,1,2.606,1.047l0.309-1.088c-1.031-.5-2.023-1.028-3.056-1.485-1.566-.693-3.174-0.5-4.769-0.647a6,6,0,0,0-3.142.451c-0.552.166-1.115,0.32-1.647,0.511a0.39,0.39,0,0,0-.019.357,0.353,0.353,0,0,0,.206.152,1.086,1.086,0,0,0,1.337-.3A3.029,3.029,0,0,0,335.4,75.336ZM16.129,52.856l0.036,0.16a15.228,15.228,0,0,1-3.033-.655c-1.659-.733-3.358-0.707-5.03-1-1.113-.2-1.472.2-1.584,1.474,1.582,0.537,3.2,1.118,4.832,1.632,1.818,0.57,3.386,1.317,4.2,2.767a2.385,2.385,0,0,0,.7.276l1.3-1.293a26.727,26.727,0,0,0,3.642.326c1.391-.06,2.406,1.254,3.787.857,0.566-1.048.566-1.048-1.562-2.488a2.512,2.512,0,0,1,.951-0.475,12.281,12.281,0,0,1,1.393.274,0.762,0.762,0,0,0,.833-1.167,2.857,2.857,0,0,0-1.846-1.091,14,14,0,0,0-2.264-.213,8.915,8.915,0,0,1-3.615-.6,18.481,18.481,0,0,0-3.482-.689C14.853,51.768,15.833,52.263,16.129,52.856Zm311.032,192.7-0.007-.068a12.276,12.276,0,0,1-1.278,1.215,14.985,14.985,0,0,1-1.728.922,13.2,13.2,0,0,0,4.593.537l2.478,1.271c1.909-.539,3.686-0.927,5.8-0.034a2.568,2.568,0,0,0,2.36-.126,14.3,14.3,0,0,1,1.333-.617h-0.137c0.926,0.261,1.844.56,2.78,0.774a2.947,2.947,0,0,0,2.96-.577,9.81,9.81,0,0,1,1.284-1.241c0.662-.487-0.057-1.027-0.138-1.537a7.546,7.546,0,0,1,3.867.182,2.023,2.023,0,0,0,1.98-.37,1.607,1.607,0,0,0,.416-0.887c-0.632-.215-1.073-0.4-1.531-0.509a12.713,12.713,0,0,0-1.418-.192,72.589,72.589,0,0,0-7.371-.359c-1.788-.021-3.6-0.124-5.4-0.238-1.4-.089-2.852-0.519-4.156-0.032a3.145,3.145,0,0,1-1.1-.161,12.659,12.659,0,0,0-1.407-.205c-3.024-.118-6.045-0.215-9.26-0.326a1.648,1.648,0,0,0,.308.816c1.165,0.435,2.355.833,3.56,1.167A2.184,2.184,0,0,1,327.161,245.555ZM-11.045,185.668l-1.376,1a5.115,5.115,0,0,0,3.709,3.2,33.614,33.614,0,0,0,6.744,1.4,2.282,2.282,0,0,0,.612-0.175l0.446-.79-1.017-1.2c1.033-.458,2.04-0.856,2.967-1.333,0.626-.322.88-0.809,0.1-1.59-0.794-.106-1.733-0.252-2.67-0.352-1.739-.185-1.832-0.239-2.494-1.724l1.048-.915c-2.682-1.1-5.191-2.339-8.077-2.526a6.132,6.132,0,0,0-.092-1.931c-0.79-2.094-4.708-4.194-7.192-4.226-1.064-.013-1.793.182-2.119,1.019a9,9,0,0,0,1.569,2.063,18.554,18.554,0,0,0,3.017,1.556c-1.41.55-3.208-.85-4.3,0.21a2.952,2.952,0,0,0,2.142,1.753,43.376,43.376,0,0,1,4.742,1.814C-13.617,184.546-13.409,184.691-11.045,185.668ZM-5.483,59.947C-3.9,60.4-2.5,61.378-.825,60.983a1.315,1.315,0,0,1,.564.082c1.654,0.485,3.3,1,4.963,1.455,0.833,0.226,1.7.334,2.55,0.5A1.585,1.585,0,0,0,8.658,62.6a2.148,2.148,0,0,1,.7.021l1.578,1.316,1.641-.244a18.917,18.917,0,0,0,1.674,1.1,6.726,6.726,0,0,0,1.857.718c0.493,0.086,1.01-.231,1.526-0.184a10.57,10.57,0,0,1,4.44,1.066c0.962,0.546,2.038.967,3.025,1.425,0.99-.388,1.876-0.7,2.7-1.07a0.92,0.92,0,0,0-.216-1.756c-1.232-.435-2.277-1.241-3.731-1.3a10.952,10.952,0,0,1-2.8-.581,28.169,28.169,0,0,0-3.388-.55A29.548,29.548,0,0,1,14.443,61.4a7.05,7.05,0,0,0-1.7-.259,12.336,12.336,0,0,1-3.926-.893,7.514,7.514,0,0,0-3.051-.668c-1.421.025-2.719-.974-4.193-0.838a3.282,3.282,0,0,1-.792-0.29c-2.124-.6-4.252-1.177-6.375-1.777a2.262,2.262,0,0,0-2.41.464ZM70.452,42.44l1.26-2.579a11.813,11.813,0,0,0-4.252-1.71,29.489,29.489,0,0,1-4.928-1.611,9.376,9.376,0,0,0-5.2-.666c-0.7.118-1.434,0.178-2.157,0.264l-0.6,1.9c0.495,0.574.9,1.1,1.378,1.578a3.59,3.59,0,0,0,1.063.749,25.36,25.36,0,0,0,4.738,1.908C64.751,42.886,67.818,43.246,70.452,42.44ZM317.423,71.446a9.181,9.181,0,0,0-4.517-1.209c-1.014.013-2.049-.03-3.079-0.117-1.7-.144-3.412-0.373-5.113-0.5a1.488,1.488,0,0,0-1.1.366c-0.258.343,0.229,0.641,0.672,0.859a12.471,12.471,0,0,1,1.5.761,11,11,0,0,0,4.564,1.586c2.18,0.364,4.3.146,6.486,0.545,1.292,0.235,1.707-.213,1.294-1.192A7.222,7.222,0,0,0,317.423,71.446ZM341.481,234.22a2.109,2.109,0,0,0,1.842.981c3.407,0.231,6.816.478,10.211,0.628a19.917,19.917,0,0,0,3.547-.268c0.414-.055.776-0.4,0.518-0.8a1.52,1.52,0,0,0-.909-0.528,32.616,32.616,0,0,1-5.376-.8,23.379,23.379,0,0,0-2.533-.458c-1.026-.144-1.879-0.039-2.176.78a1.12,1.12,0,0,1-.441.355ZM14.867,204.3a1.522,1.522,0,0,0-.093-0.829,4.018,4.018,0,0,0-1.182-1.017c-0.992-.528-2.056-0.968-3.089-1.447-1.016-.471-2-1.007-3.05-1.4a9.149,9.149,0,0,0-3.9-.573,0.824,0.824,0,0,0-.651.538,0.937,0.937,0,0,0,.41.754,6.274,6.274,0,0,0,1.281.59,32.487,32.487,0,0,1,5.359,2.512A12.372,12.372,0,0,0,13.5,204.53,3.891,3.891,0,0,0,14.867,204.3Zm-63.384-45.145a1.755,1.755,0,0,0-.257-0.663c-1.988-1.328-4.381-1.556-6.671-2.1a13.807,13.807,0,0,0-4.607-.255c-0.019.939,0.654,1.471,1.68,1.742a22.411,22.411,0,0,0,6.655,1.11c0.437-.019.921,0.143,1.377,0.168C-49.788,159.186-49.245,159.159-48.517,159.155Zm399.505,61.03a4.356,4.356,0,0,0-2.134-1.117,6.917,6.917,0,0,0-3.3.038c-1.153.44-2.355,0.823-3.555,1.237a2.487,2.487,0,0,0,2.743,1.045l1.641-.4C349.575,221.932,349.62,221.924,350.988,220.185ZM8.078,43.819C6.495,42.8,5.811,41.683,4.24,41.362q-2.947-.6-5.906-1.107a0.676,0.676,0,0,0-.3.628,1.72,1.72,0,0,0,.818.6c1.657,0.7,3.33,1.371,5.006,2.038a2.71,2.71,0,0,0,.822.174C5.6,43.741,6.53,43.763,8.078,43.819ZM382.845,189.8a17.834,17.834,0,0,1-2.714-1.063,6.73,6.73,0,0,0-4.322-1l-1.15,1c1.287,0.63,2.422,1.263,3.635,1.757a3.479,3.479,0,0,0,3.388-.029C381.923,190.292,382.21,190.157,382.845,189.8Zm-31.706,82.4c-2.136-1.158-4.537-.685-5.375.928a0.535,0.535,0,0,0,.1.56,1.145,1.145,0,0,0,.733.275,4.172,4.172,0,0,1,2.948.3,2.66,2.66,0,0,0,1.326-.041,0.73,0.73,0,0,0,.678-0.954A7.637,7.637,0,0,0,351.139,272.191Zm-351.8-72.739,1.709,0.1L1.511,198.3c-0.719-.528-1.346-1.022-2.022-1.474a3.381,3.381,0,0,0-3.146-.252,1.077,1.077,0,0,0-.386.619Zm375.319-12.134a1.22,1.22,0,0,0-.779-1.625,3.962,3.962,0,0,0-3.451-.02,0.529,0.529,0,0,0-.013.919C371.719,187.392,373.059,188.032,374.654,187.318ZM362.7,247.905a2.775,2.775,0,0,0,2.221,1.064,15.417,15.417,0,0,0,2.631-.408c0.4-.087.347-0.666-0.047-0.913a1.926,1.926,0,0,0-.746-0.366,24.7,24.7,0,0,0-3.082-.056A2.413,2.413,0,0,0,362.7,247.905ZM9.111,38.414a3.135,3.135,0,0,1,.443.875,1.651,1.651,0,0,1-.644.215l0.141,0.267,2.383-.006c0.809,0.663.792,0.65,1.384,0.2a10.056,10.056,0,0,1,1.069-.614l-1.747-1.167Zm11.7-11.9a7.544,7.544,0,0,0,4.356,1.487,0.9,0.9,0,0,0,.776-0.373,1.152,1.152,0,0,0-.468-0.946A5.844,5.844,0,0,0,20.809,26.518ZM345.253,261.1c-0.839.007-1.487-.022-2.1,0.033a3.264,3.264,0,0,0-.894.369c0.452,0.4.747,0.7,1.093,0.957a3.33,3.33,0,0,0,.944.546,5.082,5.082,0,0,0,1.358.223c0.58,0.016.944-.456,0.669-0.858S345.692,261.62,345.253,261.1ZM2.423,39.246a1.462,1.462,0,0,0-.781-1.741,2.506,2.506,0,0,0-1.7-.766c-0.959.143-.658,0.816-0.661,1.341a1.129,1.129,0,0,0,.263.405A4.6,4.6,0,0,0,2.423,39.246ZM323.429,270.368a6.2,6.2,0,0,0,4.537,1.182,0.768,0.768,0,0,0,.464-0.626,0.639,0.639,0,0,0-.7-0.608C326.513,270.293,325.314,270.338,323.429,270.368Zm-342-87.7a1.314,1.314,0,0,0,.045.82,3.6,3.6,0,0,0,1.291.863,1.412,1.412,0,0,0,1.991-.677A8.706,8.706,0,0,0-18.574,182.668Zm-7.033,9.6c0.625-.526.14-0.894-0.17-1.249a1.327,1.327,0,0,0-1.222-.4c-0.262.023-.676-0.326-0.914-0.288a0.568,0.568,0,0,0-.511.832Zm352.679,76.684a3.95,3.95,0,0,0,2.893.858c0.486-.04,1.131-0.048,1.093-0.617C329.4,268.593,329.4,268.593,327.072,268.955Zm1.852-37.143c0.61,1.458.949,1.714,1.993,1.6a0.544,0.544,0,0,0,.349-0.981A3.126,3.126,0,0,0,328.924,231.812Zm30.164,40.556a2.176,2.176,0,0,0,2.545-.2c0.213-.233-0.179-0.728-0.625-0.821a2.278,2.278,0,0,0-1.945.372A0.878,0.878,0,0,0,359.088,272.368ZM3.777,208.866c0.982,0.065,1.316-.252,1.191-0.846a1.2,1.2,0,0,0-1.306-.718,3.294,3.294,0,0,0-.791.161Zm-9-158.486a10.429,10.429,0,0,0-1.035-1.054,1.208,1.208,0,0,0-1.274-.132,0.645,0.645,0,0,0-.4.442,0.96,0.96,0,0,0,.94.733A13.164,13.164,0,0,0-5.219,50.38ZM382.54,142.319a1.524,1.524,0,0,0-1.773-.087,0.481,0.481,0,0,0,.111.544,1.292,1.292,0,0,0,1.635.04A0.739,0.739,0,0,0,382.54,142.319Zm-27.5,79.316a1.341,1.341,0,0,0-1.49-1c-0.4.01-.762,0.135-0.66,0.456a1.14,1.14,0,0,0,.639.641A7.375,7.375,0,0,0,355.04,221.635ZM-16.729,55.205a0.561,0.561,0,0,0-.017-0.373,1.964,1.964,0,0,0-.63-0.436,1.1,1.1,0,0,0-1.232-.147,0.4,0.4,0,0,0-.157.336,7.945,7.945,0,0,0,1.053.7,1.084,1.084,0,0,0,.543.072A1.694,1.694,0,0,0-16.729,55.205ZM337.114,262.379c0.956,0.215,1.69.5,2.2-.025C338.268,261.54,338.268,261.54,337.114,262.379ZM320.2,74.473l1.411-.544c-0.453-.75-1.085-0.689-1.876-0.666C319.877,73.623,320.008,73.965,320.2,74.473Zm58,90.276q0.154,0.237.307,0.474a2.473,2.473,0,0,1,.763-0.144,0.915,0.915,0,0,0,1.094-.289,0.412,0.412,0,0,0-.227-0.344,4.084,4.084,0,0,0-1.3-.213A1.438,1.438,0,0,0,378.2,164.749ZM195.918,252.842a1.305,1.305,0,0,0,1.337.726c0.375-.037.92-0.024,0.822-0.548A2.353,2.353,0,0,0,195.918,252.842Zm-203.5-227c0.587,0.813,1.358.692,2.306,0.844A3.161,3.161,0,0,0-7.584,25.841ZM321.532,262.485a0.851,0.851,0,0,0,.166.38,1.05,1.05,0,0,0,1.179.258,0.371,0.371,0,0,0,.072-0.473,1.142,1.142,0,0,0-1.2-.258A1.61,1.61,0,0,0,321.532,262.485ZM-28.228,58.679a0.905,0.905,0,0,0-.172-0.445,0.98,0.98,0,0,0-.534-0.069,0.32,0.32,0,0,0-.058.284A7.721,7.721,0,0,0-28.228,58.679Zm17.369-1.519a4.336,4.336,0,0,0,.756-0.122,0.359,0.359,0,0,0-.1-0.329,3.971,3.971,0,0,0-.715-0.123C-10.9,56.744-10.885,56.9-10.859,57.16Zm0.567,137.506,0.136-.354a1.23,1.23,0,0,0-.478-0.027,0.97,0.97,0,0,0-.141.439Zm333.076,59.511c0.034-.107.069-0.215,0.1-0.322a1.622,1.622,0,0,0-.464-0.069,0.967,0.967,0,0,0-.078.415Zm-334-61.06,0.239,0.054c0-.11.006-0.22,0.008-0.329a1.031,1.031,0,0,0-.212-0.016A1.377,1.377,0,0,0-11.215,193.117Zm396.959-50.586-0.22-.068,0.116,0.154ZM2.9,52.842l0.127,0.151,0.034-.2Zm59.637-18.16a2.816,2.816,0,0,0-.252-0.369,0.376,0.376,0,0,0-.254.02,0.173,0.173,0,0,0,0,.194A4.334,4.334,0,0,0,62.542,34.682Zm-63.1,17.4a0.37,0.37,0,0,0-.08-0.175,0.771,0.771,0,0,0-.237-0.069,0.357,0.357,0,0,0,.077.174A0.8,0.8,0,0,0-.562,52.086Zm-1.61-.535L-2.417,51.3a0.2,0.2,0,0,0-.044.118A1.6,1.6,0,0,0-2.173,51.552ZM348.173,78.387a0.557,0.557,0,0,0,.162-0.066,0.314,0.314,0,0,0-.08-0.114,0.538,0.538,0,0,0-.159.068A0.3,0.3,0,0,0,348.173,78.387ZM60.867,35.1a0.277,0.277,0,0,0-.038-0.179,0.609,0.609,0,0,0-.239-0.016l0.1,0.234Zm-7.574,3.514,0.149-.018-0.1-.086ZM440.727,189.682c-0.3-.56.2-0.863,0.672-0.927a3.361,3.361,0,0,0,3.047-2.175,13.777,13.777,0,0,1,1.056-1.112c0.4-.712.979-1.469-0.345-2.284a1.081,1.081,0,0,1-.429-0.567,3.791,3.791,0,0,0-2.728-2.31c-0.8.041-1.631,0.1-2.471,0.119s-1.042-.28-0.833-1.165c0.794-.186,1.549.578,2.456,0.286a8.166,8.166,0,0,1,2.2.125c0.84,0.029,1.672.006,2.51,0.006,0.009-.4,0-0.682.024-0.958,0.092-.908.938-1.3,2.067-0.936a5.7,5.7,0,0,1,1.034.474,14.136,14.136,0,0,0,4.165,1.715,2.18,2.18,0,0,1,.561.427,4.094,4.094,0,0,0-.442,1.008,3.77,3.77,0,0,1,.033,1.227c-0.783,1.211-1.4,2.582-3.619,2.728a1.823,1.823,0,0,0,1.346,1.436,2.853,2.853,0,0,1,1.637,1.552l-2,3.095c-0.778.168-1.53,0.386-2.333,0.484a3.529,3.529,0,0,1-1.654-.111,3.433,3.433,0,0,0-3.53.274c-1.111-.469-2.333-0.6-3.173-1.33-0.279-.649.111-0.945,0.785-1.1l0.152,0.058Zm1.525,0.633,0.168-.095-0.279-.134a0.28,0.28,0,0,0-.057.15A0.476,0.476,0,0,0,442.252,190.315Zm6.343-10.468a0.276,0.276,0,0,0-.029-0.182,0.619,0.619,0,0,0-.245-0.024,0.279,0.279,0,0,0,.029.183A0.622,0.622,0,0,0,448.6,179.847ZM20.782,17.53a1.953,1.953,0,0,1-1.8-.528,21.74,21.74,0,0,0-4.539-2.7,7.368,7.368,0,0,1-2.88-2.611,6,6,0,0,1,1.382.272c0.943,0.439,1.779,1.063,2.749,1.428,0.865,0.324,1.883.318,2.778,0.6a16.183,16.183,0,0,0,5.125.907c0.744-.628.727-1.281-0.26-2.028-1.526-1.154-2.4-2.592-3.863-3.886A7.683,7.683,0,0,0,21.6,8.333a4.609,4.609,0,0,0,.875-1.624l1.853-.63a2.555,2.555,0,0,1,.639.241A12.65,12.65,0,0,0,30.173,9.3a10.326,10.326,0,0,1,5.05,2.8,7.42,7.42,0,0,0,1.391.844c0.42,0.277.8,0.592,1.226,0.915a2.53,2.53,0,0,1-2.528-.407,8.227,8.227,0,0,0-5.4-1.315,18.966,18.966,0,0,1-2.994-.313c-0.55.348-.312,0.687,0.035,0.98,0.521,0.44,1.095.847,1.811,1.393l-2.35.539,1.149,1.7a1,1,0,0,1-1.362.51,3.288,3.288,0,0,1-.538-0.2,7.466,7.466,0,0,0-5.7-.307l0.823,1.16Zm25.84,1.208c0.194,0.188.457,0.421,0.687,0.669a7.788,7.788,0,0,0,5.043,2.546,22.838,22.838,0,0,1,3.842,1.08,2.239,2.239,0,0,1,.61.453c-0.176.387-.534,0.235-0.9,0.167-2.058-.377-4.18-0.428-6.117-1.4-2.861-.379-5.532-1.667-8.423-1.939a15.213,15.213,0,0,1-2.839-.508,23.716,23.716,0,0,0-6.786-.934A4.033,4.033,0,0,1,28.913,17.8a0.524,0.524,0,0,1,.3-0.979,6.966,6.966,0,0,1,1.661-.049,1.517,1.517,0,0,0,1.426-.4c0.663-.809,1.795-0.773,2.881-0.55,2.156,0.442,4.294,1.012,6.432,1.556C43.174,17.783,44.726,18.224,46.622,18.738ZM423.557,150.777a0.771,0.771,0,0,1-.879.853c-0.749.014-1.508-.012-2.262-0.016-1.287-.008-2.356.222-2.848,1.153a1.2,1.2,0,0,1-.652.593c-2.344.722-4.552,1.794-7.568,0.948-0.525-.756-0.187-1.39-0.132-2.072a2.029,2.029,0,0,0-.607-1.413,5.4,5.4,0,0,0-1.594-.657l-2.176,1.9a6.163,6.163,0,0,1-1.344-.631,20.63,20.63,0,0,1-1.689-1.712,7.042,7.042,0,0,1,2.653-.386c3.856,0.164,7.712.3,11.58,0.565C418.482,150.072,420.947,150.465,423.557,150.777ZM286.605,57.091a3.717,3.717,0,0,0,2.243,1.062,8.628,8.628,0,0,1,1.555.481c-0.058.628-.671,0.513-1.045,0.484-1.128-.088-2.263-0.263-3.432-0.408-0.333-.541-0.323-1.223-1.4-1.507-0.913-.24-1.781-0.638-2.678-0.943a1.587,1.587,0,0,1-1.387-1.312,1.585,1.585,0,0,0-.912-0.8,7.394,7.394,0,0,0-1.962-.468,2.882,2.882,0,0,1-1.768-1c-2.982-.458-5.935-0.322-8.7-1.383-0.215-.545.079-0.7,0.481-0.681,0.754,0.031,1.518.1,2.276,0.2,3.494,0.453,6.988.923,10.737,1.42a10.332,10.332,0,0,0,4.293,2.5,8.312,8.312,0,0,1,1.274.6,8.882,8.882,0,0,1,.923.713l-0.488,1.1Zm78.928,29.821-0.752,1.008a2.726,2.726,0,0,1-.605.093q-1.976-.181-3.953-0.395a2.663,2.663,0,0,0-1.783.333,2.711,2.711,0,0,1-.926-0.1c0.018-1.342,1.54-2,1.68-3.295a6.5,6.5,0,0,1,2.034.42,7.484,7.484,0,0,0,3.6,1.031l1.135-.991a15.469,15.469,0,0,0,1.949,1.545,16.966,16.966,0,0,0,2.466.951c-0.437.761,0.028,1.837-1.639,1.771C367.7,88.412,367.648,86.848,365.533,86.912Zm-64.257-38.99a6.034,6.034,0,0,1,1.341-.3c1.122,0.03,2.258.15,3.385,0.207s2.262,0.074,3.393.118a3.866,3.866,0,0,1,1.122.1,32.35,32.35,0,0,0,6.759,1.234c0.287,0.041.578,0.062,0.858,0.129,1.294,0.31,2.586.633,3.876,0.95-0.3,1.09-.661,1.312-1.66.983-0.716-.236-1.4-0.541-2.093-0.81a1.378,1.378,0,0,1-.413.414c-0.82-.232-1.625-0.51-2.432-0.78a2.356,2.356,0,0,0-.8-0.27c-1.415.4-2.785-.352-4.171-0.542a11.3,11.3,0,0,0-2.269-.21c-2,.152-3.978-0.472-5.963-0.722A3.994,3.994,0,0,1,301.276,47.922ZM-10.614,70.8l-0.536-1.057-2.126.293A6.139,6.139,0,0,0-17.7,69.008a3.977,3.977,0,0,1-2.841-1.058,0.517,0.517,0,0,1,.235-0.876,2.008,2.008,0,0,1,.808-0.031,20.706,20.706,0,0,0,5.839.428l1.309,1.213a12.475,12.475,0,0,1,6.458,1.971C-7.291,71.357-9.042,70.507-10.614,70.8ZM392.338,237.013c-0.714.4-1.162,0.688-1.667,0.916-0.523.237-1.1,0.414-1.747,0.651l-4.066-.736c-0.973-1.125-2.109-2.12-1.069-3.238C386.773,234.412,389.286,235.822,392.338,237.013Zm-6.751,27.172c-3.411-.108-6.619-0.212-9.825-0.308a0.934,0.934,0,0,1-1.055-.726c2.059-.18,4.013-0.707,6.268-0.283a3.892,3.892,0,0,0,3.277-.6c0.06-.047.129-0.088,0.189-0.135,0.97-.766,2.124-0.829,3.666-0.011a2.81,2.81,0,0,1-.8.662,12.091,12.091,0,0,1-1.329.171C385.448,263.067,385.4,263.3,385.587,264.185ZM-21.63,66.718c-0.486.15-.963,0.311-1.458,0.446A2.666,2.666,0,0,1-26.348,66a6.982,6.982,0,0,0-1.79-2.181c1.57-.757,3,0.171,4.437.456l-0.015-.1a17.187,17.187,0,0,0,2.081,2.548ZM364.937,276.655a4.31,4.31,0,0,1,3.5,2.643,1.666,1.666,0,0,1-1.953.266c-1.161-.384-2.365-0.665-3.555-0.992C363.164,277.681,363.164,277.681,364.937,276.655ZM-88.129,147.982a12.818,12.818,0,0,1,3.59.151c2.057,0.369,4.1.9,6.141,1.371a0.467,0.467,0,0,1,.23.143,0.766,0.766,0,0,1,.229.386,0.378,0.378,0,0,1-.306.256,3.333,3.333,0,0,1-.841-0.039c-2.636-.413-5.22-1.238-7.887-1.468A1.247,1.247,0,0,1-88.129,147.982ZM6.708,74.56L4.7,74.029a3.059,3.059,0,0,1-.867.711,1.929,1.929,0,0,1-1.068-.127A13.612,13.612,0,0,1,.718,73.7a0.839,0.839,0,0,1-.362-0.756,0.792,0.792,0,0,1,.666-0.463,5.9,5.9,0,0,1,1.91.3,4.415,4.415,0,0,0,1.879.39C5.519,73.134,5.965,73.621,6.708,74.56Zm-84.86,26.533a3.65,3.65,0,0,1-2.449-.166c-1.966-.451-3.868-1.21-5.933-1.19a6.745,6.745,0,0,1-1.956-.885,6.783,6.783,0,0,1,1.648-.2q2.825,0.485,5.636,1.095a6.18,6.18,0,0,1,3.062,1.4Zm-15.416,50.421a18.906,18.906,0,0,1,6.333,1.209,3.152,3.152,0,0,1,.81.613,0.27,0.27,0,0,1-.019.189,0.948,0.948,0,0,1-.414.154q-2.547-.408-5.091-0.856a1.8,1.8,0,0,1-.524-0.213,1.96,1.96,0,0,1-.437-0.314C-93.089,152.117-93.231,151.92-93.568,151.514ZM366.153,92.125c0.456-.2.99-0.4,1.452-0.662s0.884-.6,1.333-0.918a2.869,2.869,0,0,1,.84.191c0.831,0.548.919,1.041,0.269,1.383-0.97.511-1.965,1-3,1.518A1.431,1.431,0,0,1,366.153,92.125Zm30.92,159.252a0.746,0.746,0,0,1,.046-0.363,8.438,8.438,0,0,0,2.5-.953,2.786,2.786,0,0,1,1.592.074,2.119,2.119,0,0,1,.64.748A9.6,9.6,0,0,1,397.073,251.377Zm37.05-52.758a1.389,1.389,0,0,1-.9-1.451,0.964,0.964,0,0,1,.4-0.23,14.847,14.847,0,0,1,2.179.069,1.377,1.377,0,0,1,.724.625,0.489,0.489,0,0,1-.2.528C435.89,198.487,435.63,198.515,434.123,198.619Zm-31.485-64.364a0.951,0.951,0,0,1,1.151-.281,0.98,0.98,0,0,0,1.2,0c0.765-.8,1.758-0.71,2.88.021a3.3,3.3,0,0,0,.756.248c-0.4.6-1.115-.191-1.6,0.013,0,0.134.01,0.267,0.017,0.46a11.7,11.7,0,0,1-4.42-.55Zm34.255,24.821c-1.92-.522-3.629-0.974-5.324-1.468a0.683,0.683,0,0,1-.389-0.534,0.708,0.708,0,0,1,.618-0.215q2.315,0.739,4.593,1.564A2.007,2.007,0,0,1,436.893,159.076Zm-506.672-56.15a1.693,1.693,0,0,1-.789.434,14.277,14.277,0,0,1-5.67-1.885,8.521,8.521,0,0,1,1.206.082c1.757,0.471,3.509.96,5.263,1.443Zm460.138,47.5,1.534,0.882c-2.01.649-2.15,0.655-3.8,0.125Zm23.383-14.683a3.9,3.9,0,0,1-2.906.061,0.789,0.789,0,0,1-.492-0.486,0.71,0.71,0,0,1,.386-0.624,3.775,3.775,0,0,1,2.9.482l0-.051,0.129,0.7S413.742,135.744,413.742,135.744Zm-3.228,71.1a26.606,26.606,0,0,1,2.682-.079,4.918,4.918,0,0,1,1.374.689l-1.744,1.1-2.319-1.792ZM309.289,45.241a4.181,4.181,0,0,1,2.74,1.118,2.194,2.194,0,0,1-2.183.38C308.99,46.517,308.81,46.066,309.289,45.241Zm-39.737,8.751a2.818,2.818,0,0,1-2.739.352,6.894,6.894,0,0,1-2.323-1.12,7.761,7.761,0,0,1,1.174.048c1.3,0.244,2.592.529,3.888,0.8V53.992ZM30.059,0.719a16.975,16.975,0,0,1-2.09.739,1.431,1.431,0,0,1-.943-0.37,0.573,0.573,0,0,1,.042-0.7C27.8-.24,28.259-0.2,30.059.719Zm-63.59,60.832c1.987-.4,2.693.863,4.415,1.65a6.375,6.375,0,0,1-1.549-.087C-31.571,62.667-32.433,62.159-33.531,61.551Zm404.81,220.725c-1.281.011-2.56,0.033-3.845,0.022a9.617,9.617,0,0,1-1.3-.229,3.71,3.71,0,0,1,1.918-.43c0.518-.089,1.017-0.216,1.64-0.351l1.583,0.975Zm51.3-77.555a5.392,5.392,0,0,1-4.269.157A6.11,6.11,0,0,1,422.575,204.721ZM238.607,57.615A6.36,6.36,0,0,1,241.14,58c-0.465.625-.458,0.644-2.222,0.392-0.1-.267-0.2-0.548-0.3-0.829Zm70.04,7.911a0.54,0.54,0,0,0-.167.137,0.741,0.741,0,0,1-1.219.193,1.589,1.589,0,0,1,.013-0.993l1.393,0.739Zm33.284-10.389a1.455,1.455,0,0,1,2.206-.007,0.323,0.323,0,0,1,.087.361,0.538,0.538,0,0,1-.437.15c-0.64-.157-1.271-0.355-1.9-0.538Zm63.5,55.972-1.486.064c-0.024-.44-0.047-0.859-0.073-1.337,0.9,0.319,1.53.621,1.511,1.294ZM364.7,281.564a3.949,3.949,0,0,1-.943.21,1.579,1.579,0,0,1-.544-0.392,1.186,1.186,0,0,1,.549-0.233,5.6,5.6,0,0,1,.951.483ZM368.983,96.6c0.351,0.168.68,0.3,0.964,0.474a0.359,0.359,0,0,1,.158.346,0.668,0.668,0,0,1-.488.1C369.082,97.39,368.808,97.118,368.983,96.6Zm46.494,25.547,1.756,0.535c0.034,0.459-.257.61-0.636,0.387a7.633,7.633,0,0,1-1.134-.969ZM335.269,279.828c-0.082-.289-0.133-0.467-0.183-0.644a2.9,2.9,0,0,1,.69.081,0.427,0.427,0,0,1,.195.348A3.3,3.3,0,0,1,335.269,279.828Zm97.58-73.638c-0.36-.147-0.741-0.3-1.113-0.463a0.183,0.183,0,0,1,0-.172,1.847,1.847,0,0,1,.709-0.04,1.975,1.975,0,0,1,.6.411A1.213,1.213,0,0,1,432.849,206.19ZM-23.7,64.276a3.479,3.479,0,0,1,.7-0.241,0.735,0.735,0,0,1,.468.183,0.265,0.265,0,0,1,.011.335,0.7,0.7,0,0,1-.493.025,4.889,4.889,0,0,1-.7-0.4ZM398.55,152.247l1.992,0.669C399.586,153.033,399.586,153.033,398.55,152.247Zm-129-98.178c0.417,0.182.843,0.353,1.242,0.558a0.27,0.27,0,0,1-.024.322,0.665,0.665,0,0,1-.471-0.018c-0.279-.3-0.5-0.624-0.747-0.94V54.07ZM-64.271,105.085l-0.41-.2a0.606,0.606,0,0,1,.135-0.142,4.484,4.484,0,0,1,.416.192ZM416.714,205.8l-1.751-.147c0.7-.338.7-0.338,1.692,0.185Zm35.511-43.29-0.325-.438a2.766,2.766,0,0,1,.683.024,0.8,0.8,0,0,1,.232.355Zm-23.142-6.019-0.183-.169a1.223,1.223,0,0,1,.439-0.056,0.771,0.771,0,0,1,.256.275ZM-1.657,71.894c0.625,0.066.9,0.229,0.849,0.553a0.735,0.735,0,0,1-.293.264ZM-69.77,103l1.715,0.591a2,2,0,0,1-1.724-.665ZM329.59,50.4a0.334,0.334,0,0,1-.12.135,0.754,0.754,0,0,1-.239-0.008,0.95,0.95,0,0,1,.154-0.2A0.9,0.9,0,0,1,329.59,50.4ZM397.7,109.088c-0.075-.111-0.15-0.223-0.224-0.335a0.678,0.678,0,0,1,.259.029,1.984,1.984,0,0,1,.233.334Zm64.577,108.634a2.707,2.707,0,0,1-.133.341,1.725,1.725,0,0,1-.187.247,1.082,1.082,0,0,1-.361-0.251,0.281,0.281,0,0,1,.187-0.268,1.744,1.744,0,0,1,.49-0.03Zm-48.191-82.25a1.872,1.872,0,0,1,.376.348,0.543,0.543,0,0,1-.03.331,1.52,1.52,0,0,1-.243-0.1c-0.154-.1-0.3-0.206-0.444-0.31l0.02,0.083,0.4-.355h-0.082Zm-148.717,134.7a0.459,0.459,0,0,1-.139.089c-0.152-.067-0.294-0.149-0.439-0.227l0.235-.162C265.138,269.973,265.252,270.074,265.366,270.174ZM-78.144,101.145a2.253,2.253,0,0,1,.522-0.056,0.781,0.781,0,0,1,.266.234,1.161,1.161,0,0,1-.266-0.026c-0.18-.059-0.353-0.135-0.528-0.2Zm463.45,53.013,1.341-.075c-0.535.671-.951,0.151-1.359-0.013ZM326.384,278.069c0.167,0.053.336,0.1,0.5,0.162a0.985,0.985,0,0,1,.2.138,0.674,0.674,0,0,1-.263.006,3.494,3.494,0,0,1-.387-0.3ZM57.476,231.908a0.689,0.689,0,0,1-.164-0.069,0.419,0.419,0,0,1,.072-0.146l0.275,0.123Zm342.267-77.716-0.411.17c-0.054-.363.324-0.009,0.433-0.1ZM253.119,60.142c-0.184-.044-0.371-0.08-0.551-0.136a0.9,0.9,0,0,1-.215-0.139,0.969,0.969,0,0,1,.385,0,2.1,2.1,0,0,1,.4.339Zm-3.411-.757,0.072-.315c-0.027.094-.053,0.187-0.08,0.281Zm-288.5,120.164,0.229,0.337a0.681,0.681,0,0,1-.246,0,2.205,2.205,0,0,1-.236-0.326Zm277.4-121.984-0.305.229,0.3-.179ZM210.542,43.754l-1.1-.276,0.023,0.068a1.129,1.129,0,0,1,1.1.246Zm-2.058-.312-0.2-.069,0.207,0.142Zm81.193,234.286-0.132-.177H289.9a0.258,0.258,0,0,1,.013.18A0.591,0.591,0,0,1,289.677,277.728ZM20.79,17.592l0.191,0.05-0.2-.112ZM-98.819,150.481l0.456,0.064a0.607,0.607,0,0,1-.192.018,1.55,1.55,0,0,1-.253-0.107Zm491.1,72.359-0.222-.041c0.013-.068.027-0.135,0.04-0.2a0.661,0.661,0,0,1,.191.1A0.2,0.2,0,0,1,392.279,222.84ZM73.216,232.7l-0.478-.376,0.2-.075,0.191,0.461Zm252.5,48.087-0.429.1c0-.089-0.011-0.178-0.016-0.268l0.455,0.218ZM-41.831,129.243c-0.014.039-.029,0.077-0.044,0.115a1.02,1.02,0,0,1-.2-0.089,0.205,0.205,0,0,1,.039-0.112Zm394.818-48.7a0.524,0.524,0,0,1-.176-0.082,0.329,0.329,0,0,1,.059-0.161l0.3,0.137Zm23.17,21.865,0.088,0.136-0.184-.073Zm29.1,28.475a0.847,0.847,0,0,1-.245-0.089,0.288,0.288,0,0,1-.046-0.159C405.05,130.713,405.139,130.788,405.253,130.885ZM341.882,55.1a0.536,0.536,0,0,0-.155-0.152,0.418,0.418,0,0,0-.191.053l0.395,0.133Zm-80.414-1.736c-0.037-.049-0.075-0.1-0.113-0.145l0.325,0.007L261.7,53.4Zm-303.842,66.3-0.188-.049,0.172,0.071ZM67.192,232.993a1.367,1.367,0,0,1-.222-0.015,0.24,0.24,0,0,1-.083-0.082l0.317,0.177ZM-78.953,155.837l0.132,0.074-0.1-.1Zm0.032-.023-0.2-.046,0.165,0.069Zm-19.887-5.358-0.179-.044,0.168,0.069ZM405.378,111.13l0.036,0.121,0.012-.142ZM324.314,67.545l0.118,0-0.112-.027Zm0.006-.029-0.184-.039,0.178,0.068Zm90.153,67.594,0.184,0.04-0.207-.116Zm-0.023-.076q-0.185.218-.367,0.437h0.082l-0.531-.346,0,0.051,0.843-.066Zm-24.13-6.488c0.392-.12.584-0.071,0.415,0.283h0.084l-0.5-.33v0.046Zm0.415,0.283,0.553,0.4s-0.024-.114-0.024-0.114l-0.445-.289h-0.084ZM280.645,58.921c0.007-.053.013-0.106,0.019-0.159-0.013.035-.028,0.069-0.041,0.1Zm1.774,1.776-0.008-.068Zm-17.627.145,0.04-.1,0.1,0.082ZM201.7,20.418l0.163-.016-0.17-.035Zm-0.007-.052-0.181.029,0.188,0.023ZM258.023,58.44l0.009,0.075Zm141.742,95.822,0.146,0.1-0.168-.169ZM249.7,59.351l-0.053.148,0.061-.114ZM212.327,43.835l0.208-.007-0.219-.046Zm-0.011-.053-0.8-.039-0.02.046,0.829,0.047ZM389.931,163.055l-0.055-.1-0.042.1h0.1ZM211.518,43.742l-0.976.012,0.025,0.038c0.419,0.477.689,0.295,0.931,0ZM238.352,261.9l-0.939-.009,0.048,0.077q0.2-.185.395-0.372H237.8l0.546,0.362ZM209.442,43.478l-0.958-.036,0.006,0.073,0.975,0.031ZM462.27,217.761l0.158,0.033-0.154-.072Zm-32.147-21.023,0.184,0.046-0.216-.075Zm-13.468,9.1,0.16-.1-0.1.059Zm-15.933,12.339-0.352.335,0.033,0.04,0.383-.36ZM-32.185,65.934l-0.373.042a0.288,0.288,0,0,1,.137-0.087,1.124,1.124,0,0,1,.246.1Zm0.01,0.06,0.2-.05-0.213-.01ZM385.174,226.8l-0.008-.068ZM-21.634,66.726l0.142,0.1c-0.013-.072-0.026-0.144-0.038-0.217l-0.1.1Zm422.18,187.119,0.168,0.055-0.112-.058Zm0.056,0-0.251.04,0.15,0.089,0.045-.126ZM1.82,79.642l0.012,0.072Zm19.316-56.7-0.154.082,0.14-.025Zm304.586,257.9,0.324-.022a0.279,0.279,0,0,1-.128.058,1,1,0,0,1-.206-0.089Zm45.555,1.421c0.123,0,.246.009,0.37,0.012a0.277,0.277,0,0,1-.135.092,0.891,0.891,0,0,1-.233-0.091Zm-6.565-.631,0.156-.068H364.7Zm-38.282-3.56-0.269,0,0.155,0.113,0.068-.112Zm-334.8-91.337a11.279,11.279,0,0,1,3.067,1.014,1.4,1.4,0,0,1-1.848.16,7.417,7.417,0,0,1-1.235-1.248Zm-0.015-.074c-0.453-.025-0.905-0.047-1.359-0.081a0.235,0.235,0,0,1-.064-0.175,0.226,0.226,0,0,1,.159-0.12c0.43,0.142.853,0.3,1.279,0.45Zm349.1,61.994a4.95,4.95,0,0,0-3.191-1.487,12.038,12.038,0,0,1-1.68-.321,0.615,0.615,0,0,1-.391-0.307,0.579,0.579,0,0,1,.177-0.547,1.637,1.637,0,0,1,.954-0.213c1.832,0.287,3.661.628,5.722,0.991l-1.728,1.883h0.137Zm-13.548-3.1,0.081-.086-0.088.018ZM16.129,52.856c1.847-.368,1.847-0.368,3.027.84-1.13.258-2.019-.465-2.991-0.679Zm-0.1,2.351a0.25,0.25,0,0,1-.117.085,0.822,0.822,0,0,1-.21-0.08l0.2-.157Z"/>
                                </svg>
                                <svg class="item--shape-gradient" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="270" height="160" viewBox="0 0 270 160">
                                  <defs>
                                    <linearGradient id="team-shape1" x1="0%" y1="0%" x2="100%" y2="0%">
                                      <stop offset="0%" style="stop-color:<?php echo esc_attr($primary_color); ?>;stop-opacity:1" />
                                      <stop offset="100%" style="stop-color:<?php echo esc_attr($secondary_color); ?>;stop-opacity:1" />
                                    </linearGradient>
                                  </defs>
                                  <path fill="url(#team-shape1)" d="M38.6,34.81A4.906,4.906,0,0,0,34.248,33.3a8.767,8.767,0,0,0-5.479-2.66,4.266,4.266,0,0,1-1.63-.547,10.274,10.274,0,0,0-4.347-1.234,23.257,23.257,0,0,1-6.71-1.723,2.309,2.309,0,0,0-.536-0.208c-2.567-.466-4.911-1.617-7.479-2.131A33.221,33.221,0,0,1,2.78,23.293,21.082,21.082,0,0,0-2.5,22a23.9,23.9,0,0,1-8.98-2.773,10.474,10.474,0,0,0-2.154-.81,8.316,8.316,0,0,1-2.53-1.3l0.643-1.029c1.805-.412,3.84.867,5.641,0.029a1.986,1.986,0,0,0-.571-0.717,7,7,0,0,0-2.142-.677,26.126,26.126,0,0,1-4.875-1.173c-0.133-.669.437-0.784,0.83-0.68,2.3,0.612,4.663.53,6.983,1.561a59.777,59.777,0,0,0,7.437,2.349,62.166,62.166,0,0,0,6.965,1.963,4.72,4.72,0,0,1,1.073.526A13.406,13.406,0,0,1-1.3,17.7l-1.9.192a2.621,2.621,0,0,0-.136,1.073,1.623,1.623,0,0,0,.727.911,5.093,5.093,0,0,0,2.761.616,3.553,3.553,0,0,1,2.177.526,4.911,4.911,0,0,0,2.736.694,15.5,15.5,0,0,1,4.808.79c1.913,0.55,2.137.438,2.838-.94a2.489,2.489,0,0,1,.283-0.357c1.2,0.215,2.429.377,3.626,0.681a6.744,6.744,0,0,1,1.574,1.019c-0.665.126-1.053,0.226-1.462,0.273-0.792.089-.789,0.088-0.505,1.107,0.915,0.044,1.845.032,2.774,0.148,0.9,0.113,1.514,1.127,2.778.758l-0.64-2.254-0.014.056a3.087,3.087,0,0,0,1.671-.548,3.094,3.094,0,0,1,2.668-.007,10.391,10.391,0,0,1,2.561,1.188c1.618,1.266,2.513,1.31,4.24.373a0.852,0.852,0,0,1,.969-0.052,3,3,0,0,0,1.9.453,3.68,3.68,0,0,1,2.649.837,8.82,8.82,0,0,0,3.9,1.619c2.079,0.411,4.131,1,6.208,1.437,1.11,0.231,2.263.207,3.371,0.445a15.812,15.812,0,0,1,3.006.978,51.161,51.161,0,0,0,5,1.369,4.926,4.926,0,0,0,1.4.2A14.066,14.066,0,0,1,67.087,32.4a1.871,1.871,0,0,0,.835.2c1.936-.089,3.758.8,5.667,1.011s3.809,0.54,5.71.861c1.033,0.174,2.067.406,3.087,0.664,1.778,0.452,3.544.954,5.321,1.414a5.386,5.386,0,0,0,1.7.308c2.664-.284,5.23.627,7.851,1.122a22.934,22.934,0,0,1,6.106,1.588c2.178-.018,4.307.73,6.47,1.011,2.854,0.371,5.711.819,8.556,1.327a25.544,25.544,0,0,1,4.188,1.109,18.563,18.563,0,0,0,2.487.683c1.281,0.275,2.613.274,3.784,1.151a8.176,8.176,0,0,0,2.452.7l0.06,0.142-0.127-.142c1.089,0.13,1.944-.343,2.927-0.347s2.081,0.482,3.1.538c2.285,0.123,4.531.73,6.8,0.984a48.358,48.358,0,0,1,7.327,1.559l1.845-1.1c0.376,0.628.476,1.252,1.4,1.41a3.736,3.736,0,0,0,1.338.085,9.565,9.565,0,0,0,1.571-.644l4.31,1.165,0.5,1.041c0.659-.09,1.262-0.137,1.825-0.255a7.274,7.274,0,0,1,5.167.821l-0.366.913c0.011,0.059.021,0.117,0.032,0.175l-0.142-.177c0.132-.3.263-0.6,0.4-0.905,0.158-.231.315-0.462,0.516-0.755,1.624,0.307,3.219.576,4.8,0.914a52,52,0,0,0,7.341,1.041c2.185,0.148,4.275.878,6.447,1.036,1.589,0.116,3.2.552,4.805,0.773a40.331,40.331,0,0,0,4.5.444,20.958,20.958,0,0,1,4.539.774,10.14,10.14,0,0,0,4.493.535,0.959,0.959,0,0,1,.555.025,4.487,4.487,0,0,0,3.514.121,2.974,2.974,0,0,1,2.409.407,5.19,5.19,0,0,0,3.224.932,5.992,5.992,0,0,1,1.392.321,21.99,21.99,0,0,0,3.666.793c3.982,0.182,7.971,1.324,11.946,1.316a7.809,7.809,0,0,1,2.233.485,26.051,26.051,0,0,0,5.94,1.148c2.351,0.183,4.731.77,7.055,0.551a2.3,2.3,0,0,1,.845.167c2.65,0.884,5.21.715,7.761,0.619,0.215-.357-0.119-0.581-0.455-0.733-1.213-.547-2.445-1.064-3.67-1.592l0.014,0.059a1.086,1.086,0,0,1,.415-0.621c0.754-.128,1.611.385,2.412,0.085A14.6,14.6,0,0,1,258,59.228c0.008-.254.017-0.521,0.026-0.788l0.009,0.075c0.818,0.265,1.646.506,2.45,0.8,0.86,0.316,1.7.68,2.617,1.053a1,1,0,0,1-.407.454c-0.517.1-1.09,0.1-1.63,0.157a2.512,2.512,0,0,0-1.945.826,1.254,1.254,0,0,0,.387.366,10.311,10.311,0,0,1,3.733,1.361,2.772,2.772,0,0,0,1.6.374,8.466,8.466,0,0,1,3.926.445,2.272,2.272,0,0,0,2.331-.32c-0.574-1.1-2.1-1.535-3.409-2.434,1.416-.232,2.388-0.681,3.874-0.321a15.086,15.086,0,0,0,3.389.143c0.493,0,.982-0.174.876-0.577a1.623,1.623,0,0,0-.8-0.868,10.976,10.976,0,0,0-1.922-.59c-0.819-.212-1.647-0.393-2.566-0.61,0.18-.269.293-0.44,0.436-0.652a14.737,14.737,0,0,1,2.168.649c1.75,0.834,3.51.45,5.258,0.711a5.98,5.98,0,0,0,2.244-.561l-0.022-.055a4.006,4.006,0,0,0,1.8,1.83l-0.008-.068a2.808,2.808,0,0,1-.926.264c-0.933-.051-1.888-0.245-2.812-0.261a5.4,5.4,0,0,0-1.439.346,1.873,1.873,0,0,0,1.85,1.378c1.136,0.192,2.276.327,3.412,0.519a14.189,14.189,0,0,1,3.819,1.092c0.054,0.546-.441.384-0.77,0.319A24.513,24.513,0,0,0,278.164,64c0.106,0.393.2,0.726,0.249,0.924a26.321,26.321,0,0,0,5.54,1.629,100.151,100.151,0,0,0,9.963,1.459,3.228,3.228,0,0,1,1.345.292c1.441,1.1,2.85.8,4.276,0.57a4.347,4.347,0,0,0,.734-0.235,5.54,5.54,0,0,1,3.044.1c1.126,0.258,1.808-.094,2.089-0.911l8.2,0.337c0.22-.5-0.132-0.828-0.753-1.032a6.566,6.566,0,0,0-1.406-.352,5.273,5.273,0,0,1-2.8-1.257l0.02,0.076a7.128,7.128,0,0,1,1.8-.238c2.184,0.254,4.37.6,6.553,0.924a10.316,10.316,0,0,1,1.069.272c0.346,0.945-1.014.823-1.317,1.515,0.217,0.488.493,1.1,0.731,1.638a11.8,11.8,0,0,0,4.282,1.023c0.13,0.139.337,0.381,0.57,0.61a1.593,1.593,0,0,0,1.764.475c1.325-.593,2.764-0.107,4.084.292,2.6,0.789,5.284.874,7.883,1.576a0.609,0.609,0,0,0,.283.024c2.164-.624,4.637,0,6.922-0.129,0.778-.043.945-0.175,1.556-1.166a19.8,19.8,0,0,0-4.125-.937,8.554,8.554,0,0,1-4.386-1.064,5.29,5.29,0,0,0-1.928-.486c-1.327-.162-2.655-0.243-3.983-0.363-0.962-.088-0.962-0.093-2.132-1.206a5,5,0,0,1,1.363-.123c1.7,0.335,3.389.538,5.088,0.7a6.144,6.144,0,0,1,1.415.259,8.236,8.236,0,0,0,4.957.48,4.763,4.763,0,0,1,2.5.41,10.845,10.845,0,0,0,1.916.529,7.771,7.771,0,0,1,3.674,1.394c0.358,0.84-.773,1.118-0.96,1.9,0.665,0.619,1.358,1.346,2.168,1.993,0.738,0.59,1.6,1.092,2.412,1.632-0.107.615-.854,0.6-1.421,0.737a0.8,0.8,0,0,0-.756.717c-0.032.593,0.6,0.694,1.128,0.888a1.511,1.511,0,0,1,.278.23l-2.4.829a1.462,1.462,0,0,0,1.461,1.129,7.8,7.8,0,0,1,3.36,1.459c0.812,0.473.831,1.184-.082,1.281-1.066.113-1.072,0.551-.946,1.144a10.518,10.518,0,0,0,.408,1.212c-0.961,1.305-2.786.762-4.4,0.8l-0.54.858-0.02-.068c0.485,0.394.952,0.8,1.465,1.174a4.433,4.433,0,0,0,.836.353c0.248,0.9.5,1.807,0.738,2.678,1.935,0.549,1.935.549,2.6-.3,0.867,0.066,1.809.121,2.752,0.214a4.077,4.077,0,0,1,2.792,1.058,5.883,5.883,0,0,0,2.048.942c1.153,0.408,2.336.752,3.593,1.15a9.325,9.325,0,0,1,.79,1.635c0.313,1.2.262,1.2,1.42,1.518a22.371,22.371,0,0,1,5.719,1.9c0.2,0.119.36,0.279,0.91,0.713-1.368-.309-2.263-0.549-3.167-0.707a9.964,9.964,0,0,0-4.191-.227c-0.723.189-1.3,0.707-.95,1.248,0.51,0.791.238,1.728,1.3,2.4a0.38,0.38,0,0,1,.166.189,3.566,3.566,0,0,0,2.539,2.617,11.658,11.658,0,0,0,3.858,1.1,5.746,5.746,0,0,1,3.043.972c0.158,1-.12,2.026.628,3.11,0.24,0.347-.223.9-0.4,1.457,1.26,0.784,1.182,1.92,1.725,2.929a1.462,1.462,0,0,0,1.249.964c0.519-.6-0.457-1.546.288-2.1,0.676-.507,1.336-1.026,2.1-1.617,1.521,0.607,3.287.466,4.856,1.31a3.382,3.382,0,0,1,1.327.879,6.9,6.9,0,0,0,2.628,1.9,2.816,2.816,0,0,0,1.919.358,7.639,7.639,0,0,1,4.665.614,7.184,7.184,0,0,0,5.253.459c1.86,0.792,3.523,1.51,5.2,2.209a3.137,3.137,0,0,0,2.192.283,9.944,9.944,0,0,1,4.686.026l-0.014-.047-2.057.877c-0.482,1.469-.482,1.469-2.92,1.977-1.338-.909-2.986-0.752-4.562-0.914a8.525,8.525,0,0,1-3.294-.842c-1.367-.736-2.858-0.641-4.3-0.805a0.82,0.82,0,0,0-1.017.945c0.224,0.554.562,1.095,0.823,1.592a0.642,0.642,0,0,1-.977.088c-0.765-.7-1.468-1.443-2.227-2.2a29.57,29.57,0,0,1-2.938-.738c-1.31-.464-2.227-0.414-2.82.471a2.35,2.35,0,0,1-.673.407c-0.8-.193-1.637-0.366-2.457-0.6-0.731-.212-1.438-0.5-2.246-0.782l-3.273.868c0.347,1.525,2.191,2.347,3.171,3.521,1.049,1.258,2.685,1.828,4.255,2.5l-0.022.113-0.072-.114a4.206,4.206,0,0,1,2.462.077V128.5c-0.369.352-.766,0.689-1.1,1.062a1.153,1.153,0,0,0,.363,1.557,2.673,2.673,0,0,0,1.313.357,1.083,1.083,0,0,0,1.1-1.17,5.777,5.777,0,0,0-.733-1.187l0.025,0.114,2.5-1.275a4.081,4.081,0,0,1,2.179,1.587,7.263,7.263,0,0,0,5,3.336,1.785,1.785,0,0,1,1.663,1.373l-0.017-.091c-1.512.115-2.835,0.433-3.526,1.483a1.7,1.7,0,0,1-.573.342c-0.735-.087-1.424-0.164-1.528-0.866-0.152-1.024-.827-1.628-2.451-1.653l-0.732,1.668c-0.555.244-1.159,0.507-1.755,0.779a0.383,0.383,0,0,0-.117.173,6.109,6.109,0,0,0,2.933,1.607c1.12,0.051,2.226.008,3.523,0,0.351,0.234.819,0.527,1.255,0.843,0.755,0.548,1.442,1.1,2.53.682a2.631,2.631,0,0,1,1.339.326,13.112,13.112,0,0,1,1.476.825,13.3,13.3,0,0,0,6.385,2.16,38.714,38.714,0,0,1,4.238.729c4.176,0.662,8.358,1.272,12.5,2.212a13.165,13.165,0,0,1,2.5.737,24.286,24.286,0,0,0,4.686,1.382,16.166,16.166,0,0,1,3.237,1.094,16.141,16.141,0,0,0,2.954,1.1c0.923,0.238,1.814.6,2.718,0.906a5.673,5.673,0,0,0,.807.292c0.839,0.145,1.817,0,2.452.621,1.1,1.079,2.757,1.882,3.287,3.347l-0.923,1.058a1.813,1.813,0,0,1-.562-0.051,5.357,5.357,0,0,1-2.071-1.589,11.335,11.335,0,0,0-4.158-2.929,15.551,15.551,0,0,0-7.815-1.579l-0.6.683c-1.335-.424-2.809-0.273-4.146-0.989a2.63,2.63,0,0,0-1.071-.1,12.858,12.858,0,0,1-5.464-1.289,2.622,2.622,0,0,0-1.041-.313,18.73,18.73,0,0,1-5.37-.718,46.242,46.242,0,0,0-8.246-1.148,36.8,36.8,0,0,1-5.343-.866c-1.853-.436-3.59-1.357-5.525-1.414-0.96-.909-2.31-0.759-3.473-1.028a23.045,23.045,0,0,0-7.6.19c-0.665.141-.553,0.7-0.928,0.839-1.954.735-2.23,2.476-3.633,3.536-0.511.387,0.034,1.169,0.875,1.358,0.751,0.167,1.518.259,2.4,0.4,0.043,0.425.074,0.829,0.127,1.234,0.055,0.423.132,0.847,0.187,1.195-0.582.8-1.851,0.589-2.748,1.037-0.016.807,0.94,1.194,1.672,1.679l-0.018-.088c-0.808.536-2.055-.213-3,0.255-0.394.832,1.366,1.883,0.243,2.8-0.92-.866-2.058-0.631-3.137-0.682a1.051,1.051,0,0,0-1.318.994,6.546,6.546,0,0,0,.276,1.208c-0.5.525-1,.975-1.4,1.481a1.016,1.016,0,0,0,.839,1.436c1.206,0.334,2.425.651,3.65,0.893,1.615,0.318,2.114.186,3.8-.777,1.253,1.327,3.088.952,4.689,1.374h-0.1c0.689,0.283,1.392.547,2.057,0.865a0.918,0.918,0,0,1,.262.466,0.9,0.9,0,0,1-.278.172c-0.522-.195-1.037-0.406-1.693-0.667a12.366,12.366,0,0,0-1.212.577c-0.467.282-.87,0.62-1.308,0.928a4.445,4.445,0,0,1-4.445.585,1.337,1.337,0,0,0,.385-1.861,0.962,0.962,0,0,0-1.15-.314,1.263,1.263,0,0,0-.457.828c-0.038.657,0.791,0.952,1.36,1.347a11.855,11.855,0,0,1-1.14.432c-0.5.137-1.064,0.175-1.535,0.341-0.776.274-.729,0.89,0.033,1.365a4.4,4.4,0,0,0,3.22.793c0.525-.1,1.053-0.187,1.666-0.3,0.905,0.8,1.923,1.574,3.412,1.114,1.193,0.291,2.4.538,3.575,0.885a10.048,10.048,0,0,0,3.659.371,51.156,51.156,0,0,1,6.814.387c1.03,0.069,2.067.158,3.1,0.205,2.816,0.129,5.64.324,8.46,0.48a5.574,5.574,0,0,0,1.668-.018,3.2,3.2,0,0,1,2.193.194,12.565,12.565,0,0,0,5.352.729,36.849,36.849,0,0,1,4.915.4l2.591,2.306c-0.322,1.209-1.159,1.949-3.1,1.882a20.157,20.157,0,0,1-3.4-.242,57.507,57.507,0,0,0-12.781-.819,37.686,37.686,0,0,1-5.88-.153,37.784,37.784,0,0,0-4.231-.067,15.54,15.54,0,0,1-2.552-.125,61.922,61.922,0,0,0-11.082-.745,12.854,12.854,0,0,1-3.627-.432c-1.775-.5-3.606-0.565-4.883.422,0.018,0.89,1.228.712,1.64,1.2l-0.764,1.093c0.79,0.46,1.521.851,2.2,1.292a2.886,2.886,0,0,0,3.14.283,3.628,3.628,0,0,1,3.151-.176,27.944,27.944,0,0,0,4.818.875,50.912,50.912,0,0,1,5.923,1.126,8.005,8.005,0,0,0,1.9.332c1.22,0.026,2.474.24,3.7,0.29,1.419,0.057,2.829.046,4.232,0.02a29.134,29.134,0,0,1,7.594.76,5.928,5.928,0,0,0,1.133.2c3.773,0.161,7.6.926,11.355,0.771a6.474,6.474,0,0,1,3.8.965,11.974,11.974,0,0,0,3.3.823c0.329,0.635-.829.484-0.958,0.946a4.411,4.411,0,0,1-.775,1.122l-9.556-.207a4.185,4.185,0,0,0-1.377-.008,4.377,4.377,0,0,1-2.457-.036,8.508,8.508,0,0,0-3.888,0,4.05,4.05,0,0,1-2.5-.13,5.3,5.3,0,0,0-1.944-.3c-1.57.115-3.2-.819-4.758-0.312-1.361.442-2.98,0.051-4.489-.047-1.322-.087-2.665-0.385-3.991-0.494-1.615-.133-3.234-0.219-4.828-0.223a2.531,2.531,0,0,1-2.045-.655,2.8,2.8,0,0,0-2.033-.791c-2.468-.226-4.939-0.489-7.408-0.717-0.953-.088-1.9-0.077-2.855-0.187a7.209,7.209,0,0,0-4.681.644,10.138,10.138,0,0,1-1.5.35,3.631,3.631,0,0,0-.852.579,2.311,2.311,0,0,0,.426.5c1.172,0.669,2.6.789,3.8,1.3a10.817,10.817,0,0,0,3.876.948,2.028,2.028,0,0,1,.846.115c1.369,0.852,2.755.521,4.024,0.524a3.028,3.028,0,0,1,.609.323,11.918,11.918,0,0,0,4.927,2.9,12.492,12.492,0,0,0,3.568.843c1.02,0.036,2.065.24,3.078,0.366,1.053-.306.887-1.249,1.484-1.911,3.143,0.753,6.192.147,9.345,0.9a5.435,5.435,0,0,0,1.7.047,9.168,9.168,0,0,1,2.817.208,12.4,12.4,0,0,0,3.957.152c1.134-.113,1.582.07,3.241,1.018a8.847,8.847,0,0,1-1.146.088c-1.805-.1-3.613-0.236-5.417-0.339a7.68,7.68,0,0,0-2.242-.018,8.362,8.362,0,0,1-4.441-.126,1.564,1.564,0,0,0-.828-0.021,2.011,2.011,0,0,0-.918.61c-0.185.283,0.485,0.81,1.093,0.934a2.255,2.255,0,0,0,.567.092,11.866,11.866,0,0,1,4.194.774l0.02,0.116-0.084-.128,2.2,0.377-0.057.135-0.014-.139a4.643,4.643,0,0,1,1.283-.049,7.015,7.015,0,0,0,2.707.11l0.073,0.115,0.031-.114a11.623,11.623,0,0,1,4.434.257c2.336,0.876,4.632.7,6.938,1.055l-0.032-.029a5.787,5.787,0,0,1-4.165.979,9.181,9.181,0,0,0-2.754.162,4.4,4.4,0,0,1-2.765-.268,9.887,9.887,0,0,0-3.627-.739,15.54,15.54,0,0,1-5.321-.878,0.688,0.688,0,0,0-.281-0.056c-2.389.083-4.926-.216-7,0.667a1.162,1.162,0,0,0-.37.509l-0.111-.04,0.1-.009a0.8,0.8,0,0,1-.121.569c-1.5.545-1.087,1.629-.557,2.54a2.9,2.9,0,0,0,3.089,1.326,7.054,7.054,0,0,0,4.714,2.636c-0.425.4-.728,0.665-1,0.948-0.642.665-.588,0.813,0.59,1.786l-0.007-.08c-0.97.534-1.717,1.132-.948,2.268,0.381,0.562-.344.883-0.35,1.352a1.248,1.248,0,0,0,.418.98,2,2,0,0,0,1.307.251,13.114,13.114,0,0,0,1.954-.83,2.127,2.127,0,0,1,1.488,1.664,2.332,2.332,0,0,1-2.522.791,8.323,8.323,0,0,0-1.991-.133c-1.338.062-1.816,0.675-1.458,1.712a4.1,4.1,0,0,1,.361,1.255,1.165,1.165,0,0,1-.5.878,3.282,3.282,0,0,1-1.186.077c-0.17.47-.355,0.979-0.541,1.492a2.744,2.744,0,0,1-.773.195,4.9,4.9,0,0,1-1.695-.191,7.2,7.2,0,0,0-3.352-.349l0.064,0.015a3.6,3.6,0,0,0-.5-0.19,1.169,1.169,0,0,0-.359.03,1.021,1.021,0,0,0,.117.184c0.113,0.116.242,0.224,0.364,0.336l-0.033-.04c-0.671.432-.426,0.966,0.066,1.573,1.317,0.554,2.964-.482,4.215.9-0.3.4-.949,0.154-1.416,0.2a6.914,6.914,0,0,1-1.382-.11c-1.515-.159-3.03-0.306-4.545-0.49-1.6-.193-3.038-0.13-3.981.912a19.844,19.844,0,0,0-5.978-.967,4.424,4.424,0,0,0-3.462.848,0.79,0.79,0,0,0-.169.742,1.093,1.093,0,0,0,1.006.735c0.638,0.064,1.274.115,2.022,0.182,0.084,0.6.15,1.079,0.238,1.712a10.18,10.18,0,0,1-1.748.278c-1.565,0-1.827-.259-1.925-1.594a3.169,3.169,0,0,0-.288-0.711c-0.929.2-1.777,0.364-2.609,0.557a3,3,0,0,1-.967.3c-1.621-.268-2.248.618-3.173,1.173a1.1,1.1,0,0,0,1.024,1.193,3.286,3.286,0,0,0,.831.24c2.154-.017,4.388.834,6.51,0.458a1.622,1.622,0,0,1,.535.149l-0.008-.068a2.656,2.656,0,0,1-2.054,1.423c-0.785-.2-1.615-0.452-2.457-0.615a5.328,5.328,0,0,0-3,.107,2.678,2.678,0,0,1-1.235.34c-2.684-.366-5.111.381-7.807,0.034-0.756.5-1.48,1.052-1.3,2.009,0.964,1.034,2.186.884,3.386,0.823l0.115,0.13,0.062-.129,4.425,2.035c-0.653.372-1.147,0.615-1.577,0.909s-0.315.791,0.193,1.127c1.343,0.889,3.637,1.393,4.534-.134,0.386-.657,1-0.8,2.1-0.717-0.344.434-.627,0.789-0.976,1.228l2.39,2.2a3.415,3.415,0,0,1-.927.367,11.038,11.038,0,0,1-2.5.07,2.7,2.7,0,0,0-1.459.362c-0.671.187-.507,0.583-0.371,1.039a0.907,0.907,0,0,1-.324.745,2.258,2.258,0,0,0-.244,2.305,19.441,19.441,0,0,0,3.4,1.08c1.125,0.16,2.254.238,3.346,0.35,1.134,0.975.459,1.588-.263,2.329l-3.631-1.473a3.543,3.543,0,0,1-.739.886,2.2,2.2,0,0,1-1.171.32,6.548,6.548,0,0,1-1.382-.394c-1.511-.44-1.549-0.431-3.055.563,0.531,1.338,2.457.755,3.407,1.66-0.148.938-1.695,0.84-2.038,1.759-0.769-.374-1.331-0.657-1.9-0.924-1.471-.685-2.969-0.32-3.244.8a1.61,1.61,0,0,0-.055.831,4.5,4.5,0,0,1-.409,2.9,6.738,6.738,0,0,0,1.593.6,12.764,12.764,0,0,0,3.1.013,13.368,13.368,0,0,1,7.046.572c1.316-.1,1.343-0.925,1.912-1.549l2.193-.085a3.048,3.048,0,0,1,.425.195c3.6,2.9,2.8,1.976,6.856,2.471,1.014-.407,2.023.438,3.029,0.377a18.952,18.952,0,0,1,3.042-.2,18.6,18.6,0,0,1,5.443.862c-0.216,1.343.937,2.724,0.723,4.243-2.44.271-4.909,0.634-7.524-.68a3.486,3.486,0,0,0-2.211-.323,7.926,7.926,0,0,0-1.088.124c-2.716.918-5.757,0.633-8.812,0.29-0.555-.062-1.112-0.211-1.667-0.319l-2.716-.526c-2.873,1.972-6.483,1.383-10.429.833a9.156,9.156,0,0,1-1.344.836,12.1,12.1,0,0,1-1.786.478c0.075,0.448.146,0.872,0.192,1.142l2.33,1.556a9,9,0,0,1-3.188.468q-1.54,0-3.088-.021c-0.512-.009-0.515-0.02-1.754-0.887l0.6-1.175a2.724,2.724,0,0,0-2.447-.7,3.176,3.176,0,0,1-2.408-.4,3.252,3.252,0,0,0-2.472-.333c-0.764.164-1.477,0.418-2.267,0.648a3.32,3.32,0,0,0,2.6,1.5,14.444,14.444,0,0,0,1.7.064,2.393,2.393,0,0,1,2.035.768,3.587,3.587,0,0,0,2.959,1.348c1.8,1.259,3.215,2.892,6.062,3.771-1.849.325-3.21-.381-4.558-0.488s-2.672-1.2-4.211-.527A4.291,4.291,0,0,0,361,269.72c1.554,0.288,2.688.818,2.709,2.024a2.071,2.071,0,0,1-1.9,2.349,3.813,3.813,0,0,0-.493.153c0.546,1.633.412,2.062-.969,2.836-0.558.312-1.174,0.57-1.746,0.869a13.188,13.188,0,0,0-1.241.726,3.289,3.289,0,0,0-.518.583c0.418,0.387.821,0.8,1.289,1.177,0.415,0.331.9,0.614,1.371,0.927-0.023.6-.554,0.78-1.263,0.753-0.854-.034-1.734-0.189-2.567-0.163a15.594,15.594,0,0,0-2.16.354,7.358,7.358,0,0,1-.983-0.558,3.8,3.8,0,0,0-3.431-.787,7.013,7.013,0,0,1-3.048-.074c-1.518-.282-3.055-0.405-4.583-0.617a13.676,13.676,0,0,1-1.354-.369c1.524-.609,2.874.018,4.311,0.095,0.087-.285.179-0.583,0.272-0.884a7.206,7.206,0,0,0-3.043-1.018c-1.616-.3-3.226-0.658-4.843-0.945-0.849-.151-1.709-0.2-2.563-0.3-1.238-.143-2.479-0.245-3.71-0.458a3.792,3.792,0,0,1-1.111-.715,2.676,2.676,0,0,1,2.717-.2,9.052,9.052,0,0,0,3.641.428c1.392,0.016,2.813.171,4.278,0.271,0.65-.337.475-0.931,0.343-1.5a1.244,1.244,0,0,0-1.412-.952c-1.537.167-3.241-.325-4.7,0.174a2.922,2.922,0,0,1-1.639.052,25.849,25.849,0,0,0-4.261-.578c-4.182-.64-8.356-1.1-12.533-1.459-2.19-.191-4.383-0.41-6.574-0.62a3.053,3.053,0,0,0-1.824.256,7.332,7.332,0,0,1-1.8.346c-0.512.1-1.008,0.231-1.557,0.359a4.166,4.166,0,0,1,.537,1.228,3.657,3.657,0,0,1-.4,1.229l3.033,1.342c-3.759.3-7.395-.284-11.043-0.254-0.3-.435-0.6-0.817-0.83-1.214a1.644,1.644,0,0,0-1.6-.82c-1.686.019-3.373,0.032-5.067,0.016a18.84,18.84,0,0,1-2.278-.154,74.923,74.923,0,0,1-8.292-1.225,3.936,3.936,0,0,0-.856-0.138c-3.45-.061-6.8-1.214-10.2-1.768a0.879,0.879,0,0,1-.175-0.27,15.825,15.825,0,0,1,6.354.3,7.876,7.876,0,0,0,2.544.33,4.2,4.2,0,0,1,1.363.283,7.372,7.372,0,0,0,1.9.583,22.674,22.674,0,0,1,5.387.73,1.357,1.357,0,0,0,.808-0.012c0.977-.854,2.667-0.653,3.884-1.136a0.6,0.6,0,0,0,.119-0.283c-1.34-.6-2.672-1.291-4.086-1.806a6.835,6.835,0,0,0-3.891-.126l0.033-.068L281.4,269.1a3.016,3.016,0,0,1-2.373-.63,5.541,5.541,0,0,0-2.868-1.056c-3.913-.765-7.78-0.612-11.68-1.187a14.667,14.667,0,0,1-3.644-.811,20.357,20.357,0,0,0-5.358-.975,18.485,18.485,0,0,1-4.184-.944,8.3,8.3,0,0,0-3.371-.612,2.747,2.747,0,0,1-2.072-.348,4.038,4.038,0,0,1-2.215-.169c-0.745-.124-1.5-0.245-2.231-0.426a1.556,1.556,0,0,0-1.477.146,4.075,4.075,0,0,1-1.572-.188l0,0.057L237.8,261.6h0.055q-0.2.188-.395,0.372l-0.048-.077-1.98-.281,0.051-.124-0.018.143c-0.448.048-.889,0.124-1.346,0.136a1.132,1.132,0,0,1-1.153-.567,0.888,0.888,0,0,0-.838-0.543c-2.639-.11-5.252-0.957-7.916-1.058a10.081,10.081,0,0,1-3.289-.883,16.521,16.521,0,0,0-4.173-.888c-3.146-.4-6.294-0.7-9.44-1.047a14.611,14.611,0,0,1-2.847-.4,31.929,31.929,0,0,0-5.974-.96c-1.613-.209-3.224-0.461-4.836-0.7-5.807-.855-11.615-1.687-17.42-2.58-2.087-.321-4.169-0.768-6.248-1.2a44.887,44.887,0,0,0-5.133-.792,32.214,32.214,0,0,1-4.223-.931c-0.743-.933-2.161-1.026-3.162-1.641a2.68,2.68,0,0,0-.75-0.392,46.979,46.979,0,0,1-5.79-1.681,31.781,31.781,0,0,0-5.665-1.047c-1.9-.3-3.823-0.431-5.693-0.855a25.577,25.577,0,0,0-3.4-.511c-1.043-.1-2.09-0.244-3.135-0.378a2,2,0,0,1-.831-0.172c-1.357-1.106-3.042-.937-4.609-1.246-2.177-.43-4.343-0.945-6.522-1.352-1.414-.263-2.843-0.389-4.265-0.59a5.945,5.945,0,0,1-1.685-.318,19.077,19.077,0,0,0-6.423-1.522,51.24,51.24,0,0,1-7.281-1.7,16.1,16.1,0,0,0-4.243-.526,13.284,13.284,0,0,1-4.2-.428c-2.393-.824-4.736-0.784-7.1-1.069a20.654,20.654,0,0,1-2.81-.538c-1.865-.486-3.783-0.783-5.684-1.117-1.7-.3-3.407-0.544-5.088-0.808-0.376.951-.376,0.951,0.925,1.367l-0.09.01a51.247,51.247,0,0,0,9.784,2.46,4.789,4.789,0,0,1,1.4.327c1.938,0.959,4.079,1.079,6.122,1.59a3.165,3.165,0,0,1,.566.062c1.862,0.959,3.9.959,5.875,1.329a4.725,4.725,0,0,1,1.082.614,5.492,5.492,0,0,1-3.432.139,22.235,22.235,0,0,1-2.212-.661,6.712,6.712,0,0,0-1.073-.385,14.454,14.454,0,0,1-3.033-.319,22.686,22.686,0,0,0-2.978-1.038c-2.546-.546-5.1-1.07-7.646-1.6a14.423,14.423,0,0,1-1.687-.37,5.427,5.427,0,0,0-2.755-.17c-2.277.36-2.382,0.277-4.07-1.415l-1.88-.279,0.013,0.08-0.048-.768c-1.6-.406-3.066-1.268-4.819-1.516-0.751-.107-1.49-0.412-2.244-0.588-0.554-.129-1.12-0.206-1.682-0.29-0.657-.1-1.141.381-1.894,0.054-1.4-.611-3-0.684-4.384-1.43a14.408,14.408,0,0,0-7.526-1.859,7.811,7.811,0,0,0-3.9-1.426,3.835,3.835,0,0,1-1.918-.506c-0.926-.788-2.114-0.857-3.176-1.232a4.9,4.9,0,0,0-3.287-.422,3.641,3.641,0,0,1-2.46-.538,4.337,4.337,0,0,0-2.156-.65c-1.474.069-1.494,0-3.073-1.247,1.062-.21,2.092-0.379,3.079-0.62a0.613,0.613,0,0,0,.131-1.2,18.048,18.048,0,0,0-2.585-1.168,34.842,34.842,0,0,0-3.621-1.067c-1.3-.3-2.625-0.489-4.156-0.766l-0.727-2.1a12.741,12.741,0,0,0-3.837-.818c-1.2-.14-1.482.327-0.874,1.273a2.365,2.365,0,0,1,.17.405c-0.489.37-1.629,0.47-.741,1.509a10.491,10.491,0,0,1,3.57,1.349,9.967,9.967,0,0,0,2.74.827,2.18,2.18,0,0,1,1.659.972c-1.845,0-3.508-1-5.417-1.044l-1.172.814a32.272,32.272,0,0,1-3.7-1.01c-1.449-.585-2.752-0.936-3.707-0.174-1.408-.441-1.34-1.329-1.853-1.862-4.683-.6-9.057-1.575-12.9-4.169l-0.554-1.644c0.2-.347.41-0.708,0.617-1.07a1.785,1.785,0,0,1,1.959-.771c1.028,0.1,2.052.106,3.161,0.156a3.529,3.529,0,0,0,.569,1.267,9.545,9.545,0,0,0,1.453.781c1.671,1.041,3.714,1.394,5.523,2.213a8.055,8.055,0,0,0,5.225.227,0.544,0.544,0,0,0,.139-0.358l-4.457-1.617c-0.257-1.571-1.435-2.373-3.308-2.567a10.014,10.014,0,0,1-4.3-1.451,4.776,4.776,0,0,0-3.86-.679,3.838,3.838,0,0,1,1.059-.886,4.228,4.228,0,0,1,1.14.135c-0.007-.37-0.024-0.723-0.016-1.071a3.729,3.729,0,0,1,.062-0.5,11.762,11.762,0,0,0-1.13-.746,63.4,63.4,0,0,1-6.877-3.8,5.855,5.855,0,0,0-3.512-1.013c-0.591.405-.2,0.932,0.137,1.353,0.613,0.774,1.364,1.5,2.056,2.245l-3.9,1.748c-0.246-.2-0.545-0.472-0.883-0.711a15.4,15.4,0,0,0-2.5-1.673,4.273,4.273,0,0,1-2.592-2.4,6.2,6.2,0,0,0-.73-1.107l1.935-.885a1.243,1.243,0,0,0-.153-0.508q-0.832-.822-1.718-1.616A8.559,8.559,0,0,1-26,193.837a6.515,6.515,0,0,0-3.846-2.478c-0.117-1.832-1.53-3.793.737-5.039-1.008-1.37-2.085-2.61-1.5-4.1a2.171,2.171,0,0,0-.553-2.063c-1.384-1.348-1.013-2.534-.7-3.779,0.032-.129.088-0.253,0.154-0.438a8.64,8.64,0,0,1,1.938.418,6.568,6.568,0,0,0,4.611.367c0.834-.95,1.678-1.9.558-3.3-1.019-.4-2.117-0.77-3.144-1.246a2.8,2.8,0,0,1-1.185-.984,1.7,1.7,0,0,1,.251-1.055,5.792,5.792,0,0,0-3.164-1.484,4.726,4.726,0,0,1-2.807-1.232c-1.2-1.319-3.037-1.817-4.778-2.277a73.013,73.013,0,0,1-8.386-2.286,9.57,9.57,0,0,0-2.513-.506,57.174,57.174,0,0,1-12.314-3.066c-1.434-.477-2.915-0.276-4.216-0.77a12.4,12.4,0,0,0-4.168-.941,5.879,5.879,0,0,1-1.421-.251c-1.383-.4-2.756-0.828-4.2-1.265,0.1-.453.686-0.281,1.04-0.234,1.127,0.146,2.253.385,3.381,0.545a2.273,2.273,0,0,0,1.051-.075,10.758,10.758,0,0,1,5.149-.324c1.225,0.136,2.453.322,3.678,0.508,0.513,0.077.961,0.1,1.119-.307A1,1,0,0,0-61.779,155a2.992,2.992,0,0,0-.779-0.329c-1.289-.4-2.568-0.889-3.88-1.156-1.878-.384-3.667-1.218-5.613-1.264a1.882,1.882,0,0,1-.776-0.315c-0.382-.222-0.732-0.479-1.323-0.874a4.594,4.594,0,0,1,1.132-.324,9.561,9.561,0,0,1,1.707.181c3.032,0.585,6.111,1.023,9.076,1.843a60.369,60.369,0,0,0,6.757,1.22c2.282,0.363,4.564.751,6.846,1.074a14.891,14.891,0,0,0,2.543.108A1.074,1.074,0,0,0-45,153.977c-0.1-.561-0.248-1.124-0.371-1.674,0.94-.178,1.349-0.591.948-1.262-0.778-1.3-.335-2.687-1.4-3.96a0.471,0.471,0,0,1-.089-0.418c0.263-.754.555-1.5,0.816-2.192a1.519,1.519,0,0,1,1.479.874,5.765,5.765,0,0,0,3.333,2.528,2.536,2.536,0,0,1,.5.362l-0.884,1.225,0.871,0.754a3.077,3.077,0,0,0,.792.664c1.6,0.612,3.236,1.152,4.838,1.76a12.624,12.624,0,0,1,2.307,1.063,6.031,6.031,0,0,0,4.331.966c1.851-.294,3.932.023,5.666-0.6,0.409-.147,1.16.269,1.509-0.188a8.912,8.912,0,0,0-3.792-1.686c-2.717-.672-5.453-1.269-8.172-1.937a8.357,8.357,0,0,1-1.441-.652c0.39-.635,1.016-0.375,1.531-0.258,1.974,0.45,3.938.947,5.912,1.395a26.176,26.176,0,0,0,6.8.62,8.335,8.335,0,0,1,3.364.512c1.221,0.464,2.315-.144,2.228-1.118a2.767,2.767,0,0,0-.613-1.451,10.113,10.113,0,0,0-1.759-1.586,2.729,2.729,0,0,0-1.281-.533,40.128,40.128,0,0,1-10.37-2.5c-1.244-.43-2.519-0.788-3.782-1.179-0.033-1.246,1.95-1.655,1.695-3.149-0.354-.2-0.818-0.47-1.3-0.721-1.094-.567-2.25-1.063-2.243-2.229a1.949,1.949,0,0,0-.816-0.923c-0.488-.387-1.054-0.72-1.71-1.158-0.03-.414-0.092-0.9-0.094-1.388a2.179,2.179,0,0,0-1.837-2.112c-0.787-.254-1.547-0.891-2.382-0.412-0.718.411-.119,1.043-0.07,1.582,0.007,0.072.008,0.142,0.015,0.266a8.166,8.166,0,0,1-2.851-.854,2.793,2.793,0,0,0-2.416-.062c-0.811.384-1.574,0.816-2.482,1.292l-0.578-1.048c1.412-.727,2.745-1.438,4.119-2.109a2.782,2.782,0,0,1,3.107.285,2.852,2.852,0,0,0,.651.222l0.4-.818,4.993,0.459c0.443-.507-0.39-1.525.728-1.934,2.332,0.7,4.733,1.424,7.132,2.152a2.836,2.836,0,0,0,2.248-.054,1.758,1.758,0,0,0-1.265-1.077c-1.324-.558-2.7-1.036-4.022-1.591a2.13,2.13,0,0,1-1.073-.743c-0.347-1.361-1.865-1.77-3.17-2.218a17.3,17.3,0,0,1-4.4-2.433,2.077,2.077,0,0,1-.763-0.693c-0.329-1-1.525-1.571-2.254-2.366l-0.016.022a19.807,19.807,0,0,1,4.753.175,3.147,3.147,0,0,0,3.335-1.027l-3.671-2.667a1.05,1.05,0,0,1,1.3-.179c2.439,1.019,5.291,1.5,7.045,3.56h2.195c0.252-1.327-.837-2.325-1.675-3.319a5.676,5.676,0,0,0-3.212-1.646c-2.585-.506-5.008-1.465-7.533-2.118-2.147-.555-4.326-1.024-6.434-1.685-2.857-.9-5.735-1.675-8.645-2.386a10.85,10.85,0,0,1-3.691-1.635,7.686,7.686,0,0,1,1.578-.062c2.455,0.516,4.907,1.05,7.35,1.624a66.562,66.562,0,0,0,8.213,1.532c0.845,0.089,1.933.351,2.341-.535A1.611,1.611,0,0,1-37.9,109.2c2.244,0.927,4.789.746,6.961,1.878a0.6,0.6,0,0,0,.274.082c1.9-.148,3.765.721,5.651,0.781,0.747,0.024,1.48-.04,2.221-0.055s1.483,0,2.217-.032a2.832,2.832,0,0,0,1.288-.162,2.8,2.8,0,0,0,.541-1.179,33.519,33.519,0,0,0-6.08-1.963,6.586,6.586,0,0,1-.494.77,1.056,1.056,0,0,1-1.593.132c-0.637-.493-1.222-1.024-1.871-1.574a4.756,4.756,0,0,0,.333-1.361,6.423,6.423,0,0,0-.469-1.5c2.8-.022,5.419.7,8.246,1.144-0.061-.48-0.11-0.866-0.154-1.212-1.1-.674-2.652-0.61-3.281-1.851a16.13,16.13,0,0,1,5.84.187c1.757,0.5,3.6.453,5.31,1.148a1.161,1.161,0,0,0,.565.057A13.274,13.274,0,0,1-7.663,105c0.769-.524.769-0.524,1.4-2.124l4.218,0.435a1.493,1.493,0,0,0,.854-1.274,15.234,15.234,0,0,0-6.216-3.824c-2.909-.994-5.94-1.707-8.92-2.534-0.745-.206-1.5-0.391-2.25-0.568-1.507-.353-3.011-0.735-4.527-1.027a13.84,13.84,0,0,1-4.875-1.633,10.514,10.514,0,0,0-1.856-.714c-0.533-.2-1.093-0.358-1.594-0.6-0.709-.343-1.085-0.976-0.719-1.036a2.916,2.916,0,0,1,1.3.126c2.6,0.89,3.3.912,5.683,0.028l2.01,2.05a3.005,3.005,0,0,0,2.4-.486,2.29,2.29,0,0,1,1.826-.2,19.953,19.953,0,0,0,2.843.475c1.22,0.116,2.438.058,3.654,0.218s2.45,0.569,3.678.738c1.127,0.155,2.259.121,3.392,0.2a8.02,8.02,0,0,1,1.667.235,1.371,1.371,0,0,0,1.453-.425c-0.333-1.315-2.157-1.677-3.222-2.575,0.208-.442.929-0.22,1.3-0.424,0.407-.223.77-0.487,1.227-0.781L-4.962,87.57l2.2-.553A1.219,1.219,0,0,0-2.7,86.491a2.174,2.174,0,0,0-1.624-1.249c-1.1-.353-2.219-0.638-3.423-0.979l-1.981-3.114C-6.265,81.34-2.8,82.219.831,82.4c1.856-1.081,1.856-1.081.989-2.758l0.012,0.072a5.641,5.641,0,0,1,1.633.2,8.9,8.9,0,0,0,3.379.611c0.942,0.056,1.388-.56,1.01-1.3a12.142,12.142,0,0,0-.718-1.076l4.209-1.568c0.029-.86.055-1.617,0.075-2.24,0.542-.509,1.184-0.155,1.707-0.194,1.412-.108,1.772-0.841.789-1.794a15.108,15.108,0,0,0-1.541-1.142c0.215-.234.4-0.448,0.6-0.655s0.409-.4.633-0.623a2.231,2.231,0,0,0-.508-0.59q-2.841-1.53-5.723-3.013a4.17,4.17,0,0,0-1.356-.466,14.4,14.4,0,0,1-4.266-1.572c-2.181-.956-4.093-2.245-6.32-3.155A7.663,7.663,0,0,0-7.6,60.5c-1.124,0-2.259-.031-3.394-0.087a14.118,14.118,0,0,1-1.5-.247c-0.191-.815.17-1.585-0.675-2.307a2.554,2.554,0,0,0-2.243-.829,7.96,7.96,0,0,1-4.438-.617c-0.532-.2-1.127-0.285-1.666-0.479s-1.018-.452-1.614-0.723l-0.945.743a4.112,4.112,0,0,0,.458.571c1.055,0.92,1.1,1.1.228,1.752-0.43.32-.924,0.591-1.508,0.959a9.008,9.008,0,0,0,4.746,2.1c2.138,0.381,2.137.386,3.962,1.919a1.88,1.88,0,0,1-.738.083c-0.436-.181-0.8-0.473-1.232-0.676a2.821,2.821,0,0,0-2.166-.347,7.421,7.421,0,0,1-1.354.162,3.617,3.617,0,0,1-1.9-.286,33.271,33.271,0,0,0-4.936-1.485,32.055,32.055,0,0,1-7.808-2.916,3.05,3.05,0,0,1-1.645-1.472,14.109,14.109,0,0,1,2.914-.656c1.076-.03,2.266.446,3.471,0.108l0.291-1.152a3.888,3.888,0,0,0-.612-0.507c-0.663-.358-1.4-0.643-2.018-1.037a17.232,17.232,0,0,1-1.591-1.257,0.945,0.945,0,0,1,1.255-.271c1.7,0.357,3.4.767,5.094,1.149,0.368,0.082.743,0.127,1.227,0.207a1.8,1.8,0,0,0-.327-1.852,4.32,4.32,0,0,1-.907-1.634c-0.139-1.226-1-2.041-2.4-2.683a1.873,1.873,0,0,1-.4-0.342c-0.022-.687.508-1.009,1.361-0.956,1.036,0.065,2.086.275,3.127,0.37a2.314,2.314,0,0,0,1.31-.1c0.608-1.019,1.981-.687,3.244-0.808,0.35,0.311.709,0.665,1.117,0.984a4.609,4.609,0,0,0,2.643.956,15.585,15.585,0,0,1,7.123,1.953,3.214,3.214,0,0,0,.992.087l0.346-1.106a3.641,3.641,0,0,0-.584-0.549,8.276,8.276,0,0,0-1.023-.479,24.084,24.084,0,0,1-3.405-1.5c-2.34-1.5-5.09-2-7.7-2.895a10.909,10.909,0,0,1-5-3.066c0.472-.064.792-0.1,1.1-0.152,0.256-.042.5-0.1,0.854-0.174-0.1-.434-0.2-0.849-0.318-1.354a11.472,11.472,0,0,0,1.4.184,0.653,0.653,0,0,0,.563-0.291,0.686,0.686,0,0,0-.378-0.536c-1.21-.53-2.593-0.819-3.533-1.782,0.071-.743.635-1.032,1.685-0.81,1.758,0.371,3.411.516,4.824-.28a2.8,2.8,0,0,1,1.373,0c0.848,0.118,1.7.3,2.5,0.448,0.717-1.073.717-1.073,2.856-.926,0.772-.458,1.222-1.267,2.677-1.327,0.972,0.49.906,2.068,2.878,1.952a1.787,1.787,0,0,0,.8-1.31,0.858,0.858,0,0,0-.23-0.82c-1.066-.924-2.182-1.819-3.322-2.695a16.443,16.443,0,0,0-4.4-1.952l0.951-1.928-1.015-1.494a0.517,0.517,0,0,1,.167-0.225c1.551-.042,2.682-1.456,4.6-0.2a5.349,5.349,0,0,0,1.048,1.449,4.333,4.333,0,0,0,1.609.245l0.743,0.013a0.634,0.634,0,0,0-.8-0.429l-1.063-.547c1.356-.151,1.519-0.2,1.854-0.025A10.351,10.351,0,0,0-3.681,25.33c3.681-.165,6.991.958,10.261,2.4a4.51,4.51,0,0,0,2.15.647,0.969,0.969,0,0,1,.55.134c1.576,1.23,3.632.946,5.408,1.553,0.744,0.254,1.693.669,2.279-.032,1.1,0.189,2.287.034,3.229,0.854a3.052,3.052,0,0,0,2.025.87,2.114,2.114,0,0,1,.979.383,8.036,8.036,0,0,0,5.887,1.46c1.242-.19,2.5-0.338,3.737-0.5,1.356,0.443,1.549,1.353,1.969,2.266a3.221,3.221,0,0,0,3.78-.648c2.024,0.62,4,1.3,5.105,2.736a34.711,34.711,0,0,0,7.248.942c1.042,0.092,1.25-.291,1.279-0.933a8.556,8.556,0,0,0-1.549-1.087c-1.028-.437-1.369-1.3-2.274-1.778-0.759-1.6-2.314-1.954-4.179-1.873-0.552.024-1.15-.1-1.693-0.058a2.887,2.887,0,0,0-1.217.343C40.36,33.577,39.491,34.2,38.6,34.81ZM338.206,260.775l0.533-.05-0.571-.131-0.309.1Zm-5.689,1.96-0.06.107,0.039-.152a8.325,8.325,0,0,0,2.393-.864,2.938,2.938,0,0,0-2.425-1.315,2.274,2.274,0,0,0-2.212.5C330.67,261.814,331.839,262.105,332.517,262.735Zm2.885-187.4a18.948,18.948,0,0,0,5.528,1.421,12.81,12.81,0,0,1,2.539.372,24.551,24.551,0,0,1,2.606,1.047l0.309-1.088c-1.031-.5-2.023-1.028-3.056-1.485-1.566-.693-3.174-0.5-4.769-0.647a6,6,0,0,0-3.142.451c-0.552.166-1.115,0.32-1.647,0.511a0.39,0.39,0,0,0-.019.357,0.353,0.353,0,0,0,.206.152,1.086,1.086,0,0,0,1.337-.3A3.029,3.029,0,0,0,335.4,75.336ZM16.129,52.856l0.036,0.16a15.228,15.228,0,0,1-3.033-.655c-1.659-.733-3.358-0.707-5.03-1-1.113-.2-1.472.2-1.584,1.474,1.582,0.537,3.2,1.118,4.832,1.632,1.818,0.57,3.386,1.317,4.2,2.767a2.385,2.385,0,0,0,.7.276l1.3-1.293a26.727,26.727,0,0,0,3.642.326c1.391-.06,2.406,1.254,3.787.857,0.566-1.048.566-1.048-1.562-2.488a2.512,2.512,0,0,1,.951-0.475,12.281,12.281,0,0,1,1.393.274,0.762,0.762,0,0,0,.833-1.167,2.857,2.857,0,0,0-1.846-1.091,14,14,0,0,0-2.264-.213,8.915,8.915,0,0,1-3.615-.6,18.481,18.481,0,0,0-3.482-.689C14.853,51.768,15.833,52.263,16.129,52.856Zm311.032,192.7-0.007-.068a12.276,12.276,0,0,1-1.278,1.215,14.985,14.985,0,0,1-1.728.922,13.2,13.2,0,0,0,4.593.537l2.478,1.271c1.909-.539,3.686-0.927,5.8-0.034a2.568,2.568,0,0,0,2.36-.126,14.3,14.3,0,0,1,1.333-.617h-0.137c0.926,0.261,1.844.56,2.78,0.774a2.947,2.947,0,0,0,2.96-.577,9.81,9.81,0,0,1,1.284-1.241c0.662-.487-0.057-1.027-0.138-1.537a7.546,7.546,0,0,1,3.867.182,2.023,2.023,0,0,0,1.98-.37,1.607,1.607,0,0,0,.416-0.887c-0.632-.215-1.073-0.4-1.531-0.509a12.713,12.713,0,0,0-1.418-.192,72.589,72.589,0,0,0-7.371-.359c-1.788-.021-3.6-0.124-5.4-0.238-1.4-.089-2.852-0.519-4.156-0.032a3.145,3.145,0,0,1-1.1-.161,12.659,12.659,0,0,0-1.407-.205c-3.024-.118-6.045-0.215-9.26-0.326a1.648,1.648,0,0,0,.308.816c1.165,0.435,2.355.833,3.56,1.167A2.184,2.184,0,0,1,327.161,245.555ZM-11.045,185.668l-1.376,1a5.115,5.115,0,0,0,3.709,3.2,33.614,33.614,0,0,0,6.744,1.4,2.282,2.282,0,0,0,.612-0.175l0.446-.79-1.017-1.2c1.033-.458,2.04-0.856,2.967-1.333,0.626-.322.88-0.809,0.1-1.59-0.794-.106-1.733-0.252-2.67-0.352-1.739-.185-1.832-0.239-2.494-1.724l1.048-.915c-2.682-1.1-5.191-2.339-8.077-2.526a6.132,6.132,0,0,0-.092-1.931c-0.79-2.094-4.708-4.194-7.192-4.226-1.064-.013-1.793.182-2.119,1.019a9,9,0,0,0,1.569,2.063,18.554,18.554,0,0,0,3.017,1.556c-1.41.55-3.208-.85-4.3,0.21a2.952,2.952,0,0,0,2.142,1.753,43.376,43.376,0,0,1,4.742,1.814C-13.617,184.546-13.409,184.691-11.045,185.668ZM-5.483,59.947C-3.9,60.4-2.5,61.378-.825,60.983a1.315,1.315,0,0,1,.564.082c1.654,0.485,3.3,1,4.963,1.455,0.833,0.226,1.7.334,2.55,0.5A1.585,1.585,0,0,0,8.658,62.6a2.148,2.148,0,0,1,.7.021l1.578,1.316,1.641-.244a18.917,18.917,0,0,0,1.674,1.1,6.726,6.726,0,0,0,1.857.718c0.493,0.086,1.01-.231,1.526-0.184a10.57,10.57,0,0,1,4.44,1.066c0.962,0.546,2.038.967,3.025,1.425,0.99-.388,1.876-0.7,2.7-1.07a0.92,0.92,0,0,0-.216-1.756c-1.232-.435-2.277-1.241-3.731-1.3a10.952,10.952,0,0,1-2.8-.581,28.169,28.169,0,0,0-3.388-.55A29.548,29.548,0,0,1,14.443,61.4a7.05,7.05,0,0,0-1.7-.259,12.336,12.336,0,0,1-3.926-.893,7.514,7.514,0,0,0-3.051-.668c-1.421.025-2.719-.974-4.193-0.838a3.282,3.282,0,0,1-.792-0.29c-2.124-.6-4.252-1.177-6.375-1.777a2.262,2.262,0,0,0-2.41.464ZM70.452,42.44l1.26-2.579a11.813,11.813,0,0,0-4.252-1.71,29.489,29.489,0,0,1-4.928-1.611,9.376,9.376,0,0,0-5.2-.666c-0.7.118-1.434,0.178-2.157,0.264l-0.6,1.9c0.495,0.574.9,1.1,1.378,1.578a3.59,3.59,0,0,0,1.063.749,25.36,25.36,0,0,0,4.738,1.908C64.751,42.886,67.818,43.246,70.452,42.44ZM317.423,71.446a9.181,9.181,0,0,0-4.517-1.209c-1.014.013-2.049-.03-3.079-0.117-1.7-.144-3.412-0.373-5.113-0.5a1.488,1.488,0,0,0-1.1.366c-0.258.343,0.229,0.641,0.672,0.859a12.471,12.471,0,0,1,1.5.761,11,11,0,0,0,4.564,1.586c2.18,0.364,4.3.146,6.486,0.545,1.292,0.235,1.707-.213,1.294-1.192A7.222,7.222,0,0,0,317.423,71.446ZM341.481,234.22a2.109,2.109,0,0,0,1.842.981c3.407,0.231,6.816.478,10.211,0.628a19.917,19.917,0,0,0,3.547-.268c0.414-.055.776-0.4,0.518-0.8a1.52,1.52,0,0,0-.909-0.528,32.616,32.616,0,0,1-5.376-.8,23.379,23.379,0,0,0-2.533-.458c-1.026-.144-1.879-0.039-2.176.78a1.12,1.12,0,0,1-.441.355ZM14.867,204.3a1.522,1.522,0,0,0-.093-0.829,4.018,4.018,0,0,0-1.182-1.017c-0.992-.528-2.056-0.968-3.089-1.447-1.016-.471-2-1.007-3.05-1.4a9.149,9.149,0,0,0-3.9-.573,0.824,0.824,0,0,0-.651.538,0.937,0.937,0,0,0,.41.754,6.274,6.274,0,0,0,1.281.59,32.487,32.487,0,0,1,5.359,2.512A12.372,12.372,0,0,0,13.5,204.53,3.891,3.891,0,0,0,14.867,204.3Zm-63.384-45.145a1.755,1.755,0,0,0-.257-0.663c-1.988-1.328-4.381-1.556-6.671-2.1a13.807,13.807,0,0,0-4.607-.255c-0.019.939,0.654,1.471,1.68,1.742a22.411,22.411,0,0,0,6.655,1.11c0.437-.019.921,0.143,1.377,0.168C-49.788,159.186-49.245,159.159-48.517,159.155Zm399.505,61.03a4.356,4.356,0,0,0-2.134-1.117,6.917,6.917,0,0,0-3.3.038c-1.153.44-2.355,0.823-3.555,1.237a2.487,2.487,0,0,0,2.743,1.045l1.641-.4C349.575,221.932,349.62,221.924,350.988,220.185ZM8.078,43.819C6.495,42.8,5.811,41.683,4.24,41.362q-2.947-.6-5.906-1.107a0.676,0.676,0,0,0-.3.628,1.72,1.72,0,0,0,.818.6c1.657,0.7,3.33,1.371,5.006,2.038a2.71,2.71,0,0,0,.822.174C5.6,43.741,6.53,43.763,8.078,43.819ZM382.845,189.8a17.834,17.834,0,0,1-2.714-1.063,6.73,6.73,0,0,0-4.322-1l-1.15,1c1.287,0.63,2.422,1.263,3.635,1.757a3.479,3.479,0,0,0,3.388-.029C381.923,190.292,382.21,190.157,382.845,189.8Zm-31.706,82.4c-2.136-1.158-4.537-.685-5.375.928a0.535,0.535,0,0,0,.1.56,1.145,1.145,0,0,0,.733.275,4.172,4.172,0,0,1,2.948.3,2.66,2.66,0,0,0,1.326-.041,0.73,0.73,0,0,0,.678-0.954A7.637,7.637,0,0,0,351.139,272.191Zm-351.8-72.739,1.709,0.1L1.511,198.3c-0.719-.528-1.346-1.022-2.022-1.474a3.381,3.381,0,0,0-3.146-.252,1.077,1.077,0,0,0-.386.619Zm375.319-12.134a1.22,1.22,0,0,0-.779-1.625,3.962,3.962,0,0,0-3.451-.02,0.529,0.529,0,0,0-.013.919C371.719,187.392,373.059,188.032,374.654,187.318ZM362.7,247.905a2.775,2.775,0,0,0,2.221,1.064,15.417,15.417,0,0,0,2.631-.408c0.4-.087.347-0.666-0.047-0.913a1.926,1.926,0,0,0-.746-0.366,24.7,24.7,0,0,0-3.082-.056A2.413,2.413,0,0,0,362.7,247.905ZM9.111,38.414a3.135,3.135,0,0,1,.443.875,1.651,1.651,0,0,1-.644.215l0.141,0.267,2.383-.006c0.809,0.663.792,0.65,1.384,0.2a10.056,10.056,0,0,1,1.069-.614l-1.747-1.167Zm11.7-11.9a7.544,7.544,0,0,0,4.356,1.487,0.9,0.9,0,0,0,.776-0.373,1.152,1.152,0,0,0-.468-0.946A5.844,5.844,0,0,0,20.809,26.518ZM345.253,261.1c-0.839.007-1.487-.022-2.1,0.033a3.264,3.264,0,0,0-.894.369c0.452,0.4.747,0.7,1.093,0.957a3.33,3.33,0,0,0,.944.546,5.082,5.082,0,0,0,1.358.223c0.58,0.016.944-.456,0.669-0.858S345.692,261.62,345.253,261.1ZM2.423,39.246a1.462,1.462,0,0,0-.781-1.741,2.506,2.506,0,0,0-1.7-.766c-0.959.143-.658,0.816-0.661,1.341a1.129,1.129,0,0,0,.263.405A4.6,4.6,0,0,0,2.423,39.246ZM323.429,270.368a6.2,6.2,0,0,0,4.537,1.182,0.768,0.768,0,0,0,.464-0.626,0.639,0.639,0,0,0-.7-0.608C326.513,270.293,325.314,270.338,323.429,270.368Zm-342-87.7a1.314,1.314,0,0,0,.045.82,3.6,3.6,0,0,0,1.291.863,1.412,1.412,0,0,0,1.991-.677A8.706,8.706,0,0,0-18.574,182.668Zm-7.033,9.6c0.625-.526.14-0.894-0.17-1.249a1.327,1.327,0,0,0-1.222-.4c-0.262.023-.676-0.326-0.914-0.288a0.568,0.568,0,0,0-.511.832Zm352.679,76.684a3.95,3.95,0,0,0,2.893.858c0.486-.04,1.131-0.048,1.093-0.617C329.4,268.593,329.4,268.593,327.072,268.955Zm1.852-37.143c0.61,1.458.949,1.714,1.993,1.6a0.544,0.544,0,0,0,.349-0.981A3.126,3.126,0,0,0,328.924,231.812Zm30.164,40.556a2.176,2.176,0,0,0,2.545-.2c0.213-.233-0.179-0.728-0.625-0.821a2.278,2.278,0,0,0-1.945.372A0.878,0.878,0,0,0,359.088,272.368ZM3.777,208.866c0.982,0.065,1.316-.252,1.191-0.846a1.2,1.2,0,0,0-1.306-.718,3.294,3.294,0,0,0-.791.161Zm-9-158.486a10.429,10.429,0,0,0-1.035-1.054,1.208,1.208,0,0,0-1.274-.132,0.645,0.645,0,0,0-.4.442,0.96,0.96,0,0,0,.94.733A13.164,13.164,0,0,0-5.219,50.38ZM382.54,142.319a1.524,1.524,0,0,0-1.773-.087,0.481,0.481,0,0,0,.111.544,1.292,1.292,0,0,0,1.635.04A0.739,0.739,0,0,0,382.54,142.319Zm-27.5,79.316a1.341,1.341,0,0,0-1.49-1c-0.4.01-.762,0.135-0.66,0.456a1.14,1.14,0,0,0,.639.641A7.375,7.375,0,0,0,355.04,221.635ZM-16.729,55.205a0.561,0.561,0,0,0-.017-0.373,1.964,1.964,0,0,0-.63-0.436,1.1,1.1,0,0,0-1.232-.147,0.4,0.4,0,0,0-.157.336,7.945,7.945,0,0,0,1.053.7,1.084,1.084,0,0,0,.543.072A1.694,1.694,0,0,0-16.729,55.205ZM337.114,262.379c0.956,0.215,1.69.5,2.2-.025C338.268,261.54,338.268,261.54,337.114,262.379ZM320.2,74.473l1.411-.544c-0.453-.75-1.085-0.689-1.876-0.666C319.877,73.623,320.008,73.965,320.2,74.473Zm58,90.276q0.154,0.237.307,0.474a2.473,2.473,0,0,1,.763-0.144,0.915,0.915,0,0,0,1.094-.289,0.412,0.412,0,0,0-.227-0.344,4.084,4.084,0,0,0-1.3-.213A1.438,1.438,0,0,0,378.2,164.749ZM195.918,252.842a1.305,1.305,0,0,0,1.337.726c0.375-.037.92-0.024,0.822-0.548A2.353,2.353,0,0,0,195.918,252.842Zm-203.5-227c0.587,0.813,1.358.692,2.306,0.844A3.161,3.161,0,0,0-7.584,25.841ZM321.532,262.485a0.851,0.851,0,0,0,.166.38,1.05,1.05,0,0,0,1.179.258,0.371,0.371,0,0,0,.072-0.473,1.142,1.142,0,0,0-1.2-.258A1.61,1.61,0,0,0,321.532,262.485ZM-28.228,58.679a0.905,0.905,0,0,0-.172-0.445,0.98,0.98,0,0,0-.534-0.069,0.32,0.32,0,0,0-.058.284A7.721,7.721,0,0,0-28.228,58.679Zm17.369-1.519a4.336,4.336,0,0,0,.756-0.122,0.359,0.359,0,0,0-.1-0.329,3.971,3.971,0,0,0-.715-0.123C-10.9,56.744-10.885,56.9-10.859,57.16Zm0.567,137.506,0.136-.354a1.23,1.23,0,0,0-.478-0.027,0.97,0.97,0,0,0-.141.439Zm333.076,59.511c0.034-.107.069-0.215,0.1-0.322a1.622,1.622,0,0,0-.464-0.069,0.967,0.967,0,0,0-.078.415Zm-334-61.06,0.239,0.054c0-.11.006-0.22,0.008-0.329a1.031,1.031,0,0,0-.212-0.016A1.377,1.377,0,0,0-11.215,193.117Zm396.959-50.586-0.22-.068,0.116,0.154ZM2.9,52.842l0.127,0.151,0.034-.2Zm59.637-18.16a2.816,2.816,0,0,0-.252-0.369,0.376,0.376,0,0,0-.254.02,0.173,0.173,0,0,0,0,.194A4.334,4.334,0,0,0,62.542,34.682Zm-63.1,17.4a0.37,0.37,0,0,0-.08-0.175,0.771,0.771,0,0,0-.237-0.069,0.357,0.357,0,0,0,.077.174A0.8,0.8,0,0,0-.562,52.086Zm-1.61-.535L-2.417,51.3a0.2,0.2,0,0,0-.044.118A1.6,1.6,0,0,0-2.173,51.552ZM348.173,78.387a0.557,0.557,0,0,0,.162-0.066,0.314,0.314,0,0,0-.08-0.114,0.538,0.538,0,0,0-.159.068A0.3,0.3,0,0,0,348.173,78.387ZM60.867,35.1a0.277,0.277,0,0,0-.038-0.179,0.609,0.609,0,0,0-.239-0.016l0.1,0.234Zm-7.574,3.514,0.149-.018-0.1-.086ZM440.727,189.682c-0.3-.56.2-0.863,0.672-0.927a3.361,3.361,0,0,0,3.047-2.175,13.777,13.777,0,0,1,1.056-1.112c0.4-.712.979-1.469-0.345-2.284a1.081,1.081,0,0,1-.429-0.567,3.791,3.791,0,0,0-2.728-2.31c-0.8.041-1.631,0.1-2.471,0.119s-1.042-.28-0.833-1.165c0.794-.186,1.549.578,2.456,0.286a8.166,8.166,0,0,1,2.2.125c0.84,0.029,1.672.006,2.51,0.006,0.009-.4,0-0.682.024-0.958,0.092-.908.938-1.3,2.067-0.936a5.7,5.7,0,0,1,1.034.474,14.136,14.136,0,0,0,4.165,1.715,2.18,2.18,0,0,1,.561.427,4.094,4.094,0,0,0-.442,1.008,3.77,3.77,0,0,1,.033,1.227c-0.783,1.211-1.4,2.582-3.619,2.728a1.823,1.823,0,0,0,1.346,1.436,2.853,2.853,0,0,1,1.637,1.552l-2,3.095c-0.778.168-1.53,0.386-2.333,0.484a3.529,3.529,0,0,1-1.654-.111,3.433,3.433,0,0,0-3.53.274c-1.111-.469-2.333-0.6-3.173-1.33-0.279-.649.111-0.945,0.785-1.1l0.152,0.058Zm1.525,0.633,0.168-.095-0.279-.134a0.28,0.28,0,0,0-.057.15A0.476,0.476,0,0,0,442.252,190.315Zm6.343-10.468a0.276,0.276,0,0,0-.029-0.182,0.619,0.619,0,0,0-.245-0.024,0.279,0.279,0,0,0,.029.183A0.622,0.622,0,0,0,448.6,179.847ZM20.782,17.53a1.953,1.953,0,0,1-1.8-.528,21.74,21.74,0,0,0-4.539-2.7,7.368,7.368,0,0,1-2.88-2.611,6,6,0,0,1,1.382.272c0.943,0.439,1.779,1.063,2.749,1.428,0.865,0.324,1.883.318,2.778,0.6a16.183,16.183,0,0,0,5.125.907c0.744-.628.727-1.281-0.26-2.028-1.526-1.154-2.4-2.592-3.863-3.886A7.683,7.683,0,0,0,21.6,8.333a4.609,4.609,0,0,0,.875-1.624l1.853-.63a2.555,2.555,0,0,1,.639.241A12.65,12.65,0,0,0,30.173,9.3a10.326,10.326,0,0,1,5.05,2.8,7.42,7.42,0,0,0,1.391.844c0.42,0.277.8,0.592,1.226,0.915a2.53,2.53,0,0,1-2.528-.407,8.227,8.227,0,0,0-5.4-1.315,18.966,18.966,0,0,1-2.994-.313c-0.55.348-.312,0.687,0.035,0.98,0.521,0.44,1.095.847,1.811,1.393l-2.35.539,1.149,1.7a1,1,0,0,1-1.362.51,3.288,3.288,0,0,1-.538-0.2,7.466,7.466,0,0,0-5.7-.307l0.823,1.16Zm25.84,1.208c0.194,0.188.457,0.421,0.687,0.669a7.788,7.788,0,0,0,5.043,2.546,22.838,22.838,0,0,1,3.842,1.08,2.239,2.239,0,0,1,.61.453c-0.176.387-.534,0.235-0.9,0.167-2.058-.377-4.18-0.428-6.117-1.4-2.861-.379-5.532-1.667-8.423-1.939a15.213,15.213,0,0,1-2.839-.508,23.716,23.716,0,0,0-6.786-.934A4.033,4.033,0,0,1,28.913,17.8a0.524,0.524,0,0,1,.3-0.979,6.966,6.966,0,0,1,1.661-.049,1.517,1.517,0,0,0,1.426-.4c0.663-.809,1.795-0.773,2.881-0.55,2.156,0.442,4.294,1.012,6.432,1.556C43.174,17.783,44.726,18.224,46.622,18.738ZM423.557,150.777a0.771,0.771,0,0,1-.879.853c-0.749.014-1.508-.012-2.262-0.016-1.287-.008-2.356.222-2.848,1.153a1.2,1.2,0,0,1-.652.593c-2.344.722-4.552,1.794-7.568,0.948-0.525-.756-0.187-1.39-0.132-2.072a2.029,2.029,0,0,0-.607-1.413,5.4,5.4,0,0,0-1.594-.657l-2.176,1.9a6.163,6.163,0,0,1-1.344-.631,20.63,20.63,0,0,1-1.689-1.712,7.042,7.042,0,0,1,2.653-.386c3.856,0.164,7.712.3,11.58,0.565C418.482,150.072,420.947,150.465,423.557,150.777ZM286.605,57.091a3.717,3.717,0,0,0,2.243,1.062,8.628,8.628,0,0,1,1.555.481c-0.058.628-.671,0.513-1.045,0.484-1.128-.088-2.263-0.263-3.432-0.408-0.333-.541-0.323-1.223-1.4-1.507-0.913-.24-1.781-0.638-2.678-0.943a1.587,1.587,0,0,1-1.387-1.312,1.585,1.585,0,0,0-.912-0.8,7.394,7.394,0,0,0-1.962-.468,2.882,2.882,0,0,1-1.768-1c-2.982-.458-5.935-0.322-8.7-1.383-0.215-.545.079-0.7,0.481-0.681,0.754,0.031,1.518.1,2.276,0.2,3.494,0.453,6.988.923,10.737,1.42a10.332,10.332,0,0,0,4.293,2.5,8.312,8.312,0,0,1,1.274.6,8.882,8.882,0,0,1,.923.713l-0.488,1.1Zm78.928,29.821-0.752,1.008a2.726,2.726,0,0,1-.605.093q-1.976-.181-3.953-0.395a2.663,2.663,0,0,0-1.783.333,2.711,2.711,0,0,1-.926-0.1c0.018-1.342,1.54-2,1.68-3.295a6.5,6.5,0,0,1,2.034.42,7.484,7.484,0,0,0,3.6,1.031l1.135-.991a15.469,15.469,0,0,0,1.949,1.545,16.966,16.966,0,0,0,2.466.951c-0.437.761,0.028,1.837-1.639,1.771C367.7,88.412,367.648,86.848,365.533,86.912Zm-64.257-38.99a6.034,6.034,0,0,1,1.341-.3c1.122,0.03,2.258.15,3.385,0.207s2.262,0.074,3.393.118a3.866,3.866,0,0,1,1.122.1,32.35,32.35,0,0,0,6.759,1.234c0.287,0.041.578,0.062,0.858,0.129,1.294,0.31,2.586.633,3.876,0.95-0.3,1.09-.661,1.312-1.66.983-0.716-.236-1.4-0.541-2.093-0.81a1.378,1.378,0,0,1-.413.414c-0.82-.232-1.625-0.51-2.432-0.78a2.356,2.356,0,0,0-.8-0.27c-1.415.4-2.785-.352-4.171-0.542a11.3,11.3,0,0,0-2.269-.21c-2,.152-3.978-0.472-5.963-0.722A3.994,3.994,0,0,1,301.276,47.922ZM-10.614,70.8l-0.536-1.057-2.126.293A6.139,6.139,0,0,0-17.7,69.008a3.977,3.977,0,0,1-2.841-1.058,0.517,0.517,0,0,1,.235-0.876,2.008,2.008,0,0,1,.808-0.031,20.706,20.706,0,0,0,5.839.428l1.309,1.213a12.475,12.475,0,0,1,6.458,1.971C-7.291,71.357-9.042,70.507-10.614,70.8ZM392.338,237.013c-0.714.4-1.162,0.688-1.667,0.916-0.523.237-1.1,0.414-1.747,0.651l-4.066-.736c-0.973-1.125-2.109-2.12-1.069-3.238C386.773,234.412,389.286,235.822,392.338,237.013Zm-6.751,27.172c-3.411-.108-6.619-0.212-9.825-0.308a0.934,0.934,0,0,1-1.055-.726c2.059-.18,4.013-0.707,6.268-0.283a3.892,3.892,0,0,0,3.277-.6c0.06-.047.129-0.088,0.189-0.135,0.97-.766,2.124-0.829,3.666-0.011a2.81,2.81,0,0,1-.8.662,12.091,12.091,0,0,1-1.329.171C385.448,263.067,385.4,263.3,385.587,264.185ZM-21.63,66.718c-0.486.15-.963,0.311-1.458,0.446A2.666,2.666,0,0,1-26.348,66a6.982,6.982,0,0,0-1.79-2.181c1.57-.757,3,0.171,4.437.456l-0.015-.1a17.187,17.187,0,0,0,2.081,2.548ZM364.937,276.655a4.31,4.31,0,0,1,3.5,2.643,1.666,1.666,0,0,1-1.953.266c-1.161-.384-2.365-0.665-3.555-0.992C363.164,277.681,363.164,277.681,364.937,276.655ZM-88.129,147.982a12.818,12.818,0,0,1,3.59.151c2.057,0.369,4.1.9,6.141,1.371a0.467,0.467,0,0,1,.23.143,0.766,0.766,0,0,1,.229.386,0.378,0.378,0,0,1-.306.256,3.333,3.333,0,0,1-.841-0.039c-2.636-.413-5.22-1.238-7.887-1.468A1.247,1.247,0,0,1-88.129,147.982ZM6.708,74.56L4.7,74.029a3.059,3.059,0,0,1-.867.711,1.929,1.929,0,0,1-1.068-.127A13.612,13.612,0,0,1,.718,73.7a0.839,0.839,0,0,1-.362-0.756,0.792,0.792,0,0,1,.666-0.463,5.9,5.9,0,0,1,1.91.3,4.415,4.415,0,0,0,1.879.39C5.519,73.134,5.965,73.621,6.708,74.56Zm-84.86,26.533a3.65,3.65,0,0,1-2.449-.166c-1.966-.451-3.868-1.21-5.933-1.19a6.745,6.745,0,0,1-1.956-.885,6.783,6.783,0,0,1,1.648-.2q2.825,0.485,5.636,1.095a6.18,6.18,0,0,1,3.062,1.4Zm-15.416,50.421a18.906,18.906,0,0,1,6.333,1.209,3.152,3.152,0,0,1,.81.613,0.27,0.27,0,0,1-.019.189,0.948,0.948,0,0,1-.414.154q-2.547-.408-5.091-0.856a1.8,1.8,0,0,1-.524-0.213,1.96,1.96,0,0,1-.437-0.314C-93.089,152.117-93.231,151.92-93.568,151.514ZM366.153,92.125c0.456-.2.99-0.4,1.452-0.662s0.884-.6,1.333-0.918a2.869,2.869,0,0,1,.84.191c0.831,0.548.919,1.041,0.269,1.383-0.97.511-1.965,1-3,1.518A1.431,1.431,0,0,1,366.153,92.125Zm30.92,159.252a0.746,0.746,0,0,1,.046-0.363,8.438,8.438,0,0,0,2.5-.953,2.786,2.786,0,0,1,1.592.074,2.119,2.119,0,0,1,.64.748A9.6,9.6,0,0,1,397.073,251.377Zm37.05-52.758a1.389,1.389,0,0,1-.9-1.451,0.964,0.964,0,0,1,.4-0.23,14.847,14.847,0,0,1,2.179.069,1.377,1.377,0,0,1,.724.625,0.489,0.489,0,0,1-.2.528C435.89,198.487,435.63,198.515,434.123,198.619Zm-31.485-64.364a0.951,0.951,0,0,1,1.151-.281,0.98,0.98,0,0,0,1.2,0c0.765-.8,1.758-0.71,2.88.021a3.3,3.3,0,0,0,.756.248c-0.4.6-1.115-.191-1.6,0.013,0,0.134.01,0.267,0.017,0.46a11.7,11.7,0,0,1-4.42-.55Zm34.255,24.821c-1.92-.522-3.629-0.974-5.324-1.468a0.683,0.683,0,0,1-.389-0.534,0.708,0.708,0,0,1,.618-0.215q2.315,0.739,4.593,1.564A2.007,2.007,0,0,1,436.893,159.076Zm-506.672-56.15a1.693,1.693,0,0,1-.789.434,14.277,14.277,0,0,1-5.67-1.885,8.521,8.521,0,0,1,1.206.082c1.757,0.471,3.509.96,5.263,1.443Zm460.138,47.5,1.534,0.882c-2.01.649-2.15,0.655-3.8,0.125Zm23.383-14.683a3.9,3.9,0,0,1-2.906.061,0.789,0.789,0,0,1-.492-0.486,0.71,0.71,0,0,1,.386-0.624,3.775,3.775,0,0,1,2.9.482l0-.051,0.129,0.7S413.742,135.744,413.742,135.744Zm-3.228,71.1a26.606,26.606,0,0,1,2.682-.079,4.918,4.918,0,0,1,1.374.689l-1.744,1.1-2.319-1.792ZM309.289,45.241a4.181,4.181,0,0,1,2.74,1.118,2.194,2.194,0,0,1-2.183.38C308.99,46.517,308.81,46.066,309.289,45.241Zm-39.737,8.751a2.818,2.818,0,0,1-2.739.352,6.894,6.894,0,0,1-2.323-1.12,7.761,7.761,0,0,1,1.174.048c1.3,0.244,2.592.529,3.888,0.8V53.992ZM30.059,0.719a16.975,16.975,0,0,1-2.09.739,1.431,1.431,0,0,1-.943-0.37,0.573,0.573,0,0,1,.042-0.7C27.8-.24,28.259-0.2,30.059.719Zm-63.59,60.832c1.987-.4,2.693.863,4.415,1.65a6.375,6.375,0,0,1-1.549-.087C-31.571,62.667-32.433,62.159-33.531,61.551Zm404.81,220.725c-1.281.011-2.56,0.033-3.845,0.022a9.617,9.617,0,0,1-1.3-.229,3.71,3.71,0,0,1,1.918-.43c0.518-.089,1.017-0.216,1.64-0.351l1.583,0.975Zm51.3-77.555a5.392,5.392,0,0,1-4.269.157A6.11,6.11,0,0,1,422.575,204.721ZM238.607,57.615A6.36,6.36,0,0,1,241.14,58c-0.465.625-.458,0.644-2.222,0.392-0.1-.267-0.2-0.548-0.3-0.829Zm70.04,7.911a0.54,0.54,0,0,0-.167.137,0.741,0.741,0,0,1-1.219.193,1.589,1.589,0,0,1,.013-0.993l1.393,0.739Zm33.284-10.389a1.455,1.455,0,0,1,2.206-.007,0.323,0.323,0,0,1,.087.361,0.538,0.538,0,0,1-.437.15c-0.64-.157-1.271-0.355-1.9-0.538Zm63.5,55.972-1.486.064c-0.024-.44-0.047-0.859-0.073-1.337,0.9,0.319,1.53.621,1.511,1.294ZM364.7,281.564a3.949,3.949,0,0,1-.943.21,1.579,1.579,0,0,1-.544-0.392,1.186,1.186,0,0,1,.549-0.233,5.6,5.6,0,0,1,.951.483ZM368.983,96.6c0.351,0.168.68,0.3,0.964,0.474a0.359,0.359,0,0,1,.158.346,0.668,0.668,0,0,1-.488.1C369.082,97.39,368.808,97.118,368.983,96.6Zm46.494,25.547,1.756,0.535c0.034,0.459-.257.61-0.636,0.387a7.633,7.633,0,0,1-1.134-.969ZM335.269,279.828c-0.082-.289-0.133-0.467-0.183-0.644a2.9,2.9,0,0,1,.69.081,0.427,0.427,0,0,1,.195.348A3.3,3.3,0,0,1,335.269,279.828Zm97.58-73.638c-0.36-.147-0.741-0.3-1.113-0.463a0.183,0.183,0,0,1,0-.172,1.847,1.847,0,0,1,.709-0.04,1.975,1.975,0,0,1,.6.411A1.213,1.213,0,0,1,432.849,206.19ZM-23.7,64.276a3.479,3.479,0,0,1,.7-0.241,0.735,0.735,0,0,1,.468.183,0.265,0.265,0,0,1,.011.335,0.7,0.7,0,0,1-.493.025,4.889,4.889,0,0,1-.7-0.4ZM398.55,152.247l1.992,0.669C399.586,153.033,399.586,153.033,398.55,152.247Zm-129-98.178c0.417,0.182.843,0.353,1.242,0.558a0.27,0.27,0,0,1-.024.322,0.665,0.665,0,0,1-.471-0.018c-0.279-.3-0.5-0.624-0.747-0.94V54.07ZM-64.271,105.085l-0.41-.2a0.606,0.606,0,0,1,.135-0.142,4.484,4.484,0,0,1,.416.192ZM416.714,205.8l-1.751-.147c0.7-.338.7-0.338,1.692,0.185Zm35.511-43.29-0.325-.438a2.766,2.766,0,0,1,.683.024,0.8,0.8,0,0,1,.232.355Zm-23.142-6.019-0.183-.169a1.223,1.223,0,0,1,.439-0.056,0.771,0.771,0,0,1,.256.275ZM-1.657,71.894c0.625,0.066.9,0.229,0.849,0.553a0.735,0.735,0,0,1-.293.264ZM-69.77,103l1.715,0.591a2,2,0,0,1-1.724-.665ZM329.59,50.4a0.334,0.334,0,0,1-.12.135,0.754,0.754,0,0,1-.239-0.008,0.95,0.95,0,0,1,.154-0.2A0.9,0.9,0,0,1,329.59,50.4ZM397.7,109.088c-0.075-.111-0.15-0.223-0.224-0.335a0.678,0.678,0,0,1,.259.029,1.984,1.984,0,0,1,.233.334Zm64.577,108.634a2.707,2.707,0,0,1-.133.341,1.725,1.725,0,0,1-.187.247,1.082,1.082,0,0,1-.361-0.251,0.281,0.281,0,0,1,.187-0.268,1.744,1.744,0,0,1,.49-0.03Zm-48.191-82.25a1.872,1.872,0,0,1,.376.348,0.543,0.543,0,0,1-.03.331,1.52,1.52,0,0,1-.243-0.1c-0.154-.1-0.3-0.206-0.444-0.31l0.02,0.083,0.4-.355h-0.082Zm-148.717,134.7a0.459,0.459,0,0,1-.139.089c-0.152-.067-0.294-0.149-0.439-0.227l0.235-.162C265.138,269.973,265.252,270.074,265.366,270.174ZM-78.144,101.145a2.253,2.253,0,0,1,.522-0.056,0.781,0.781,0,0,1,.266.234,1.161,1.161,0,0,1-.266-0.026c-0.18-.059-0.353-0.135-0.528-0.2Zm463.45,53.013,1.341-.075c-0.535.671-.951,0.151-1.359-0.013ZM326.384,278.069c0.167,0.053.336,0.1,0.5,0.162a0.985,0.985,0,0,1,.2.138,0.674,0.674,0,0,1-.263.006,3.494,3.494,0,0,1-.387-0.3ZM57.476,231.908a0.689,0.689,0,0,1-.164-0.069,0.419,0.419,0,0,1,.072-0.146l0.275,0.123Zm342.267-77.716-0.411.17c-0.054-.363.324-0.009,0.433-0.1ZM253.119,60.142c-0.184-.044-0.371-0.08-0.551-0.136a0.9,0.9,0,0,1-.215-0.139,0.969,0.969,0,0,1,.385,0,2.1,2.1,0,0,1,.4.339Zm-3.411-.757,0.072-.315c-0.027.094-.053,0.187-0.08,0.281Zm-288.5,120.164,0.229,0.337a0.681,0.681,0,0,1-.246,0,2.205,2.205,0,0,1-.236-0.326Zm277.4-121.984-0.305.229,0.3-.179ZM210.542,43.754l-1.1-.276,0.023,0.068a1.129,1.129,0,0,1,1.1.246Zm-2.058-.312-0.2-.069,0.207,0.142Zm81.193,234.286-0.132-.177H289.9a0.258,0.258,0,0,1,.013.18A0.591,0.591,0,0,1,289.677,277.728ZM20.79,17.592l0.191,0.05-0.2-.112ZM-98.819,150.481l0.456,0.064a0.607,0.607,0,0,1-.192.018,1.55,1.55,0,0,1-.253-0.107Zm491.1,72.359-0.222-.041c0.013-.068.027-0.135,0.04-0.2a0.661,0.661,0,0,1,.191.1A0.2,0.2,0,0,1,392.279,222.84ZM73.216,232.7l-0.478-.376,0.2-.075,0.191,0.461Zm252.5,48.087-0.429.1c0-.089-0.011-0.178-0.016-0.268l0.455,0.218ZM-41.831,129.243c-0.014.039-.029,0.077-0.044,0.115a1.02,1.02,0,0,1-.2-0.089,0.205,0.205,0,0,1,.039-0.112Zm394.818-48.7a0.524,0.524,0,0,1-.176-0.082,0.329,0.329,0,0,1,.059-0.161l0.3,0.137Zm23.17,21.865,0.088,0.136-0.184-.073Zm29.1,28.475a0.847,0.847,0,0,1-.245-0.089,0.288,0.288,0,0,1-.046-0.159C405.05,130.713,405.139,130.788,405.253,130.885ZM341.882,55.1a0.536,0.536,0,0,0-.155-0.152,0.418,0.418,0,0,0-.191.053l0.395,0.133Zm-80.414-1.736c-0.037-.049-0.075-0.1-0.113-0.145l0.325,0.007L261.7,53.4Zm-303.842,66.3-0.188-.049,0.172,0.071ZM67.192,232.993a1.367,1.367,0,0,1-.222-0.015,0.24,0.24,0,0,1-.083-0.082l0.317,0.177ZM-78.953,155.837l0.132,0.074-0.1-.1Zm0.032-.023-0.2-.046,0.165,0.069Zm-19.887-5.358-0.179-.044,0.168,0.069ZM405.378,111.13l0.036,0.121,0.012-.142ZM324.314,67.545l0.118,0-0.112-.027Zm0.006-.029-0.184-.039,0.178,0.068Zm90.153,67.594,0.184,0.04-0.207-.116Zm-0.023-.076q-0.185.218-.367,0.437h0.082l-0.531-.346,0,0.051,0.843-.066Zm-24.13-6.488c0.392-.12.584-0.071,0.415,0.283h0.084l-0.5-.33v0.046Zm0.415,0.283,0.553,0.4s-0.024-.114-0.024-0.114l-0.445-.289h-0.084ZM280.645,58.921c0.007-.053.013-0.106,0.019-0.159-0.013.035-.028,0.069-0.041,0.1Zm1.774,1.776-0.008-.068Zm-17.627.145,0.04-.1,0.1,0.082ZM201.7,20.418l0.163-.016-0.17-.035Zm-0.007-.052-0.181.029,0.188,0.023ZM258.023,58.44l0.009,0.075Zm141.742,95.822,0.146,0.1-0.168-.169ZM249.7,59.351l-0.053.148,0.061-.114ZM212.327,43.835l0.208-.007-0.219-.046Zm-0.011-.053-0.8-.039-0.02.046,0.829,0.047ZM389.931,163.055l-0.055-.1-0.042.1h0.1ZM211.518,43.742l-0.976.012,0.025,0.038c0.419,0.477.689,0.295,0.931,0ZM238.352,261.9l-0.939-.009,0.048,0.077q0.2-.185.395-0.372H237.8l0.546,0.362ZM209.442,43.478l-0.958-.036,0.006,0.073,0.975,0.031ZM462.27,217.761l0.158,0.033-0.154-.072Zm-32.147-21.023,0.184,0.046-0.216-.075Zm-13.468,9.1,0.16-.1-0.1.059Zm-15.933,12.339-0.352.335,0.033,0.04,0.383-.36ZM-32.185,65.934l-0.373.042a0.288,0.288,0,0,1,.137-0.087,1.124,1.124,0,0,1,.246.1Zm0.01,0.06,0.2-.05-0.213-.01ZM385.174,226.8l-0.008-.068ZM-21.634,66.726l0.142,0.1c-0.013-.072-0.026-0.144-0.038-0.217l-0.1.1Zm422.18,187.119,0.168,0.055-0.112-.058Zm0.056,0-0.251.04,0.15,0.089,0.045-.126ZM1.82,79.642l0.012,0.072Zm19.316-56.7-0.154.082,0.14-.025Zm304.586,257.9,0.324-.022a0.279,0.279,0,0,1-.128.058,1,1,0,0,1-.206-0.089Zm45.555,1.421c0.123,0,.246.009,0.37,0.012a0.277,0.277,0,0,1-.135.092,0.891,0.891,0,0,1-.233-0.091Zm-6.565-.631,0.156-.068H364.7Zm-38.282-3.56-0.269,0,0.155,0.113,0.068-.112Zm-334.8-91.337a11.279,11.279,0,0,1,3.067,1.014,1.4,1.4,0,0,1-1.848.16,7.417,7.417,0,0,1-1.235-1.248Zm-0.015-.074c-0.453-.025-0.905-0.047-1.359-0.081a0.235,0.235,0,0,1-.064-0.175,0.226,0.226,0,0,1,.159-0.12c0.43,0.142.853,0.3,1.279,0.45Zm349.1,61.994a4.95,4.95,0,0,0-3.191-1.487,12.038,12.038,0,0,1-1.68-.321,0.615,0.615,0,0,1-.391-0.307,0.579,0.579,0,0,1,.177-0.547,1.637,1.637,0,0,1,.954-0.213c1.832,0.287,3.661.628,5.722,0.991l-1.728,1.883h0.137Zm-13.548-3.1,0.081-.086-0.088.018ZM16.129,52.856c1.847-.368,1.847-0.368,3.027.84-1.13.258-2.019-.465-2.991-0.679Zm-0.1,2.351a0.25,0.25,0,0,1-.117.085,0.822,0.822,0,0,1-.21-0.08l0.2-.157Z"/>
                                </svg>
                            </div>      
                       </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
<?php endif; ?>
