<?php
/**
 * Template part for displaying posts in loop
 *
 * @package Bixol
 */
$archive_author_display = bixol_get_opt( 'archive_author_display', true );

$archive_date_on = bixol_get_opt( 'archive_date_on', true );
$archive_categories_display = bixol_get_opt( 'archive_categories_display', true );
$archive_social_share_on = bixol_get_opt( 'archive_social_share_on', false );
$archive_readmore_text = bixol_get_opt( 'archive_readmore_text' );
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('single-hentry archive'); ?>>
    
    <?php if (has_post_thumbnail()) {
        $featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'full'); 
        echo '<div class="entry-featured image-effect-white">'; ?>
            <a href="<?php echo esc_url( get_permalink()); ?>" style="background-image: url(<?php echo esc_url($featured_img_url); ?>);"><?php the_post_thumbnail('full'); ?></a>
            <?php if($archive_date_on) : 
                $year = get_the_date('Y', get_the_ID());
                $year = substr( $year, -2);
                ?>
                <div class="entry-date">
                    <span><?php echo get_the_date('d', get_the_ID()); ?></span>
                    <span><?php echo get_the_date('M', get_the_ID()); ?>, <?php echo esc_attr($year); ?></span>
                </div>
            <?php endif; ?>
        <?php echo '</div>';
    } ?>
    <div class="entry-body">
        <ul class="entry-meta">
            <?php if($archive_author_display == true): 
                $author = get_user_by('id', $post->post_author);
                ?>
                <li class="item-author">
                    <a href="<?php echo esc_url(get_author_posts_url($post->post_author, $author->user_nicename)); ?>"><i class="far fac-user"></i><?php echo esc_html($author->display_name); ?></a>
                </li>
            <?php endif; ?>
            <?php if($archive_categories_display == true) : ?>
                <li class="item--category">
                    <i class="far fac-folder-open"></i>
                    <?php the_terms( get_the_ID(), 'category', '', ', ' ); ?>
                </li>
            <?php endif; ?>
        </ul>

        <h2 class="entry-title">
            <a href="<?php echo esc_url( get_permalink()); ?>">
                <?php if(is_sticky()) { ?>
                    <i class="fa fa-thumb-tack"></i>
                <?php } ?>
                <?php the_title(); ?>
            </a>
        </h2>
        <div class="entry-excerpt">
            <?php
                bixol_entry_excerpt();
                wp_link_pages( array(
                    'before'      => '<div class="page-links">',
                    'after'       => '</div>',
                    'link_before' => '<span>',
                    'link_after'  => '</span>',
                ) );
            ?>
        </div>
        <div class="entry-holder">
            <div class="entry-readmore">
                <a class="btn btn-plus icon-right" href="<?php echo esc_url( get_permalink()); ?>">
                    <?php if(!empty($archive_readmore_text)) { echo esc_attr($archive_readmore_text); } else { echo esc_html__('Read more', 'bixol'); } ?>
                    <span class="icon-abs"><i class="ct-icon-plus"></i></span>
                </a>
            </div>
            <?php if($archive_social_share_on) : ?>
                <div class="entry-social-share">
                    <span class="social-icon fac fac-share-alt"></span>
                    <?php bixol_socials_share_default(); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</article><!-- #post -->