<?php
/**
 * Template part for displaying default header layout
 */
$sticky_on = bixol_get_opt( 'sticky_on', false );
$top_bar = bixol_get_opt( 'top_bar', 'hide' );
$h_introductory = bixol_get_opt( 'h_introductory' );

$h_phone_label = bixol_get_opt( 'h_phone_label' );
$h_phone = bixol_get_opt( 'h_phone' );
$h_phone_link = bixol_get_opt( 'h_phone_link' );

$h_email_label = bixol_get_opt( 'h_email_label' );
$h_email = bixol_get_opt( 'h_email' );
$h_email_link = bixol_get_opt( 'h_email_link' );

$h_time_label2 = bixol_get_opt( 'h_time_label2' );
$h_time2 = bixol_get_opt( 'h_time2' );

$h_btn_on = bixol_get_opt( 'h_btn_on', 'hide' );
$h_btn_text = bixol_get_opt( 'h_btn_text' );
$h_btn_link_type = bixol_get_opt( 'h_btn_link_type', 'page' );
$h_btn_link = bixol_get_opt( 'h_btn_link' );
$h_btn_link_custom = bixol_get_opt( 'h_btn_link_custom' );
$h_btn_target = bixol_get_opt( 'h_btn_target', '_self' );
if($h_btn_link_type == 'page') {
    $h_btn_url = get_permalink($h_btn_link);
} else {
    $h_btn_url = $h_btn_link_custom;
}

$logo_mobile = bixol_get_opt( 'logo_mobile', array( 'url' => get_template_directory_uri().'/assets/images/logo-dark.png', 'id' => '' ) );
?>
<header id="ct-masthead">
    <div id="ct-header-wrap" class="ct-header-layout4 fixed-height <?php if($sticky_on == 1) { echo 'is-sticky'; } ?>">

        <?php if($top_bar == 'show') : ?>
            <div id="ct-topbar" class="ct-topbar-layout2">
                <div class="container">
                    <div class="row">
                        <?php if(!empty($h_introductory)) : ?>
                            <div class="ct-topbar-intro">
                                <?php echo ct_print_html($h_introductory); ?>
                            </div>
                        <?php endif; ?>
                        <div class="ct-topbar-meta">
                            <?php if(!empty($h_phone_label) || !empty($h_phone)) : ?>
                                <div class="ct-topbar-item">
                                    <i class="flaticon-telephone"></i>
                                    <label><?php echo esc_attr($h_phone_label).':'; ?></label>
                                    <a href="tel:<?php echo esc_attr($h_phone_link); ?>"><?php echo esc_attr($h_phone); ?></a>
                                </div>
                            <?php endif; ?>
                            <?php if(!empty($h_email_label) || !empty($h_email)) : ?>
                                <div class="ct-topbar-item">
                                    <i class="fac fa-envelope-open"></i>
                                    <label><?php echo esc_attr($h_email_label).':'; ?></label>
                                    <a href="mailto:<?php echo esc_attr($h_email_link); ?>"><?php echo esc_attr($h_email); ?></a>
                                </div>
                            <?php endif; ?>
                            <div class="ct-topbar-item">
                                <div class="ct-topbar-social">
                                    <?php bixol_social_header(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        
        <div id="ct-header" class="ct-header-main">
            <div class="container">
                <div class="row">
                    <div class="ct-header-branding">
                        <div class="ct-header-branding-inner">
                            <?php get_template_part( 'template-parts/header-branding' ); ?>
                        </div>
                    </div>
                    <div class="ct-header-navigation">
                        <nav class="ct-main-navigation">
                            <div class="ct-main-navigation-inner">
                                <?php if ($logo_mobile['url']) { ?>
                                    <div class="ct-logo-mobile">
                                        <a href="<?php esc_url( esc_url( home_url( '/' ) ) ); ?>" title="<?php esc_attr( get_bloginfo( 'name' ) ); ?>" rel="home"><img src="<?php echo esc_url( $logo_mobile['url'] ); ?>" alt="<?php esc_attr( get_bloginfo( 'name' ) ); ?>"/></a>
                                    </div>
                                <?php } ?>
                                <?php bixol_header_mobile_search(); ?>
                                <?php get_template_part( 'template-parts/header-menu' ); ?>
                                <?php if($h_btn_on == 'show' && !empty($h_btn_text)) : ?>
                                    <div class="ct-header-button ct-header-button-mobile style1">
                                        <a class="btn btn-animate" href="<?php echo esc_url( $h_btn_url ); ?>" target="<?php echo esc_attr($h_btn_target); ?>"><?php echo esc_attr( $h_btn_text ); ?><i class="flaticon flaticon-arrow"></i></a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </nav>
                    </div>
                    <?php if($h_btn_on == 'show' && !empty($h_btn_text)) : ?>
                        <div class="ct-header-button style1">
                            <a class="btn" href="<?php echo esc_url( $h_btn_url ); ?>" target="<?php echo esc_attr($h_btn_target); ?>"><?php echo esc_attr( $h_btn_text ); ?><i class="flaticon flaticon-arrow"></i></a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <div id="ct-menu-mobile">
                <span class="btn-nav-mobile open-menu">
                    <span></span>
                </span>
            </div>
        </div>

    </div>
</header>