<?php
/**
 * Template part for displaying default header layout
 */
$sticky_on = bixol_get_opt( 'sticky_on', false );
$search_icon = bixol_get_opt( 'search_icon', false );

$h_phone_label = bixol_get_opt( 'h_phone_label' );
$h_phone = bixol_get_opt( 'h_phone' );
$h_phone_link = bixol_get_opt( 'h_phone_link' );

$h_email_label = bixol_get_opt( 'h_email_label' );
$h_email = bixol_get_opt( 'h_email' );
$h_email_link = bixol_get_opt( 'h_email_link' );

$h_address_label = bixol_get_opt( 'h_address_label' );
$h_address = bixol_get_opt( 'h_address' );
$h_address_link = bixol_get_opt( 'h_address_link' );

$h_time_label = bixol_get_opt( 'h_time_label' );
$h_time = bixol_get_opt( 'h_time' );


$logo_mobile = bixol_get_opt( 'logo_mobile', array( 'url' => get_template_directory_uri().'/assets/images/logo-dark.png', 'id' => '' ) );
?>
<header id="ct-masthead">
    <div id="ct-header-wrap" class="ct-header-layout5 fixed-height <?php if($sticky_on == 1) { echo 'is-sticky'; } ?>">

        <div id="ct-header-middle">
            <div class="container">
                <div class="row">
                    <div class="ct-header-branding">
                        <div class="ct-header-branding-inner">
                            <?php get_template_part( 'template-parts/header-branding' ); ?>
                        </div>
                    </div>
                    <div class="ct-header-holder">
                        <?php if(!empty($h_email_label) || !empty($h_email)) : ?>
                            <div class="ct-h-middle-item">
                                <div class="ct-h-middle-icon"><i class="flaticon flaticon-mail"></i></div>
                                <div class="ct-h-middle-meta">
                                    <?php if(!empty($h_email)) : ?>
                                        <label><?php echo esc_attr($h_email); ?></label>
                                    <?php endif; ?>
                                    <?php if(!empty($h_email_label)) : ?>
                                        <span><?php echo esc_attr($h_email_label); ?></span>
                                    <?php endif; ?>   
                                </div>
                                <a href="mailto:<?php echo esc_attr($h_email_link); ?>" class="ct-h-middle-link"></a>
                            </div>
                        <?php endif; ?>
                        <?php if(!empty($h_phone_label) || !empty($h_phone)) : ?>
                                <div class="ct-h-middle-item">
                                <div class="ct-h-middle-icon"><i class="flaticon flaticon-phone"></i></div>
                                <div class="ct-h-middle-meta">
                                    <?php if(!empty($h_phone_label)) : ?>
                                        <label><?php echo esc_attr($h_phone_label).':'; ?></label>
                                    <?php endif; ?>
                                    <?php if(!empty($h_phone)) : ?>
                                        <span><?php echo esc_attr($h_phone); ?></span>
                                    <?php endif; ?>   
                                </div>
                                <a href="tel:<?php echo esc_attr($h_phone_link); ?>" class="ct-h-middle-link"></a>
                            </div>
                        <?php endif; ?>
                        <?php if(!empty($h_time_label) || !empty($h_time)) : ?>  
                            <div class="ct-h-middle-item">
                                <div class="ct-h-middle-icon"><i class="flaticon flaticon-alarm-clock"></i></div>
                                <div class="ct-h-middle-meta">
                                    <?php if(!empty($h_time_label)) : ?>
                                        <label><?php echo esc_attr($h_time_label).':'; ?></label>
                                    <?php endif; ?>   
                                    <?php if(!empty($h_time)) : ?>
                                        <span><?php echo esc_attr($h_time); ?></span>
                                    <?php endif; ?>   
                                </div>
                            </div>
                        <?php endif; ?>  
                        <?php if(!empty($h_address_label) || !empty($h_address)) : ?>  
                            <div class="ct-h-middle-item">
                                <div class="ct-h-middle-icon"><i class="flaticon flaticon-pin"></i></div>
                                <div class="ct-h-middle-meta">
                                    <?php if(!empty($h_address_label)) : ?>
                                        <label><?php echo esc_attr($h_address_label); ?></label>
                                    <?php endif; ?>   
                                    <?php if(!empty($h_address)) : ?>
                                        <span><?php echo esc_attr($h_address); ?></span>
                                    <?php endif; ?>   
                                </div>
                                <a href="<?php echo esc_url($h_address_link); ?>" class="ct-h-middle-link"></a>
                            </div>
                        <?php endif; ?> 
                    </div> 
                </div>
            </div>
        </div>
        
        <div id="ct-header" class="ct-header-main">
            <div class="container">
                <div class="row">
                    <div class="ct-header-branding">
                        <div class="ct-header-branding-inner">
                            <?php get_template_part( 'template-parts/header-branding' ); ?>
                        </div>
                    </div>
                    <div class="ct-header-navigation">
                        <nav class="ct-main-navigation">
                            <div class="ct-main-navigation-inner">
                                <?php if ($logo_mobile['url']) { ?>
                                    <div class="ct-logo-mobile">
                                        <a href="<?php esc_url( esc_url( home_url( '/' ) ) ); ?>" title="<?php esc_attr( get_bloginfo( 'name' ) ); ?>" rel="home"><img src="<?php echo esc_url( $logo_mobile['url'] ); ?>" alt="<?php esc_attr( get_bloginfo( 'name' ) ); ?>"/></a>
                                    </div>
                                <?php } ?>
                                <?php bixol_header_mobile_search(); ?>
                                <?php get_template_part( 'template-parts/header-menu' ); ?>
                            </div>
                        </nav>
                    </div>
                    <div class="ct-header-meta">
                        <?php if($search_icon) : ?>
                            <div class="header-right-item h-btn-search"><i class="fac fac-search"></i></div>
                        <?php endif; ?>
                    </div>
                    <?php bixol_social_header(); ?>
                </div>
            </div>

            <div id="ct-menu-mobile">
                <span class="btn-nav-mobile open-menu">
                    <span></span>
                </span>
            </div>
        </div>

    </div>
</header>